/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.hops;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.core.GrowthCraftCore;
import growthcraft.core.block.IBlockRope;
import growthcraft.hops.GrowthCraftHops;
import growthcraft.hops.RenderHops;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class BlockHops
extends Block
implements IBlockRope,
IPlantable {
    private final float growth = GrowthCraftHops.hopVine_growth;
    private final float growth2 = GrowthCraftHops.hopVine_growth2;
    @SideOnly(value=Side.CLIENT)
    public static IIcon[] tex;
    public static Boolean graphicFlag;

    public BlockHops() {
        super(Material.field_151585_k);
        this.func_149675_a(true);
        this.func_149711_c(0.0f);
        this.func_149672_a(field_149779_h);
        this.func_149663_c("grc.hopVine");
        this.func_149647_a(null);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (!this.func_149718_j(world, x, y, z)) {
            world.func_147449_b(x, y, z, GrowthCraftCore.ropeBlock);
        } else {
            int meta = world.func_72805_g(x, y, z);
            float f = this.getGrowthRateLoop(world, x, y, z);
            if (meta < 2) {
                if (random.nextInt((int)(this.growth / f) + 1) == 0) {
                    world.func_72921_c(x, y, z, ++meta, 3);
                }
            } else if ((meta == 2 || meta == 3) && world.func_147439_a(x, y + 1, z) == GrowthCraftCore.ropeBlock && this.func_149718_j(world, x, y + 1, z)) {
                if (random.nextInt((int)(this.growth / f) + 1) == 0) {
                    world.func_147465_d(x, y + 1, z, (Block)this, 2, 3);
                }
            } else if (meta == 2 && random.nextInt((int)(this.growth2 / f) + 1) == 0) {
                world.func_72921_c(x, y, z, ++meta, 3);
            }
        }
    }

    private float getGrowthRateLoop(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y - 1, z) == Blocks.field_150458_ak) {
            return this.getGrowthRate(world, x, y, z);
        }
        for (int loop = 1; loop < 5; ++loop) {
            if (world.func_147439_a(x, y - loop, z) != this) {
                return this.getGrowthRate(world, x, y, z);
            }
            if (!this.isVineRoot(world, x, y - loop, z)) continue;
            return this.getGrowthRate(world, x, y - loop, z);
        }
        return this.getGrowthRate(world, x, y, z);
    }

    private float getGrowthRate(World world, int x, int y, int z) {
        float f = 1.0f;
        Block l = world.func_147439_a(x, y, z - 1);
        Block i1 = world.func_147439_a(x, y, z + 1);
        Block j1 = world.func_147439_a(x - 1, y, z);
        Block k1 = world.func_147439_a(x + 1, y, z);
        Block l1 = world.func_147439_a(x - 1, y, z - 1);
        Block i2 = world.func_147439_a(x + 1, y, z - 1);
        Block j2 = world.func_147439_a(x + 1, y, z + 1);
        Block k2 = world.func_147439_a(x - 1, y, z + 1);
        boolean flag = j1 == this || k1 == this;
        boolean flag1 = l == this || i1 == this;
        boolean flag2 = l1 == this || i2 == this || j2 == this || k2 == this;
        for (int l2 = x - 1; l2 <= x + 1; ++l2) {
            for (int i3 = z - 1; i3 <= z + 1; ++i3) {
                Block block = world.func_147439_a(l2, y - 1, i3);
                float f1 = 0.0f;
                if (block != null && block == Blocks.field_150458_ak) {
                    f1 = 1.0f;
                    if (block.isFertile(world, l2, y - 1, i3)) {
                        f1 = 3.0f;
                    }
                }
                if (l2 != x || i3 != z) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        if (flag2 || flag && flag1) {
            f /= 2.0f;
        }
        return f;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int dir, float par7, float par8, float par9) {
        if (world.func_72805_g(x, y, z) == 3) {
            if (!world.field_72995_K) {
                world.func_72921_c(x, y, z, 2, 3);
                this.func_149642_a(world, x, y, z, new ItemStack(GrowthCraftHops.hops, world.field_73012_v.nextInt(8) + 1));
            }
            return true;
        }
        return false;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y - 1, z) == Blocks.field_150458_ak) {
            return true;
        }
        for (int loop = 1; loop < 5; ++loop) {
            if (world.func_147439_a(x, y - loop, z) != this) {
                return false;
            }
            if (!this.isVineRoot(world, x, y - loop, z)) continue;
            return true;
        }
        return false;
    }

    private boolean isVineRoot(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == this && world.func_147439_a(x, y - 1, z) == Blocks.field_150458_ak && (world.func_72805_g(x, y, z) == 2 || world.func_72805_g(x, y, z) == 3);
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return meta < 3 ? GrowthCraftHops.hopSeeds : GrowthCraftHops.hops;
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return false;
    }

    public boolean canConnectRopeTo(IBlockAccess world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) instanceof IBlockRope;
    }

    public Item func_149650_a(int meta, Random par2Random, int par3) {
        return null;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack(GrowthCraftCore.rope));
        if (world.func_72805_g(x, y, z) == 3) {
            ret.add(new ItemStack(GrowthCraftHops.hops, world.field_73012_v.nextInt(8) + 1));
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        tex = new IIcon[7];
        BlockHops.tex[0] = reg.func_94245_a("grchops:leaves");
        BlockHops.tex[1] = reg.func_94245_a("grchops:leaves_opaque");
        BlockHops.tex[2] = reg.func_94245_a("grchops:bine");
        BlockHops.tex[3] = reg.func_94245_a("grchops:leaves_hops");
        BlockHops.tex[4] = reg.func_94245_a("grccore:rope_1");
        BlockHops.tex[5] = reg.func_94245_a("grchops:leaves_x");
        BlockHops.tex[6] = reg.func_94245_a("grchops:leaves_opaque_x");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta != 0) {
            graphicFlag = !Blocks.field_150362_t.func_149662_c();
            if (meta == 3) {
                return graphicFlag.booleanValue() ? tex[5] : tex[6];
            }
            return graphicFlag.booleanValue() ? tex[0] : tex[1];
        }
        return tex[2];
    }

    public int func_149645_b() {
        return RenderHops.id;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        double d0 = 0.5;
        double d1 = 1.0;
        return ColorizerFoliage.func_77470_a((double)d0, (double)d1);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        return ColorizerFoliage.func_77468_c();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        int r = 0;
        int g = 0;
        int b = 0;
        for (int l1 = -1; l1 <= 1; ++l1) {
            for (int i2 = -1; i2 <= 1; ++i2) {
                int j2 = world.func_72807_a(x + i2, z + l1).func_150571_c(x + i2, y, z + l1);
                r += (j2 & 0xFF0000) >> 16;
                g += (j2 & 0xFF00) >> 8;
                b += j2 & 0xFF;
            }
        }
        return (r / 9 & 0xFF) << 16 | (g / 9 & 0xFF) << 8 | b / 9 & 0xFF;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        boolean flag = this.canConnectRopeTo((IBlockAccess)world, x, y, z - 1);
        boolean flag1 = this.canConnectRopeTo((IBlockAccess)world, x, y, z + 1);
        boolean flag2 = this.canConnectRopeTo((IBlockAccess)world, x - 1, y, z);
        boolean flag3 = this.canConnectRopeTo((IBlockAccess)world, x + 1, y, z);
        boolean flag4 = this.canConnectRopeTo((IBlockAccess)world, x, y - 1, z);
        boolean flag5 = this.canConnectRopeTo((IBlockAccess)world, x, y + 1, z);
        float f = 0.4375f;
        float f1 = 0.5625f;
        float f2 = 0.4375f;
        float f3 = 0.5625f;
        float f4 = 0.4375f;
        float f5 = 0.5625f;
        if (flag) {
            f2 = 0.0f;
        }
        if (flag1) {
            f3 = 1.0f;
        }
        if (flag || flag1) {
            this.func_149676_a(f, f4, f2, f1, f5, f3);
            super.func_149743_a(world, x, y, z, aabb, list, entity);
        }
        f2 = 0.4375f;
        f3 = 0.5625f;
        if (flag2) {
            f = 0.0f;
        }
        if (flag3) {
            f1 = 1.0f;
        }
        if (flag2 || flag3) {
            this.func_149676_a(f, f4, f2, f1, f5, f3);
            super.func_149743_a(world, x, y, z, aabb, list, entity);
        }
        f = 0.4375f;
        f1 = 0.5625f;
        if (flag4) {
            f4 = 0.0f;
        }
        if (flag5) {
            f5 = 1.0f;
        }
        if (flag4 || flag5) {
            this.func_149676_a(f, f4, f2, f1, f5, f3);
            super.func_149743_a(world, x, y, z, aabb, list, entity);
        }
        this.func_149719_a((IBlockAccess)world, x, y, z);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        float f = 0.0625f;
        switch (meta) {
            case 0: {
                this.func_149676_a(6.0f * f, 0.0f, 6.0f * f, 10.0f * f, 5.0f * f, 10.0f * f);
                break;
            }
            case 1: {
                this.func_149676_a(4.0f * f, 0.0f, 4.0f * f, 12.0f * f, 8.0f * f, 12.0f * f);
                break;
            }
            default: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Crop;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }
}

