/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.soundscool.network.packet.client;

import com.dynious.soundscool.handler.SoundHandler;
import com.dynious.soundscool.helper.NetworkHelper;
import com.dynious.soundscool.network.packet.IPacket;
import com.dynious.soundscool.network.packet.server.SoundNotFoundPacket;
import com.dynious.soundscool.sound.Sound;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.DimensionManager;

public class CheckPresencePacket
implements IPacket {
    String fileName;
    int entityID;
    int worldID;

    public CheckPresencePacket() {
    }

    public CheckPresencePacket(String soundName, EntityPlayer player) {
        this.fileName = soundName;
        this.entityID = player.func_145782_y();
        this.worldID = player.func_130014_f_().field_73011_w.field_76574_g;
    }

    @Override
    public void readBytes(ByteBuf bytes) {
        int fileLength = bytes.readInt();
        char[] fileCars = new char[fileLength];
        for (int i = 0; i < fileLength; ++i) {
            fileCars[i] = bytes.readChar();
        }
        this.fileName = String.valueOf(fileCars);
        this.entityID = bytes.readInt();
        this.worldID = bytes.readInt();
        Entity entity = DimensionManager.getProvider((int)this.worldID).field_76579_a.func_73045_a(this.entityID);
        if (entity != null && entity instanceof EntityPlayer) {
            Sound sound = SoundHandler.getSound(this.fileName);
            if (sound != null) {
                NetworkHelper.serverSoundUpload(sound, (EntityPlayer)entity);
            } else {
                NetworkHelper.sendPacketToPlayer(new SoundNotFoundPacket(this.fileName), (EntityPlayer)entity);
            }
        }
    }

    @Override
    public void writeBytes(ByteBuf bytes) {
        bytes.writeInt(this.fileName.length());
        for (char c : this.fileName.toCharArray()) {
            bytes.writeChar((int)c);
        }
        bytes.writeInt(this.entityID);
        bytes.writeInt(this.worldID);
    }
}

