/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.soundscool.network.packet.server;

import com.dynious.soundscool.handler.SoundHandler;
import com.dynious.soundscool.network.packet.IPacket;
import io.netty.buffer.ByteBuf;

public class ServerPlaySoundPacket
implements IPacket {
    String soundName;
    int x;
    int y;
    int z;

    public ServerPlaySoundPacket() {
    }

    public ServerPlaySoundPacket(String soundName, int x, int y, int z) {
        this.soundName = soundName;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void readBytes(ByteBuf bytes) {
        int soundLength = bytes.readInt();
        char[] fileCars = new char[soundLength];
        for (int i = 0; i < soundLength; ++i) {
            fileCars[i] = bytes.readChar();
        }
        this.soundName = String.valueOf(fileCars);
        this.x = bytes.readInt();
        this.y = bytes.readInt();
        this.z = bytes.readInt();
        SoundHandler.playSound(this.soundName, this.x, this.y, this.z);
    }

    @Override
    public void writeBytes(ByteBuf bytes) {
        bytes.writeInt(this.soundName.length());
        for (char c : this.soundName.toCharArray()) {
            bytes.writeChar((int)c);
        }
        bytes.writeInt(this.x);
        bytes.writeInt(this.y);
        bytes.writeInt(this.z);
    }
}

