/*
 * Decompiled with CFR 0.152.
 */
package vazkii.recubed.api.internal;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import vazkii.recubed.api.ReCubedAPI;
import vazkii.recubed.api.internal.Category;
import vazkii.recubed.api.internal.PlayerCategoryData;

public final class ServerData {
    public static final HashMap<String, Category> categories = new HashMap();

    public static void reset() {
        categories.clear();
    }

    public static void wipe() {
        Category category = categories.values().iterator().next();
        ArrayList<Object> playerData = new ArrayList();
        playerData = new ArrayList<String>(category.playerData.keySet());
        ServerData.reset();
        ServerData.init();
        for (Category category_ : categories.values()) {
            for (String string : playerData) {
                category_.playerData.put(string, new PlayerCategoryData(string));
            }
        }
    }

    public static void init() {
        for (String cat : ReCubedAPI.categories) {
            ServerData.registerCategory(cat);
        }
    }

    public static void registerCategory(String name) {
        categories.put(name, new Category(name));
    }

    public static void onPlayerLogin(String name) {
        for (Category cat : categories.values()) {
            HashMap<String, PlayerCategoryData> data = cat.playerData;
            if (data.containsKey(name)) continue;
            data.put(name, new PlayerCategoryData(name));
        }
    }

    public static void loadFromNBT(NBTTagCompound cmp) {
        for (String s : categories.keySet()) {
            if (!cmp.hasKey(s)) continue;
            NBTTagCompound cmp1 = cmp.getCompoundTag(s);
            categories.get(s).loadFromNBT(cmp1);
        }
    }

    public static void writeToNBT(NBTTagCompound cmp) {
        for (String s : categories.keySet()) {
            NBTTagCompound cmp1 = new NBTTagCompound();
            categories.get(s).writeToNBT(cmp1);
            cmp.setTag(s, (NBTBase)cmp1);
        }
    }
}

