/*
 * Decompiled with CFR 0.152.
 */
package vazkii.recubed.client.gui;

import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import vazkii.recubed.api.internal.Category;
import vazkii.recubed.api.internal.PlayerCategoryData;
import vazkii.recubed.client.gui.GuiCategoryList;
import vazkii.recubed.client.gui.GuiReCubedMenu;
import vazkii.recubed.client.renders.PieChartRender;
import vazkii.recubed.common.core.helper.MiscHelper;

public class GuiStatViewer
extends GuiCategoryList {
    Object category;
    PieChartRender.Entry hoveredEntry;
    GuiTextField searchBar;
    GuiButton visit;
    String unlocalized;

    @Override
    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        this.buttonList.add(new GuiButton(0, this.x + 340, this.y + 145, 50, 20, StatCollector.translateToLocal((String)"recubed.misc.back")));
        this.buttonList.add(new GuiButton(1, this.x + 310, this.y + 170, 80, 20, StatCollector.translateToLocal((String)"recubed.misc.your_stats")));
        String search = StatCollector.translateToLocal((String)"recubed.misc.search");
        this.searchBar = new GuiTextField(this.fontRendererObj, this.x + this.fontRendererObj.getStringWidth(search) + 5, this.y - 20, 150, 18);
        this.searchBar.setFocused(true);
        this.searchBar.setCanLoseFocus(false);
        this.searchBar.setMaxStringLength(32);
        this.searchBar.setVisible(false);
        this.visit = new GuiButton(2, this.x + this.guiWidth - 70, this.y - 20, 70, 20, StatCollector.translateToLocal((String)"recubed.misc.see_stats"));
        this.buttonList.add(this.visit);
        this.visit.visible = false;
    }

    @Override
    public void drawScreen(int par1, int par2, float par3) {
        PieChartRender pie;
        super.drawScreen(par1, par2, par3);
        this.hoveredEntry = null;
        PieChartRender pieChartRender = pie = this.category instanceof Category ? PieChartRender.fromCategory((Category)this.category) : PieChartRender.fromPlayerData((PlayerCategoryData)this.category);
        if (pie == null) {
            this.drawCenteredString(this.fontRendererObj, StatCollector.translateToLocal((String)"recubed.no_data"), this.x + 250, this.y + 95, 0xFF7777);
        } else {
            this.hoveredEntry = pie.renderChart(80, this.x + 250, this.y + 100, par1, par2);
            String text = String.format(StatCollector.translateToLocal((String)"recubed.misc.total"), pie.totalVal);
            if (this.fromCurrentCategoryInt().isFrozen) {
                text = text + EnumChatFormatting.AQUA + StatCollector.translateToLocal((String)"recubed.misc.frozen_suffix");
            }
            this.fontRendererObj.drawStringWithShadow(text, this.x + 134, this.y + 188, 0xFFFFFF);
        }
        String displayString = StatCollector.translateToLocal((String)this.fromCurrentCategoryInt().name);
        int width = this.fontRendererObj.getStringWidth(displayString);
        int xPos = this.x + 250 - width / 2;
        if (this.category instanceof PlayerCategoryData) {
            displayString = displayString + " - ";
            width = this.fontRendererObj.getStringWidth(displayString);
            xPos = this.x + 250 - width / 2;
            String name = ((PlayerCategoryData)this.category).name;
            int color = MiscHelper.generateColorFromString(name);
            this.fontRendererObj.drawStringWithShadow(name, (xPos -= this.fontRendererObj.getStringWidth(name) / 2) + width, this.y + 5, color);
        }
        this.fontRendererObj.drawStringWithShadow(displayString, xPos, this.y + 5, 0xFFFFFF);
        this.searchBar.drawTextBox();
        String search = StatCollector.translateToLocal((String)"recubed.misc.search");
        int length = this.fontRendererObj.getStringWidth(search);
        String text = this.searchBar.getText();
        if (text.isEmpty()) {
            GL11.glEnable((int)3042);
            this.fontRendererObj.drawStringWithShadow(StatCollector.translateToLocal((String)"recubed.misc.type_to_search"), this.x + length + 10, this.y - 15, 0x66FFFFFF);
            GL11.glDisable((int)3042);
            this.visit.visible = false;
        } else {
            PlayerCategoryData data;
            this.fontRendererObj.drawStringWithShadow(search, this.x, this.y - 15, 0xFFFFFF);
            Category currentCategory = this.fromCurrentCategoryInt();
            boolean found = false;
            int color = 0;
            int value = 0;
            int total = 0;
            if (this.category instanceof Category) {
                data = this.getValueFromCaseInsensitveString(currentCategory.playerData, text);
                if (data != null) {
                    color = MiscHelper.generateColorFromString(data.name);
                    value = data.getTotalValue();
                    found = true;
                    total = currentCategory.getTotalValue();
                }
            } else {
                data = (PlayerCategoryData)this.category;
                Integer value_ = this.getValueFromCaseInsensitveString(data.stats, text);
                if (value_ != null) {
                    color = MiscHelper.generateColorFromString(this.unlocalized);
                    value = value_;
                    found = true;
                    total = data.getTotalValue();
                }
            }
            if (found) {
                GuiStatViewer.drawRect((int)(this.x + length + 137), (int)(this.y - 20), (int)(this.x + length + 155), (int)(this.y - 2), (int)color);
                float percentage = (float)Math.round((float)value / (float)total * 100.0f * 100.0f) / 100.0f;
                this.fontRendererObj.drawStringWithShadow(value + " (" + percentage + "%)", this.x + length + 160, this.y - 15, 0xFFFFFF);
                this.visit.visible = this.category instanceof Category;
                if (this.mc.gameSettings.advancedItemTooltips) {
                    this.fontRendererObj.drawStringWithShadow(EnumChatFormatting.ITALIC + this.unlocalized, this.x + length + 10, this.y - 32, 0xFFFFFF);
                }
            } else {
                this.fontRendererObj.drawStringWithShadow("0 (0%)", this.x + length + 160, this.y - 15, 0xFFFFFF);
                this.visit.visible = false;
            }
        }
    }

    public <T> T getValueFromCaseInsensitveString(Map<String, T> map, String key) {
        for (String k : map.keySet()) {
            if (StatCollector.translateToLocal((String)k).compareToIgnoreCase(key) != 0) continue;
            this.unlocalized = k;
            return map.get(k);
        }
        return null;
    }

    protected void keyTyped(char par1, int par2) {
        super.keyTyped(par1, par2);
        this.searchBar.textboxKeyTyped(par1, par2);
        this.searchBar.setVisible(!this.searchBar.getText().isEmpty());
    }

    public void clearSearchBar() {
        if (this.searchBar != null) {
            this.searchBar.setText("");
            this.searchBar.setVisible(false);
        }
    }

    protected void actionPerformed(GuiButton par1GuiButton) {
        Category category = this.fromCurrentCategoryInt();
        switch (par1GuiButton.id) {
            case 0: {
                if (this.category instanceof PlayerCategoryData) {
                    this.category = category;
                    this.clearSearchBar();
                } else {
                    this.mc.displayGuiScreen((GuiScreen)new GuiReCubedMenu());
                }
                return;
            }
            case 1: {
                this.category = category.playerData.get(this.mc.thePlayer.getGameProfile().getName());
                this.clearSearchBar();
                return;
            }
            case 2: {
                String text = this.unlocalized;
                this.category = this.fromCurrentCategoryInt().playerData.get(text);
                this.clearSearchBar();
                return;
            }
        }
    }

    protected void mouseClicked(int par1, int par2, int par3) {
        if (this.category instanceof Category && par3 == 0 && this.hoveredEntry != null && this.shouldVisitStats() && !this.hoveredEntry.name.equals("recubed.misc.others")) {
            Category category = (Category)this.category;
            this.category = category.playerData.get(this.hoveredEntry.name);
            this.clearSearchBar();
        }
        this.searchBar.mouseClicked(par1, par2, par3);
        super.mouseClicked(par1, par2, par3);
    }

    boolean shouldVisitStats() {
        return true;
    }

    @Override
    public void selectCategory(int category) {
        boolean isCurrentCategory = this.category instanceof Category;
        super.selectCategory(category);
        this.category = this.fromCurrentCategoryInt();
        if (!isCurrentCategory) {
            this.clearSearchBar();
        }
    }
}

