/*
 * Decompiled with CFR 0.152.
 */
package vazkii.recubed.client.renders;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import vazkii.recubed.api.internal.Category;
import vazkii.recubed.api.internal.PlayerCategoryData;
import vazkii.recubed.client.core.handler.ClientCacheHandler;
import vazkii.recubed.client.core.helper.RenderHelper;
import vazkii.recubed.common.core.helper.MiscHelper;

public final class StatBarsRender {
    static ResourceLocation hudBar = new ResourceLocation("recubed:textures/hudBar.png");
    public Collection<Entry> entries = new TreeSet<Entry>();
    public final boolean isCategory;
    final String displayName;
    Object data;

    public static StatBarsRender fromCategory(Category category) {
        if (category == null) {
            return null;
        }
        StatBarsRender render = new StatBarsRender(true, StatCollector.translateToLocal((String)category.name));
        for (String s : category.playerData.keySet()) {
            render.entries.add(new Entry(category.getTotalValueFromPlayerData(s), s));
        }
        render.data = category;
        int totalVal = render.getTotalVal();
        render.sortValues(totalVal);
        return render;
    }

    public static StatBarsRender fromPlayerData(PlayerCategoryData data, Category category) {
        if (data == null || category == null) {
            return null;
        }
        StatBarsRender render = new StatBarsRender(false, StatCollector.translateToLocal((String)category.name) + " - " + data.name);
        if (data != null) {
            for (String s : data.stats.keySet()) {
                render.entries.add(new Entry(data.stats.get(s), s));
            }
            render.data = data;
        }
        int totalVal = render.getTotalVal();
        render.sortValues(totalVal);
        return render;
    }

    private int getTotalVal() {
        int totalValue = 0;
        for (Entry entry : this.entries) {
            totalValue += entry.val;
        }
        float mul = 100.0f / (float)totalValue;
        for (Entry entry : this.entries) {
            entry.percentage = (float)Math.round((float)entry.val * mul * 100.0f) / 100.0f;
        }
        return totalValue;
    }

    private void sortValues(int totalValue) {
        ArrayList<Entry> sortedEntries = new ArrayList<Entry>(this.entries);
        Collections.sort(sortedEntries, new Comparator<Entry>(){

            @Override
            public int compare(Entry a, Entry b) {
                return b.val - a.val;
            }
        });
        ArrayList<Entry> newEntries = new ArrayList<Entry>();
        int totalVal = 0;
        float totalPercentage = 0.0f;
        int size = 14;
        int i = 0;
        boolean addedClientPlayer = false;
        String name = Minecraft.getMinecraft().thePlayer.getGameProfile().getName();
        int clientPos = 0;
        for (Entry entry : sortedEntries) {
            if (entry.name.equals(name)) {
                clientPos = i;
                break;
            }
            ++i;
        }
        i = 0;
        for (Entry entry : sortedEntries) {
            if (i >= size) {
                if (!this.isCategory) {
                    Entry othersEntry = new Entry(totalValue - totalVal, "recubed.misc.others");
                    othersEntry.pos = 15;
                    othersEntry.percentage = (float)Math.round((100.0f - totalPercentage) * 100.0f) / 100.0f;
                    newEntries.add(othersEntry);
                    break;
                }
                if (!addedClientPlayer) {
                    Category category = (Category)this.data;
                    Entry playerEntry = new Entry(category.getTotalValueFromPlayerData(name), name);
                    playerEntry.pos = clientPos;
                    newEntries.add(playerEntry);
                    break;
                }
            }
            totalVal += entry.val;
            totalPercentage += entry.percentage;
            entry.pos = i + 1;
            newEntries.add(entry);
            if (i >= size) break;
            ++i;
        }
        this.entries = newEntries;
    }

    private StatBarsRender(boolean isCategory, String displayName) {
        this.isCategory = isCategory;
        this.displayName = displayName;
    }

    public void renderStatBars(int x, int y) {
        int width = 100;
        int height = 98;
        Tessellator tess = Tessellator.instance;
        Minecraft mc = Minecraft.getMinecraft();
        GL11.glEnable((int)3042);
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        Gui.drawRect((int)x, (int)(y + 8), (int)(x + 100), (int)(y + 98), (int)0x77000000);
        int yp = 8;
        for (Entry entry : this.entries) {
            if (!ClientCacheHandler.useGradients) {
                Gui.drawRect((int)x, (int)(y + yp), (int)(x + 100), (int)(y + 6 + yp), (int)entry.color);
            } else {
                Color color = new Color(entry.color).brighter();
                Color color1 = ClientCacheHandler.useGradients ? new Color(entry.color).darker().darker() : color;
                RenderHelper.drawGradientRect(x, y + yp, 0.0f, x + 100, y + 6 + yp, color.getRGB(), color1.getRGB());
            }
            yp += 6;
        }
        GL11.glEnable((int)3553);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        mc.renderEngine.bindTexture(hudBar);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tess.startDrawingQuads();
        tess.addVertexWithUV((double)(x * 2), (double)((y + 8) * 2), 0.0, 0.0, 1.0);
        tess.addVertexWithUV((double)((x + 100) * 2), (double)((y + 8) * 2), 0.0, 1.0, 1.0);
        tess.addVertexWithUV((double)((x + 100) * 2), (double)(y * 2), 0.0, 1.0, 0.0);
        tess.addVertexWithUV((double)(x * 2), (double)(y * 2), 0.0, 0.0, 0.0);
        tess.draw();
        GL11.glPushMatrix();
        for (int i = 0; i < 2; ++i) {
            Gui.drawRect((int)(x * 2), (int)((y + 8) * 2), (int)(x * 2 + 1), (int)((y + 98) * 2), (int)-16777216);
            GL11.glTranslatef((float)199.0f, (float)0.0f, (float)0.0f);
        }
        GL11.glPopMatrix();
        Gui.drawRect((int)(x * 2), (int)((y + 98) * 2 - 1), (int)((x + 100) * 2), (int)((y + 98) * 2), (int)-16777216);
        boolean unicode = mc.fontRenderer.getUnicodeFlag();
        mc.fontRenderer.setUnicodeFlag(!ClientCacheHandler.useVanillaFont);
        mc.fontRenderer.drawStringWithShadow(this.displayName, (x + 4) * 2, (y + 2) * 2, 0xFFFFFF);
        yp = 9;
        for (Entry entry : this.entries) {
            String nameStr;
            String posStr = "#" + entry.pos + " - ";
            String valAndPercentageStr = ": " + entry.val + " (" + entry.percentage + "%)";
            int remainingLenght = 196 - (mc.fontRenderer.getStringWidth(posStr) + mc.fontRenderer.getStringWidth(valAndPercentageStr));
            String name = StatCollector.translateToLocal((String)entry.name);
            if (!name.equals(nameStr = mc.fontRenderer.trimStringToWidth(StatCollector.translateToLocal((String)entry.name), remainingLenght))) {
                String elipsis = "(...)";
                nameStr = mc.fontRenderer.trimStringToWidth(nameStr, remainingLenght -= mc.fontRenderer.getStringWidth(elipsis));
                nameStr = nameStr + elipsis;
            }
            String s1 = posStr + nameStr + valAndPercentageStr;
            int colorRGB = 0xFFFFFF;
            if (ClientCacheHandler.contrastHudText) {
                Color color = new Color(entry.color);
                Color color1 = new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
                colorRGB = color1.getRGB();
            }
            mc.fontRenderer.drawStringWithShadow(s1, (x + 2) * 2, (y + yp) * 2, colorRGB);
            yp += 6;
        }
        mc.fontRenderer.setUnicodeFlag(unicode);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        GL11.glPopMatrix();
    }

    public static class Entry
    implements Comparable<Entry> {
        int val;
        int color;
        int pos;
        float percentage;
        public String name;

        public Entry(int val, String name) {
            this(val, MiscHelper.generateColorFromString(name), name);
        }

        public Entry(int val, int color, String name) {
            this.val = val;
            this.color = color;
            this.name = name;
        }

        @Override
        public int compareTo(Entry e) {
            return this.name.compareTo(e.name);
        }
    }
}

