/*
 * Decompiled with CFR 0.152.
 */
package vazkii.recubed.common.core.handler;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandGive;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.BlockEvent;
import vazkii.recubed.api.ReCubedAPI;
import vazkii.recubed.common.core.helper.MiscHelper;

public final class GeneralEventHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityTakeDamage(ArrowLooseEvent event) {
        float f = (float)event.charge / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        if (ReCubedAPI.validatePlayer(event.entityPlayer)) {
            ReCubedAPI.addValueToCategory("recubed.category.arrows_shot", event.entityPlayer.getGameProfile().getName(), f >= 1.0f ? "recubed.misc.critical_shot" : "recubed.misc.shot", 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        if (ReCubedAPI.validatePlayer(event.getPlayer()) && event.block != null && Item.getItemFromBlock((Block)event.block) != null) {
            ReCubedAPI.addValueToCategory("recubed.category.blocks_broken", event.getPlayer().getGameProfile().getName(), Item.getItemFromBlock((Block)event.block).getUnlocalizedName(new ItemStack(event.block, 1, event.blockMetadata)) + ".name", 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityInteracted(EntityInteractEvent event) {
        if (ReCubedAPI.validatePlayer(event.entityPlayer)) {
            ItemStack currentItem = event.entityPlayer.getCurrentEquippedItem();
            if (currentItem != null && currentItem.getItem() == Items.bucket && event.target instanceof EntityCow) {
                ReCubedAPI.addValueToCategory("recubed.category.cows_milked", event.entityPlayer.getGameProfile().getName(), "item.milk.name", 1);
            }
            if (currentItem != null && currentItem.getItem() == Items.shears && event.target instanceof IShearable && ((IShearable)event.target).isShearable(currentItem, (IBlockAccess)event.target.worldObj, (int)event.target.posX, (int)event.target.posY, (int)event.target.posZ)) {
                ReCubedAPI.addValueToCategory("recubed.category.animals_sheared", event.entityPlayer.getGameProfile().getName(), MiscHelper.getEntityString(event.target), 1);
            }
            if (currentItem != null && currentItem.getItem() instanceof ItemDye && event.target instanceof EntitySheep && !((EntitySheep)event.target).getSheared() && 15 - ((EntitySheep)event.target).getFleeceColor() != currentItem.getItemDamage()) {
                ReCubedAPI.addValueToCategory("recubed.category.sheep_dyed", event.entityPlayer.getGameProfile().getName(), currentItem.getUnlocalizedName() + ".name", 1);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityTakeDamage(LivingHurtEvent event) {
        if (event.source.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.source.getEntity();
            String name = MiscHelper.getEntityString(event.entity);
            if (ReCubedAPI.validatePlayer(player)) {
                ReCubedAPI.addValueToCategory("recubed.category.damage_dealt", player.getGameProfile().getName(), name, (int)Math.min(event.entityLiving.getHealth(), event.ammount));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerTakeDamage(LivingHurtEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            String name = "recubed.damage." + event.source.getDamageType();
            if (event.source.getEntity() != null) {
                name = MiscHelper.getEntityString(event.source.getEntity());
            }
            if (ReCubedAPI.validatePlayer(player)) {
                ReCubedAPI.addValueToCategory("recubed.category.damage_taken", player.getGameProfile().getName(), name, (int)Math.min(player.getHealth(), event.ammount));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemBroken(PlayerDestroyItemEvent event) {
        if (ReCubedAPI.validatePlayer(event.entityPlayer) && event.original.isItemStackDamageable() && event.original.getItemDamage() == event.original.getMaxDamage()) {
            ReCubedAPI.addValueToCategory("recubed.category.items_broken", event.entityPlayer.getGameProfile().getName(), event.original.getUnlocalizedName() + ".name", 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerTossItem(ItemTossEvent event) {
        ItemStack stack = event.entityItem.getEntityItem();
        if (ReCubedAPI.validatePlayer(event.player)) {
            ReCubedAPI.addValueToCategory("recubed.category.items_dropped", event.player.getGameProfile().getName(), stack.getUnlocalizedName() + ".name", stack.stackSize);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemPickedUp(EntityItemPickupEvent event) {
        ItemStack stack = event.item.getEntityItem();
        if (ReCubedAPI.validatePlayer(event.entityPlayer)) {
            ReCubedAPI.addValueToCategory("recubed.category.items_picked_up", event.entityPlayer.getGameProfile().getName(), stack.getUnlocalizedName() + ".name", stack.stackSize);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMessageReceived(ServerChatEvent event) {
        if (ReCubedAPI.validatePlayer((EntityPlayer)event.player)) {
            ReCubedAPI.addValueToCategory("recubed.category.messages_sent", event.username, "recubed.misc.chat", 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMessageReceived(CommandEvent event) {
        if (event.sender instanceof EntityPlayer && ReCubedAPI.validatePlayer((EntityPlayer)event.sender)) {
            ReCubedAPI.addValueToCategory("recubed.category.messages_sent", event.sender.getCommandSenderName(), "/" + event.command.getCommandName(), 1);
            if (event.command instanceof CommandGive) {
                String name = event.parameters[1];
                Item item = CommandBase.getItemByText((ICommandSender)event.sender, (String)name);
                int j = 1;
                int k = 0;
                if (item == null) {
                    return;
                }
                if (event.parameters.length >= 3) {
                    j = CommandBase.parseIntBounded((ICommandSender)event.sender, (String)event.parameters[2], (int)1, (int)64);
                }
                if (event.parameters.length >= 4) {
                    k = CommandBase.parseInt((ICommandSender)event.sender, (String)event.parameters[3]);
                }
                ItemStack stack = new ItemStack(item, j, k);
                ReCubedAPI.addValueToCategory("recubed.category.items_spawned", event.sender.getCommandSenderName(), stack.getUnlocalizedName() + ".name", 1);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMobGetTarget(LivingSetAttackTargetEvent event) {
        EntityPlayer player;
        if (event.target instanceof EntityPlayer && EntityList.getEntityString((Entity)event.entity) != null && ReCubedAPI.validatePlayer(player = (EntityPlayer)event.target)) {
            ReCubedAPI.addValueToCategory("recubed.category.mobs_aggroed", player.getGameProfile().getName(), MiscHelper.getEntityString(event.entity), 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityDie(LivingDeathEvent event) {
        if (event.source.getEntity() instanceof EntityPlayer && !(event.entity instanceof EntityPlayer)) {
            EntityPlayer player = (EntityPlayer)event.source.getEntity();
            String name = MiscHelper.getEntityString(event.entity);
            if (ReCubedAPI.validatePlayer(player)) {
                ReCubedAPI.addValueToCategory(event.entity instanceof IBossDisplayData ? "recubed.category.boss_kills" : "recubed.category.mobs_killed", player.getGameProfile().getName(), name, 1);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerDie(LivingDeathEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            String name = "recubed.damage." + event.source.getDamageType();
            if (event.source.getEntity() != null) {
                name = MiscHelper.getEntityString(event.source.getEntity());
            }
            if (event.source.getEntity() instanceof EntityPlayer) {
                name = ((EntityPlayer)event.source.getEntity()).getGameProfile().getName();
                if (ReCubedAPI.validatePlayer((EntityPlayer)event.source.getEntity())) {
                    ReCubedAPI.addValueToCategory("recubed.category.player_kills", name, player.getGameProfile().getName(), 1);
                }
            }
            if (ReCubedAPI.validatePlayer(player)) {
                ReCubedAPI.addValueToCategory("recubed.category.times_died", player.getGameProfile().getName(), name, 1);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        ItemStack stack;
        if (ReCubedAPI.validatePlayer(event.entityPlayer) && (stack = event.entityPlayer.getCurrentEquippedItem()) != null) {
            if (stack.getItem() == Items.snowball) {
                ReCubedAPI.addValueToCategory("recubed.category.snowballs_thrown", event.entityPlayer.getGameProfile().getName(), "item.snowball.name", 1);
            }
            if (!event.entityPlayer.capabilities.isCreativeMode && stack.getItem() == Items.ender_pearl) {
                ReCubedAPI.addValueToCategory("recubed.category.ender_pearls_thrown", event.entityPlayer.getGameProfile().getName(), "item.enderPearl.name", 1);
            }
            if (stack.getItem() instanceof ItemRecord && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.entityPlayer.worldObj.getBlock(event.x, event.y, event.z) == Blocks.jukebox) {
                ReCubedAPI.addValueToCategory("recubed.category.discs_played", event.entityPlayer.getGameProfile().getName(), ((ItemRecord)stack.getItem()).recordName, 1);
            }
            if (event.entityPlayer.dimension == 0 && stack.getItem() == Items.ender_eye) {
                ReCubedAPI.addValueToCategory("recubed.category.ender_eyes_used", event.entityPlayer.getGameProfile().getName(), "item.eyeOfEnder.name", 1);
            }
            if (stack.getItem() == Items.fishing_rod && event.entityPlayer.fishEntity == null) {
                ReCubedAPI.addValueToCategory("recubed.category.times_fished", event.entityPlayer.getGameProfile().getName(), "recubed.misc.hook_casted", 1);
            }
            if (stack.getItem() == Items.potionitem) {
                ItemPotion potion = (ItemPotion)stack.getItem();
                if (ItemPotion.isSplash((int)stack.getItemDamage())) {
                    List effects = potion.getEffects(stack);
                    for (PotionEffect effect : effects) {
                        ReCubedAPI.addValueToCategory("recubed.category.potions_thrown", event.entityPlayer.getGameProfile().getName(), Potion.potionTypes[effect.getPotionID()].getName(), 1);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerSleep(PlayerSleepInBedEvent event) {
        if (!ReCubedAPI.validatePlayer(event.entityPlayer)) {
            return;
        }
        EntityPlayer.EnumStatus status = event.result;
        if (status == null && !event.entityPlayer.worldObj.isRemote) {
            double d1;
            double d0;
            List list;
            status = event.entityPlayer.isPlayerSleeping() || !event.entityPlayer.isEntityAlive() ? EntityPlayer.EnumStatus.OTHER_PROBLEM : (!event.entityPlayer.worldObj.provider.isSurfaceWorld() ? EntityPlayer.EnumStatus.NOT_POSSIBLE_HERE : (event.entityPlayer.worldObj.isDaytime() ? EntityPlayer.EnumStatus.NOT_POSSIBLE_NOW : (Math.abs(event.entityPlayer.posX - (double)event.x) > 3.0 || Math.abs(event.entityPlayer.posY - (double)event.y) > 3.0 || Math.abs(event.entityPlayer.posZ - (double)event.z) > 3.0 ? EntityPlayer.EnumStatus.TOO_FAR_AWAY : (!(list = event.entityPlayer.worldObj.getEntitiesWithinAABB(EntityMob.class, AxisAlignedBB.getBoundingBox((double)((double)event.x - (d0 = 8.0)), (double)((double)event.y - (d1 = 5.0)), (double)((double)event.z - d0), (double)((double)event.x + d0), (double)((double)event.y + d1), (double)((double)event.z + d0)))).isEmpty() ? EntityPlayer.EnumStatus.NOT_SAFE : EntityPlayer.EnumStatus.OK))));
        }
        if (status == EntityPlayer.EnumStatus.OK) {
            ReCubedAPI.addValueToCategory("recubed.category.times_slept", event.entityPlayer.getGameProfile().getName(), "recubed.misc.sleep", 1);
        }
    }
}

