/*
 * Decompiled with CFR 0.152.
 */
package vazkii.recubed.common.core.handler;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import vazkii.recubed.api.ReCubedAPI;
import vazkii.recubed.api.internal.ServerData;
import vazkii.recubed.common.core.handler.PlayerTickHandler;
import vazkii.recubed.common.core.helper.PlayerLastTickData;
import vazkii.recubed.common.network.PacketCategory;
import vazkii.recubed.common.network.PacketHandler;

public final class PlayerTracker {
    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        String name = event.player.getGameProfile().getName();
        System.out.println(name);
        ServerData.onPlayerLogin(name);
        PlayerLastTickData data = new PlayerLastTickData();
        data.setData(event.player);
        PlayerTickHandler.playerData.put(name, data);
        if (ReCubedAPI.validatePlayer(event.player)) {
            ReCubedAPI.addValueToCategory("recubed.category.times_played", name, "recubed.misc.login", 1);
        }
        for (PacketCategory packet : PacketCategory.allCategoryPackets()) {
            PacketHandler.INSTANCE.sendToAll((IMessage)packet);
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerTickHandler.playerData.remove(event.player);
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (ReCubedAPI.validatePlayer(event.player)) {
            ReCubedAPI.addValueToCategory("recubed.category.dimensions_changed", event.player.getGameProfile().getName(), event.player.worldObj.provider.getDimensionName(), 1);
        }
    }
}

