/*
 * Decompiled with CFR 0.152.
 */
package vazkii.recubed.common.core.helper;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import vazkii.recubed.api.ReCubedAPI;
import vazkii.recubed.common.core.helper.MiscHelper;
import vazkii.recubed.common.lib.LibObfuscation;

public final class PlayerLastTickData {
    int xp;
    int level;
    boolean riding;
    List<Integer> potionEffects = new ArrayList<Integer>();

    public void tickPlayer(EntityPlayer player) {
        if (!ReCubedAPI.validatePlayer(player)) {
            return;
        }
        String name = player.getGameProfile().getName();
        if (!this.riding && player.ridingEntity != null) {
            ReCubedAPI.addValueToCategory("recubed.category.entities_ridden", name, MiscHelper.getEntityString(player.ridingEntity), 1);
        }
        if (player.experienceTotal > this.xp) {
            int extra = player.experienceTotal - this.xp;
            ReCubedAPI.addValueToCategory("recubed.category.experience_gathered", name, "recubed.misc.experience", extra);
        }
        ItemStack itemInUse = (ItemStack)ReflectionHelper.getPrivateValue(EntityPlayer.class, (Object)player, (String[])LibObfuscation.ITEM_IN_USE);
        int itemInUseCount = (Integer)ReflectionHelper.getPrivateValue(EntityPlayer.class, (Object)player, (String[])LibObfuscation.ITEM_IN_USE_COUNT);
        if (itemInUse != null && itemInUseCount == 1) {
            List effects;
            Item item = itemInUse.getItem();
            if (item instanceof ItemFood) {
                ReCubedAPI.addValueToCategory("recubed.category.food_eaten", name, itemInUse.getUnlocalizedName() + ".name", 1);
            }
            if (item instanceof ItemPotion && (effects = ((ItemPotion)item).getEffects(itemInUse)) != null) {
                for (PotionEffect effect : effects) {
                    ReCubedAPI.addValueToCategory("recubed.category.potions_drank", name, Potion.potionTypes[effect.getPotionID()].getName(), 1);
                }
            }
        }
        if (player.experienceLevel > this.level) {
            int extra = player.experienceLevel - this.level;
            ReCubedAPI.addValueToCategory("recubed.category.levels_gained", name, "recubed.misc.level", extra);
        }
        Collection effects = player.getActivePotionEffects();
        for (PotionEffect effect : effects) {
            if (this.potionEffects.contains(effect.getPotionID())) continue;
            ReCubedAPI.addValueToCategory("recubed.category.potions_gotten", name, Potion.potionTypes[effect.getPotionID()].getName(), 1);
        }
        this.setData(player);
    }

    public void setData(EntityPlayer player) {
        this.xp = player.experienceTotal;
        this.level = player.experienceLevel;
        this.riding = player.ridingEntity != null;
        this.potionEffects.clear();
        Collection effects = player.getActivePotionEffects();
        if (effects != null) {
            for (PotionEffect effect : effects) {
                this.potionEffects.add(effect.getPotionID());
            }
        }
    }
}

