/*
 * Decompiled with CFR 0.152.
 */
package vazkii.recubed.client.core.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public final class ClientCacheHandler {
    public static boolean drawHud = true;
    public static boolean useGradients = true;
    public static boolean useVanillaFont = true;
    public static boolean contrastHudText = false;
    public static int hudRelativeTo = 0;
    public static int hudPosX = 0;
    public static int hudPosY = 0;
    public static String hudCategory = "recubed.category.damage_dealt";
    public static String hudPlayer = "";

    public static File getCacheFile() throws IOException {
        File loc = new File(".");
        File cacheFile = new File(loc, "ReCubed.dat");
        if (!cacheFile.exists()) {
            cacheFile.createNewFile();
        }
        return cacheFile;
    }

    public static NBTTagCompound getCacheCompound() {
        File cache = null;
        try {
            cache = ClientCacheHandler.getCacheFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (cache == null) {
            throw new RuntimeException("No cache file!");
        }
        try {
            NBTTagCompound cmp = CompressedStreamTools.readCompressed((InputStream)new FileInputStream(cache));
            return cmp;
        }
        catch (IOException e) {
            NBTTagCompound cmp = new NBTTagCompound();
            try {
                CompressedStreamTools.writeCompressed((NBTTagCompound)cmp, (OutputStream)new FileOutputStream(cache));
                return ClientCacheHandler.getCacheCompound();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return null;
            }
        }
    }

    public static void injectNBTToFile(NBTTagCompound cmp) {
        try {
            File f = ClientCacheHandler.getCacheFile();
            CompressedStreamTools.writeCompressed((NBTTagCompound)cmp, (OutputStream)new FileOutputStream(f));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void findCompoundAndLoad() {
        NBTTagCompound cmp = ClientCacheHandler.getCacheCompound();
        if (cmp.hasNoTags()) {
            Minecraft.getMinecraft();
            hudPosX = 100;
            hudPosY = 98;
            hudRelativeTo = 3;
            ClientCacheHandler.findCompoundAndWrite();
        } else {
            drawHud = cmp.getBoolean("drawHud");
            useGradients = cmp.getBoolean("useGradients");
            useVanillaFont = cmp.getBoolean("useVanillaFont");
            contrastHudText = cmp.getBoolean("contrastHudText");
            hudRelativeTo = cmp.getInteger("hudRelativeTo");
            hudPosX = cmp.getInteger("hudPosX");
            hudPosY = cmp.getInteger("hudPosY");
            hudCategory = cmp.getString("hudCategory");
            hudPlayer = cmp.getString("hudPlayer");
        }
    }

    public static void findCompoundAndWrite() {
        NBTTagCompound cmp = new NBTTagCompound();
        cmp.setBoolean("useGradients", useGradients);
        cmp.setBoolean("contrastHudText", contrastHudText);
        cmp.setBoolean("useVanillaFont", useVanillaFont);
        cmp.setBoolean("drawHud", drawHud);
        cmp.setInteger("hudRelativeTo", hudRelativeTo);
        cmp.setInteger("hudPosX", hudPosX);
        cmp.setInteger("hudPosY", hudPosY);
        cmp.setString("hudCategory", hudCategory);
        cmp.setString("hudPlayer", hudPlayer);
        ClientCacheHandler.injectNBTToFile(cmp);
    }
}

