/*
 * Decompiled with CFR 0.152.
 */
package vazkii.recubed.client.renders;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;
import vazkii.recubed.api.internal.Category;
import vazkii.recubed.api.internal.PlayerCategoryData;
import vazkii.recubed.client.core.handler.ClientCacheHandler;
import vazkii.recubed.client.core.helper.RenderHelper;
import vazkii.recubed.common.core.helper.MiscHelper;

public strictfp final class PieChartRender {
    public boolean clickable;
    public int totalVal;
    public Collection<Entry> entries = new TreeSet<Entry>();

    public static PieChartRender fromCategory(Category category) {
        PieChartRender render = new PieChartRender(true);
        for (String s : category.playerData.keySet()) {
            render.entries.add(new Entry(category.getTotalValueFromPlayerData(s), s));
        }
        int totalVal = render.buildAngles();
        if (totalVal == 0) {
            return null;
        }
        render.truncateSmallValues(totalVal);
        return render;
    }

    public static PieChartRender fromPlayerData(PlayerCategoryData data) {
        PieChartRender render = new PieChartRender(false);
        for (String s : data.stats.keySet()) {
            render.entries.add(new Entry(data.stats.get(s), s));
        }
        int totalVal = render.buildAngles();
        if (totalVal == 0) {
            return null;
        }
        render.truncateSmallValues(totalVal);
        return render;
    }

    private PieChartRender(boolean clickable) {
        this.clickable = clickable;
    }

    private int buildAngles() {
        int totalValue = 0;
        for (Entry entry : this.entries) {
            totalValue += entry.val;
        }
        float mul = 360.0f / (float)totalValue;
        for (Entry entry : this.entries) {
            entry.angle = (float)entry.val * mul;
        }
        return totalValue;
    }

    private void truncateSmallValues(int totalValue) {
        ArrayList<Entry> sortedEntries = new ArrayList<Entry>(this.entries);
        Collections.sort(sortedEntries, new Comparator<Entry>(){

            @Override
            public int compare(Entry a, Entry b) {
                return b.val - a.val;
            }
        });
        ArrayList<Entry> newEntries = new ArrayList<Entry>();
        float totalAngle = 0.0f;
        int totalVal = 0;
        int size = 9;
        int i = 0;
        for (Entry entry : sortedEntries) {
            if (i >= size) {
                Entry othersEntry = new Entry(totalValue - totalVal, "recubed.misc.others");
                othersEntry.angle = 360.0f - totalAngle;
                newEntries.add(othersEntry);
                break;
            }
            totalAngle += entry.angle;
            totalVal += entry.val;
            newEntries.add(entry);
            ++i;
        }
        this.totalVal = totalVal;
        this.entries = newEntries;
    }

    public Entry renderChart(int radius, int x, int y, int mx, int my) {
        boolean mouseInSector;
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        Entry tooltip = null;
        float tooltipDeg = 0.0f;
        boolean mouseIn = (x - mx) * (x - mx) + (y - my) * (y - my) <= radius * radius;
        float angle = PieChartRender.mouseAngle(x, y, mx, my);
        int highlight = 5;
        GL11.glShadeModel((int)7425);
        float totalDeg = 0.0f;
        for (Entry entry : this.entries) {
            Color color1;
            mouseInSector = mouseIn && angle > totalDeg && angle < totalDeg + entry.angle;
            Color color = new Color(entry.color).brighter();
            Color color2 = color1 = ClientCacheHandler.useGradients ? new Color(entry.color).darker().darker() : color;
            if (mouseInSector) {
                tooltip = entry;
                tooltipDeg = totalDeg;
                radius += highlight;
            }
            GL11.glBegin((int)6);
            GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)-1);
            GL11.glVertex2i((int)x, (int)y);
            GL11.glColor4ub((byte)((byte)color1.getRed()), (byte)((byte)color1.getGreen()), (byte)((byte)color1.getBlue()), (byte)-1);
            float i = entry.angle;
            while (i >= 0.0f) {
                float rad = (float)((double)((i + totalDeg) / 180.0f) * Math.PI);
                GL11.glVertex2d((double)((double)x + Math.cos(rad) * (double)radius), (double)((double)y + Math.sin(rad) * (double)radius));
                i = (float)((double)i - 0.01);
            }
            totalDeg += entry.angle;
            GL11.glColor4ub((byte)0, (byte)0, (byte)0, (byte)-1);
            GL11.glVertex2i((int)x, (int)y);
            GL11.glEnd();
            if (!mouseInSector) continue;
            radius -= highlight;
        }
        GL11.glShadeModel((int)7424);
        totalDeg = 0.0f;
        GL11.glLineWidth((float)2.0f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        for (Entry entry : this.entries) {
            if (Math.round(entry.angle) == 360) break;
            boolean bl = mouseInSector = mouseIn && angle > totalDeg && angle < totalDeg + entry.angle;
            if (mouseInSector) {
                radius += highlight;
            }
            float rad = (float)((double)(totalDeg / 180.0f) * Math.PI);
            GL11.glBegin((int)1);
            GL11.glVertex2i((int)x, (int)y);
            GL11.glVertex2d((double)((double)x + Math.cos(rad) * (double)radius), (double)((double)y + Math.sin(rad) * (double)radius));
            GL11.glEnd();
            if (mouseInSector) {
                radius -= highlight;
            }
            totalDeg += entry.angle;
        }
        GL11.glLineWidth((float)3.0f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glBegin((int)2);
        for (float i = 0.0f; i < 360.0f; i += 1.0f) {
            boolean last;
            boolean sectorHighlighted = tooltip != null && i >= tooltipDeg && i < tooltip.angle + tooltipDeg;
            boolean first = tooltip != null && tooltip.angle != 360.0f && i - tooltipDeg == 0.0f;
            boolean bl = last = tooltip != null && tooltip.angle != 360.0f && i - (tooltipDeg + tooltip.angle) == -1.0f;
            if (first) {
                PieChartRender.addVertexForAngle(x, y, i, radius);
            }
            if (sectorHighlighted) {
                radius += highlight;
            }
            PieChartRender.addVertexForAngle(x, y, i, radius);
            if (last) {
                PieChartRender.addVertexForAngle(x, y, i + 1.0f, radius);
            }
            if (!sectorHighlighted) continue;
            radius -= highlight;
        }
        GL11.glEnd();
        if (tooltip != null) {
            ArrayList<String> tooltipList = new ArrayList<String>(Arrays.asList(StatCollector.translateToLocal((String)tooltip.name), EnumChatFormatting.GRAY + "" + tooltip.val + " (" + (double)Math.round((double)(tooltip.angle / 3.6f) * 100.0) / 100.0 + "%)"));
            if (Minecraft.getMinecraft().gameSettings.advancedItemTooltips) {
                tooltipList.add(EnumChatFormatting.GRAY + "" + EnumChatFormatting.ITALIC + tooltip.name);
            }
            RenderHelper.renderTooltip(mx, my, tooltipList);
        }
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
        return tooltip;
    }

    private static void addVertexForAngle(int x, int y, float i, int radius) {
        double rad = (double)(i / 180.0f) * Math.PI;
        GL11.glVertex2d((double)((double)x + Math.cos(rad) * (double)radius), (double)((double)y + Math.sin(rad) * (double)radius));
    }

    private static float mouseAngle(int x, int y, int mx, int my) {
        Vector2f baseVec = new Vector2f(1.0f, 0.0f);
        Vector2f mouseVec = new Vector2f((float)(mx - x), (float)(my - y));
        float ang = (float)(Math.acos(Vector2f.dot((Vector2f)baseVec, (Vector2f)mouseVec) / (baseVec.length() * mouseVec.length())) * 57.29577951308232);
        return my < y ? 360.0f - ang : ang;
    }

    public strictfp static class Entry
    implements Comparable<Entry> {
        int val;
        float angle;
        int color;
        public String name;

        public Entry(int val, String name) {
            this(val, MiscHelper.generateColorFromString(name), name);
        }

        public Entry(int val, int color, String name) {
            this.val = val;
            this.color = color;
            this.name = name;
        }

        @Override
        public int compareTo(Entry e) {
            return this.name.compareTo(e.name);
        }
    }
}

