/*
 * Decompiled with CFR 0.152.
 */
package vazkii.recubed.common.command;

import java.io.File;
import java.io.IOException;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import vazkii.recubed.common.core.helper.CacheHelper;
import vazkii.recubed.common.core.helper.MiscHelper;

public class CommandDelBackup
extends CommandBase {
    public String getCommandName() {
        return "recubed-delbackup";
    }

    public String getCommandUsage(ICommandSender icommandsender) {
        return "recubed-delbackup <name>";
    }

    public void processCommand(ICommandSender icommandsender, String[] astring) {
        if (astring.length != 1) {
            throw new WrongUsageException(this.getCommandUsage(icommandsender), (Object[])astring);
        }
        if (icommandsender instanceof EntityPlayer && !MiscHelper.isPlayerAllowedToUseCommands(icommandsender.getCommandSenderName())) {
            throw new CommandException("recubed.commands.no_perms", new Object[0]);
        }
        String backupName = astring[0];
        try {
            File file = CacheHelper.getCacheFile("ReCubedBackups/", backupName + ".dat", false);
            if (file == null) {
                throw new CommandException("recubed.commands.no_backup", new Object[0]);
            }
            file.delete();
            icommandsender.addChatMessage((IChatComponent)new ChatComponentTranslation("recubed.commands.command_sucessful", new Object[0]));
        }
        catch (IOException e) {
            throw new CommandException(e.getMessage(), (Object[])e.getStackTrace());
        }
    }

    public int getRequiredPermissionLevel() {
        return 3;
    }
}

