/*
 * Decompiled with CFR 0.152.
 */
package vazkii.recubed.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import vazkii.recubed.api.internal.Category;
import vazkii.recubed.api.internal.ServerData;
import vazkii.recubed.common.ReCubed;

public class PacketCategory
implements IMessage,
IMessageHandler<PacketCategory, IMessage> {
    public Category category;
    public String name;

    public PacketCategory() {
    }

    public PacketCategory(Category category) {
        this.category = category;
        this.name = category.name;
    }

    public void toBytes(ByteBuf buffer) {
        PacketBuffer packet = new PacketBuffer(buffer);
        NBTTagCompound cmp = new NBTTagCompound();
        this.category.writeToNBT(cmp);
        try {
            packet.writeStringToBuffer(this.name);
            packet.writeNBTTagCompoundToBuffer(cmp);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Collection<PacketCategory> allCategoryPackets() {
        ArrayList<PacketCategory> packets = new ArrayList<PacketCategory>();
        for (String s : ServerData.categories.keySet()) {
            packets.add(new PacketCategory(ServerData.categories.get(s)));
        }
        return packets;
    }

    public void fromBytes(ByteBuf buffer) {
        PacketBuffer packet = new PacketBuffer(buffer);
        try {
            this.name = packet.readStringFromBuffer(Short.MAX_VALUE);
            this.category = new Category(this.name);
            this.category.loadFromNBT(packet.readNBTTagCompoundFromBuffer());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public IMessage onMessage(PacketCategory message, MessageContext context) {
        ReCubed.proxy.receivePacket(message);
        return null;
    }
}

