/*
 * Decompiled with CFR 0.152.
 */
package com.mpatric.mp3agic;

import com.mpatric.mp3agic.BufferTools;
import com.mpatric.mp3agic.EncodedText;
import com.mpatric.mp3agic.ID3v1Genres;
import com.mpatric.mp3agic.ID3v2;
import com.mpatric.mp3agic.ID3v2ChapterFrameData;
import com.mpatric.mp3agic.ID3v2ChapterTOCFrameData;
import com.mpatric.mp3agic.ID3v2CommentFrameData;
import com.mpatric.mp3agic.ID3v2Frame;
import com.mpatric.mp3agic.ID3v2FrameSet;
import com.mpatric.mp3agic.ID3v2ObseleteFrame;
import com.mpatric.mp3agic.ID3v2ObseletePictureFrameData;
import com.mpatric.mp3agic.ID3v2PictureFrameData;
import com.mpatric.mp3agic.ID3v2TagFactory;
import com.mpatric.mp3agic.ID3v2TextFrameData;
import com.mpatric.mp3agic.ID3v2UrlFrameData;
import com.mpatric.mp3agic.ID3v2WWWFrameData;
import com.mpatric.mp3agic.InvalidDataException;
import com.mpatric.mp3agic.NoSuchTagException;
import com.mpatric.mp3agic.NotSupportedException;
import com.mpatric.mp3agic.UnsupportedTagException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractID3v2Tag
implements ID3v2 {
    public static final String ID_IMAGE = "APIC";
    public static final String ID_ENCODER = "TENC";
    public static final String ID_URL = "WXXX";
    public static final String ID_ARTIST_URL = "WOAR";
    public static final String ID_COMMERCIAL_URL = "WCOM";
    public static final String ID_COPYRIGHT_URL = "WCOP";
    public static final String ID_AUDIOFILE_URL = "WOAF";
    public static final String ID_AUDIOSOURCE_URL = "WOAS";
    public static final String ID_RADIOSTATION_URL = "WORS";
    public static final String ID_PAYMENT_URL = "WPAY";
    public static final String ID_PUBLISHER_URL = "WPUB";
    public static final String ID_COPYRIGHT = "TCOP";
    public static final String ID_ORIGINAL_ARTIST = "TOPE";
    public static final String ID_BPM = "TBPM";
    public static final String ID_COMPOSER = "TCOM";
    public static final String ID_PUBLISHER = "TPUB";
    public static final String ID_COMMENT = "COMM";
    public static final String ID_GENRE = "TCON";
    public static final String ID_YEAR = "TYER";
    public static final String ID_DATE = "TDAT";
    public static final String ID_ALBUM = "TALB";
    public static final String ID_TITLE = "TIT2";
    public static final String ID_KEY = "TKEY";
    public static final String ID_ARTIST = "TPE1";
    public static final String ID_ALBUM_ARTIST = "TPE2";
    public static final String ID_TRACK = "TRCK";
    public static final String ID_PART_OF_SET = "TPOS";
    public static final String ID_COMPILATION = "TCMP";
    public static final String ID_CHAPTER_TOC = "CTOC";
    public static final String ID_CHAPTER = "CHAP";
    public static final String ID_GROUPING = "TIT1";
    public static final String ID_IMAGE_OBSELETE = "PIC";
    public static final String ID_ENCODER_OBSELETE = "TEN";
    public static final String ID_URL_OBSELETE = "WXX";
    public static final String ID_COPYRIGHT_OBSELETE = "TCR";
    public static final String ID_ORIGINAL_ARTIST_OBSELETE = "TOA";
    public static final String ID_BPM_OBSELETE = "TBP";
    public static final String ID_COMPOSER_OBSELETE = "TCM";
    public static final String ID_PUBLISHER_OBSELETE = "TBP";
    public static final String ID_COMMENT_OBSELETE = "COM";
    public static final String ID_GENRE_OBSELETE = "TCO";
    public static final String ID_YEAR_OBSELETE = "TYE";
    public static final String ID_DATE_OBSELETE = "TDA";
    public static final String ID_ALBUM_OBSELETE = "TAL";
    public static final String ID_TITLE_OBSELETE = "TT2";
    public static final String ID_KEY_OBSELETE = "TKE";
    public static final String ID_ARTIST_OBSELETE = "TP1";
    public static final String ID_ALBUM_ARTIST_OBSELETE = "TP2";
    public static final String ID_TRACK_OBSELETE = "TRK";
    public static final String ID_PART_OF_SET_OBSELETE = "TPA";
    public static final String ID_COMPILATION_OBSELETE = "TCP";
    public static final String ID_GROUPING_OBSELETE = "TT1";
    protected static final String TAG = "ID3";
    protected static final String FOOTER_TAG = "3DI";
    protected static final int HEADER_LENGTH = 10;
    protected static final int FOOTER_LENGTH = 10;
    protected static final int MAJOR_VERSION_OFFSET = 3;
    protected static final int MINOR_VERSION_OFFSET = 4;
    protected static final int FLAGS_OFFSET = 5;
    protected static final int DATA_LENGTH_OFFSET = 6;
    protected static final int FOOTER_BIT = 4;
    protected static final int EXPERIMENTAL_BIT = 5;
    protected static final int EXTENDED_HEADER_BIT = 6;
    protected static final int COMPRESSION_BIT = 6;
    protected static final int UNSYNCHRONISATION_BIT = 7;
    protected static final int PADDING_LENGTH = 256;
    private static final String ITUNES_COMMENT_DESCRIPTION = "iTunNORM";
    protected boolean unsynchronisation = false;
    protected boolean extendedHeader = false;
    protected boolean experimental = false;
    protected boolean footer = false;
    protected boolean compression = false;
    protected boolean padding = false;
    protected String version = null;
    private int dataLength = 0;
    private int extendedHeaderLength;
    private byte[] extendedHeaderData;
    private boolean obseleteFormat = false;
    private final Map<String, ID3v2FrameSet> frameSets = new TreeMap<String, ID3v2FrameSet>();

    public AbstractID3v2Tag() {
    }

    public AbstractID3v2Tag(byte[] bytes) throws NoSuchTagException, UnsupportedTagException, InvalidDataException {
        this(bytes, false);
    }

    public AbstractID3v2Tag(byte[] bytes, boolean obseleteFormat) throws NoSuchTagException, UnsupportedTagException, InvalidDataException {
        this.obseleteFormat = obseleteFormat;
        this.unpackTag(bytes);
    }

    private void unpackTag(byte[] bytes) throws NoSuchTagException, UnsupportedTagException, InvalidDataException {
        ID3v2TagFactory.sanityCheckTag(bytes);
        int offset = this.unpackHeader(bytes);
        try {
            if (this.extendedHeader) {
                offset = this.unpackExtendedHeader(bytes, offset);
            }
            int framesLength = this.dataLength;
            if (this.footer) {
                framesLength -= 10;
            }
            offset = this.unpackFrames(bytes, offset, framesLength);
            if (this.footer) {
                offset = this.unpackFooter(bytes, this.dataLength);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new InvalidDataException("Premature end of tag", e);
        }
    }

    private int unpackHeader(byte[] bytes) throws UnsupportedTagException, InvalidDataException {
        byte majorVersion = bytes[3];
        byte minorVersion = bytes[4];
        this.version = majorVersion + "." + minorVersion;
        if (majorVersion != 2 && majorVersion != 3 && majorVersion != 4) {
            throw new UnsupportedTagException("Unsupported version " + this.version);
        }
        this.unpackFlags(bytes);
        if ((bytes[5] & 0xF) != 0) {
            throw new UnsupportedTagException("Unrecognised bits in header");
        }
        this.dataLength = BufferTools.unpackSynchsafeInteger(bytes[6], bytes[7], bytes[8], bytes[9]);
        if (this.dataLength < 1) {
            throw new InvalidDataException("Zero size tag");
        }
        return 10;
    }

    protected abstract void unpackFlags(byte[] var1);

    private int unpackExtendedHeader(byte[] bytes, int offset) {
        this.extendedHeaderLength = BufferTools.unpackSynchsafeInteger(bytes[offset], bytes[offset + 1], bytes[offset + 2], bytes[offset + 3]) + 4;
        this.extendedHeaderData = BufferTools.copyBuffer(bytes, offset + 4, this.extendedHeaderLength);
        return this.extendedHeaderLength;
    }

    protected int unpackFrames(byte[] bytes, int offset, int framesLength) {
        int currentOffset;
        ID3v2Frame frame;
        for (currentOffset = offset; currentOffset <= framesLength; currentOffset += frame.getLength()) {
            try {
                frame = this.createFrame(bytes, currentOffset);
                this.addFrame(frame, false);
                continue;
            }
            catch (InvalidDataException e) {
                break;
            }
        }
        return currentOffset;
    }

    protected void addFrame(ID3v2Frame frame, boolean replace) {
        ID3v2FrameSet frameSet = this.frameSets.get(frame.getId());
        if (frameSet == null) {
            frameSet = new ID3v2FrameSet(frame.getId());
            frameSet.addFrame(frame);
            this.frameSets.put(frame.getId(), frameSet);
        } else if (replace) {
            frameSet.clear();
            frameSet.addFrame(frame);
        } else {
            frameSet.addFrame(frame);
        }
    }

    protected ID3v2Frame createFrame(byte[] bytes, int currentOffset) throws InvalidDataException {
        if (this.obseleteFormat) {
            return new ID3v2ObseleteFrame(bytes, currentOffset);
        }
        return new ID3v2Frame(bytes, currentOffset);
    }

    protected ID3v2Frame createFrame(String id, byte[] data) {
        if (this.obseleteFormat) {
            return new ID3v2ObseleteFrame(id, data);
        }
        return new ID3v2Frame(id, data);
    }

    private int unpackFooter(byte[] bytes, int offset) throws InvalidDataException {
        if (!FOOTER_TAG.equals(BufferTools.byteBufferToStringIgnoringEncodingIssues(bytes, offset, FOOTER_TAG.length()))) {
            throw new InvalidDataException("Invalid footer");
        }
        return 10;
    }

    @Override
    public byte[] toBytes() throws NotSupportedException {
        byte[] bytes = new byte[this.getLength()];
        this.packTag(bytes);
        return bytes;
    }

    public void packTag(byte[] bytes) throws NotSupportedException {
        int offset = this.packHeader(bytes, 0);
        if (this.extendedHeader) {
            offset = this.packExtendedHeader(bytes, offset);
        }
        offset = this.packFrames(bytes, offset);
        if (this.footer) {
            offset = this.packFooter(bytes, this.dataLength);
        }
    }

    private int packHeader(byte[] bytes, int offset) {
        try {
            BufferTools.stringIntoByteBuffer(TAG, 0, TAG.length(), bytes, offset);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        String[] s = this.version.split("\\.");
        if (s.length > 0) {
            byte majorVersion;
            bytes[offset + 3] = majorVersion = Byte.parseByte(s[0]);
        }
        if (s.length > 1) {
            byte minorVersion;
            bytes[offset + 4] = minorVersion = Byte.parseByte(s[1]);
        }
        this.packFlags(bytes, offset);
        BufferTools.packSynchsafeInteger(this.getDataLength(), bytes, offset + 6);
        return offset + 10;
    }

    protected abstract void packFlags(byte[] var1, int var2);

    private int packExtendedHeader(byte[] bytes, int offset) {
        BufferTools.packSynchsafeInteger(this.extendedHeaderLength, bytes, offset);
        BufferTools.copyIntoByteBuffer(this.extendedHeaderData, 0, this.extendedHeaderData.length, bytes, offset + 4);
        return offset + 4 + this.extendedHeaderData.length;
    }

    public int packFrames(byte[] bytes, int offset) throws NotSupportedException {
        int newOffset = this.packSpecifiedFrames(bytes, offset, null, ID_IMAGE);
        newOffset = this.packSpecifiedFrames(bytes, newOffset, ID_IMAGE, null);
        return newOffset;
    }

    private int packSpecifiedFrames(byte[] bytes, int offset, String onlyId, String notId) throws NotSupportedException {
        for (ID3v2FrameSet frameSet : this.frameSets.values()) {
            if (onlyId != null && !onlyId.equals(frameSet.getId()) || notId != null && notId.equals(frameSet.getId())) continue;
            for (ID3v2Frame frame : frameSet.getFrames()) {
                if (frame.getDataLength() <= 0) continue;
                byte[] frameData = frame.toBytes();
                BufferTools.copyIntoByteBuffer(frameData, 0, frameData.length, bytes, offset);
                offset += frameData.length;
            }
        }
        return offset;
    }

    private int packFooter(byte[] bytes, int offset) {
        try {
            BufferTools.stringIntoByteBuffer(FOOTER_TAG, 0, FOOTER_TAG.length(), bytes, offset);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        String[] s = this.version.split("\\.");
        if (s.length > 0) {
            byte majorVersion;
            bytes[offset + 3] = majorVersion = Byte.parseByte(s[0]);
        }
        if (s.length > 1) {
            byte minorVersion;
            bytes[offset + 4] = minorVersion = Byte.parseByte(s[1]);
        }
        this.packFlags(bytes, offset);
        BufferTools.packSynchsafeInteger(this.getDataLength(), bytes, offset + 6);
        return offset + 10;
    }

    private int calculateDataLength() {
        int length = 0;
        if (this.extendedHeader) {
            length += this.extendedHeaderLength;
        }
        if (this.footer) {
            length += 10;
        } else if (this.padding) {
            length += 256;
        }
        for (ID3v2FrameSet frameSet : this.frameSets.values()) {
            for (ID3v2Frame frame : frameSet.getFrames()) {
                length += frame.getLength();
            }
        }
        return length;
    }

    protected boolean useFrameUnsynchronisation() {
        return false;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    protected void invalidateDataLength() {
        this.dataLength = 0;
    }

    @Override
    public int getDataLength() {
        if (this.dataLength == 0) {
            this.dataLength = this.calculateDataLength();
        }
        return this.dataLength;
    }

    @Override
    public int getLength() {
        return this.getDataLength() + 10;
    }

    @Override
    public Map<String, ID3v2FrameSet> getFrameSets() {
        return this.frameSets;
    }

    @Override
    public boolean getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(boolean padding) {
        if (this.padding != padding) {
            this.invalidateDataLength();
            this.padding = padding;
        }
    }

    @Override
    public boolean hasFooter() {
        return this.footer;
    }

    @Override
    public void setFooter(boolean footer) {
        if (this.footer != footer) {
            this.invalidateDataLength();
            this.footer = footer;
        }
    }

    @Override
    public boolean hasUnsynchronisation() {
        return this.unsynchronisation;
    }

    @Override
    public void setUnsynchronisation(boolean unsynchronisation) {
        if (this.unsynchronisation != unsynchronisation) {
            this.invalidateDataLength();
            this.unsynchronisation = unsynchronisation;
        }
    }

    @Override
    public boolean getObseleteFormat() {
        return this.obseleteFormat;
    }

    @Override
    public String getTrack() {
        ID3v2TextFrameData frameData = this.extractTextFrameData(this.obseleteFormat ? ID_TRACK_OBSELETE : ID_TRACK);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setTrack(String track) {
        if (track != null && track.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(track));
            this.addFrame(this.createFrame(ID_TRACK, frameData.toBytes()), true);
        }
    }

    @Override
    public String getPartOfSet() {
        ID3v2TextFrameData frameData = this.extractTextFrameData(this.obseleteFormat ? ID_PART_OF_SET_OBSELETE : ID_PART_OF_SET);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setPartOfSet(String partOfSet) {
        if (partOfSet != null && partOfSet.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(partOfSet));
            this.addFrame(this.createFrame(ID_PART_OF_SET, frameData.toBytes()), true);
        }
    }

    @Override
    public boolean isCompilation() {
        ID3v2TextFrameData frameData = this.extractTextFrameData(this.obseleteFormat ? ID_COMPILATION_OBSELETE : ID_COMPILATION);
        if (frameData != null && frameData.getText() != null) {
            return "1".equals(frameData.getText().toString());
        }
        return false;
    }

    @Override
    public void setCompilation(boolean compilation) {
        this.invalidateDataLength();
        ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(compilation ? "1" : "0"));
        this.addFrame(this.createFrame(ID_COMPILATION, frameData.toBytes()), true);
    }

    @Override
    public String getGrouping() {
        ID3v2TextFrameData frameData = this.extractTextFrameData(this.obseleteFormat ? ID_GROUPING_OBSELETE : ID_GROUPING);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setGrouping(String grouping) {
        if (grouping != null && grouping.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(grouping));
            this.addFrame(this.createFrame(ID_GROUPING, frameData.toBytes()), true);
        }
    }

    @Override
    public String getArtist() {
        ID3v2TextFrameData frameData = this.extractTextFrameData(this.obseleteFormat ? ID_ARTIST_OBSELETE : ID_ARTIST);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setArtist(String artist) {
        if (artist != null && artist.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(artist));
            this.addFrame(this.createFrame(ID_ARTIST, frameData.toBytes()), true);
        }
    }

    @Override
    public String getAlbumArtist() {
        ID3v2TextFrameData frameData = this.extractTextFrameData(this.obseleteFormat ? ID_ALBUM_ARTIST_OBSELETE : ID_ALBUM_ARTIST);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setAlbumArtist(String albumArtist) {
        if (albumArtist != null && albumArtist.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(albumArtist));
            this.addFrame(this.createFrame(ID_ALBUM_ARTIST, frameData.toBytes()), true);
        }
    }

    @Override
    public String getTitle() {
        ID3v2TextFrameData frameData = this.extractTextFrameData(this.obseleteFormat ? ID_TITLE_OBSELETE : ID_TITLE);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setTitle(String title) {
        if (title != null && title.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(title));
            this.addFrame(this.createFrame(ID_TITLE, frameData.toBytes()), true);
        }
    }

    @Override
    public String getAlbum() {
        ID3v2TextFrameData frameData = this.extractTextFrameData(this.obseleteFormat ? ID_ALBUM_OBSELETE : ID_ALBUM);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setAlbum(String album) {
        if (album != null && album.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(album));
            this.addFrame(this.createFrame(ID_ALBUM, frameData.toBytes()), true);
        }
    }

    @Override
    public String getYear() {
        ID3v2TextFrameData frameData = this.extractTextFrameData(this.obseleteFormat ? ID_YEAR_OBSELETE : ID_YEAR);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setYear(String year) {
        if (year != null && year.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(year));
            this.addFrame(this.createFrame(ID_YEAR, frameData.toBytes()), true);
        }
    }

    @Override
    public String getDate() {
        ID3v2TextFrameData frameData = this.extractTextFrameData(this.obseleteFormat ? ID_DATE_OBSELETE : ID_DATE);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setDate(String date) {
        if (date != null && date.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(date));
            this.addFrame(this.createFrame(ID_DATE, frameData.toBytes()), true);
        }
    }

    private int getGenre(String text) {
        if (text != null && text.length() > 0) {
            try {
                return this.extractGenreNumber(text);
            }
            catch (NumberFormatException e) {
                String description = this.extractGenreDescription(text);
                return ID3v1Genres.matchGenreDescription(description);
            }
        }
        return -1;
    }

    @Override
    public int getGenre() {
        ID3v2TextFrameData frameData = this.extractTextFrameData(this.obseleteFormat ? ID_GENRE_OBSELETE : ID_GENRE);
        if (frameData == null || frameData.getText() == null) {
            return -1;
        }
        return this.getGenre(frameData.getText().toString());
    }

    @Override
    public void setGenre(int genre) {
        if (genre >= 0) {
            this.invalidateDataLength();
            String genreDescription = genre < ID3v1Genres.GENRES.length ? ID3v1Genres.GENRES[genre] : "";
            String combinedGenre = "(" + Integer.toString(genre) + ")" + genreDescription;
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(combinedGenre));
            this.addFrame(this.createFrame(ID_GENRE, frameData.toBytes()), true);
        }
    }

    @Override
    public int getBPM() {
        ID3v2TextFrameData frameData = this.extractTextFrameData(this.obseleteFormat ? "TBP" : ID_BPM);
        if (frameData == null || frameData.getText() == null) {
            return -1;
        }
        return Integer.parseInt(frameData.getText().toString());
    }

    @Override
    public void setBPM(int bpm) {
        if (bpm >= 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(Integer.toString(bpm)));
            this.addFrame(this.createFrame(ID_BPM, frameData.toBytes()), true);
        }
    }

    @Override
    public String getKey() {
        ID3v2TextFrameData frameData = this.extractTextFrameData(this.obseleteFormat ? ID_KEY_OBSELETE : ID_KEY);
        if (frameData == null || frameData.getText() == null) {
            return null;
        }
        return frameData.getText().toString();
    }

    @Override
    public void setKey(String key) {
        if (key != null && key.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(key));
            this.addFrame(this.createFrame(ID_KEY, frameData.toBytes()), true);
        }
    }

    @Override
    public String getGenreDescription() {
        ID3v2TextFrameData frameData = this.extractTextFrameData(this.obseleteFormat ? ID_GENRE_OBSELETE : ID_GENRE);
        if (frameData == null || frameData.getText() == null) {
            return null;
        }
        String text = frameData.getText().toString();
        if (text != null) {
            int genreNum = this.getGenre(text);
            if (genreNum >= 0 && genreNum < ID3v1Genres.GENRES.length) {
                return ID3v1Genres.GENRES[genreNum];
            }
            String description = this.extractGenreDescription(text);
            if (description != null && description.length() > 0) {
                return description;
            }
        }
        return null;
    }

    @Override
    public void setGenreDescription(String text) throws IllegalArgumentException {
        int genreNum = ID3v1Genres.matchGenreDescription(text);
        if (genreNum < 0) {
            throw new IllegalArgumentException("Unknown genre: " + text);
        }
        this.setGenre(genreNum);
    }

    protected int extractGenreNumber(String genreValue) throws NumberFormatException {
        int pos;
        String value = genreValue.trim();
        if (value.length() > 0 && value.charAt(0) == '(' && (pos = value.indexOf(41)) > 0) {
            return Integer.parseInt(value.substring(1, pos));
        }
        return Integer.parseInt(value);
    }

    protected String extractGenreDescription(String genreValue) throws NumberFormatException {
        String value = genreValue.trim();
        if (value.length() > 0) {
            int pos;
            if (value.charAt(0) == '(' && (pos = value.indexOf(41)) > 0) {
                return value.substring(pos + 1);
            }
            return value;
        }
        return null;
    }

    @Override
    public String getComment() {
        ID3v2CommentFrameData frameData = this.extractCommentFrameData(this.obseleteFormat ? ID_COMMENT_OBSELETE : ID_COMMENT, false);
        if (frameData != null && frameData.getComment() != null) {
            return frameData.getComment().toString();
        }
        return null;
    }

    @Override
    public void setComment(String comment) {
        if (comment != null && comment.length() > 0) {
            this.invalidateDataLength();
            ID3v2CommentFrameData frameData = new ID3v2CommentFrameData(this.useFrameUnsynchronisation(), "eng", null, new EncodedText(comment));
            this.addFrame(this.createFrame(ID_COMMENT, frameData.toBytes()), true);
        }
    }

    @Override
    public String getItunesComment() {
        ID3v2CommentFrameData frameData = this.extractCommentFrameData(this.obseleteFormat ? ID_COMMENT_OBSELETE : ID_COMMENT, true);
        if (frameData != null && frameData.getComment() != null) {
            return frameData.getComment().toString();
        }
        return null;
    }

    @Override
    public void setItunesComment(String itunesComment) {
        if (itunesComment != null && itunesComment.length() > 0) {
            this.invalidateDataLength();
            ID3v2CommentFrameData frameData = new ID3v2CommentFrameData(this.useFrameUnsynchronisation(), "eng", new EncodedText(ITUNES_COMMENT_DESCRIPTION), new EncodedText(itunesComment));
            this.addFrame(this.createFrame(ID_COMMENT, frameData.toBytes()), true);
        }
    }

    @Override
    public String getComposer() {
        ID3v2TextFrameData frameData = this.extractTextFrameData(this.obseleteFormat ? ID_COMPOSER_OBSELETE : ID_COMPOSER);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setComposer(String composer) {
        if (composer != null && composer.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(composer));
            this.addFrame(this.createFrame(ID_COMPOSER, frameData.toBytes()), true);
        }
    }

    @Override
    public String getPublisher() {
        ID3v2TextFrameData frameData = this.extractTextFrameData(this.obseleteFormat ? "TBP" : ID_PUBLISHER);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setPublisher(String publisher) {
        if (publisher != null && publisher.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(publisher));
            this.addFrame(this.createFrame(ID_PUBLISHER, frameData.toBytes()), true);
        }
    }

    @Override
    public String getOriginalArtist() {
        ID3v2TextFrameData frameData = this.extractTextFrameData(this.obseleteFormat ? ID_ORIGINAL_ARTIST_OBSELETE : ID_ORIGINAL_ARTIST);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setOriginalArtist(String originalArtist) {
        if (originalArtist != null && originalArtist.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(originalArtist));
            this.addFrame(this.createFrame(ID_ORIGINAL_ARTIST, frameData.toBytes()), true);
        }
    }

    @Override
    public String getCopyright() {
        ID3v2TextFrameData frameData = this.extractTextFrameData(this.obseleteFormat ? ID_COPYRIGHT_OBSELETE : ID_COPYRIGHT);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setCopyright(String copyright) {
        if (copyright != null && copyright.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(copyright));
            this.addFrame(this.createFrame(ID_COPYRIGHT, frameData.toBytes()), true);
        }
    }

    @Override
    public String getArtistUrl() {
        ID3v2WWWFrameData frameData = this.extractWWWFrameData(ID_ARTIST_URL);
        if (frameData != null) {
            return frameData.getUrl();
        }
        return null;
    }

    @Override
    public void setArtistUrl(String url) {
        if (url != null && url.length() > 0) {
            this.invalidateDataLength();
            ID3v2WWWFrameData frameData = new ID3v2WWWFrameData(this.useFrameUnsynchronisation(), url);
            this.addFrame(this.createFrame(ID_ARTIST_URL, frameData.toBytes()), true);
        }
    }

    @Override
    public String getCommercialUrl() {
        ID3v2WWWFrameData frameData = this.extractWWWFrameData(ID_COMMERCIAL_URL);
        if (frameData != null) {
            return frameData.getUrl();
        }
        return null;
    }

    @Override
    public void setCommercialUrl(String url) {
        if (url != null && url.length() > 0) {
            this.invalidateDataLength();
            ID3v2WWWFrameData frameData = new ID3v2WWWFrameData(this.useFrameUnsynchronisation(), url);
            this.addFrame(this.createFrame(ID_COMMERCIAL_URL, frameData.toBytes()), true);
        }
    }

    @Override
    public String getCopyrightUrl() {
        ID3v2WWWFrameData frameData = this.extractWWWFrameData(ID_COPYRIGHT_URL);
        if (frameData != null) {
            return frameData.getUrl();
        }
        return null;
    }

    @Override
    public void setCopyrightUrl(String url) {
        if (url != null && url.length() > 0) {
            this.invalidateDataLength();
            ID3v2WWWFrameData frameData = new ID3v2WWWFrameData(this.useFrameUnsynchronisation(), url);
            this.addFrame(this.createFrame(ID_COPYRIGHT_URL, frameData.toBytes()), true);
        }
    }

    @Override
    public String getAudiofileUrl() {
        ID3v2WWWFrameData frameData = this.extractWWWFrameData(ID_AUDIOFILE_URL);
        if (frameData != null) {
            return frameData.getUrl();
        }
        return null;
    }

    @Override
    public void setAudiofileUrl(String url) {
        if (url != null && url.length() > 0) {
            this.invalidateDataLength();
            ID3v2WWWFrameData frameData = new ID3v2WWWFrameData(this.useFrameUnsynchronisation(), url);
            this.addFrame(this.createFrame(ID_AUDIOFILE_URL, frameData.toBytes()), true);
        }
    }

    @Override
    public String getAudioSourceUrl() {
        ID3v2WWWFrameData frameData = this.extractWWWFrameData(ID_AUDIOSOURCE_URL);
        if (frameData != null) {
            return frameData.getUrl();
        }
        return null;
    }

    @Override
    public void setAudioSourceUrl(String url) {
        if (url != null && url.length() > 0) {
            this.invalidateDataLength();
            ID3v2WWWFrameData frameData = new ID3v2WWWFrameData(this.useFrameUnsynchronisation(), url);
            this.addFrame(this.createFrame(ID_AUDIOSOURCE_URL, frameData.toBytes()), true);
        }
    }

    @Override
    public String getRadiostationUrl() {
        ID3v2WWWFrameData frameData = this.extractWWWFrameData(ID_RADIOSTATION_URL);
        if (frameData != null) {
            return frameData.getUrl();
        }
        return null;
    }

    @Override
    public void setRadiostationUrl(String url) {
        if (url != null && url.length() > 0) {
            this.invalidateDataLength();
            ID3v2WWWFrameData frameData = new ID3v2WWWFrameData(this.useFrameUnsynchronisation(), url);
            this.addFrame(this.createFrame(ID_RADIOSTATION_URL, frameData.toBytes()), true);
        }
    }

    @Override
    public String getPaymentUrl() {
        ID3v2WWWFrameData frameData = this.extractWWWFrameData(ID_PAYMENT_URL);
        if (frameData != null) {
            return frameData.getUrl();
        }
        return null;
    }

    @Override
    public void setPaymentUrl(String url) {
        if (url != null && url.length() > 0) {
            this.invalidateDataLength();
            ID3v2WWWFrameData frameData = new ID3v2WWWFrameData(this.useFrameUnsynchronisation(), url);
            this.addFrame(this.createFrame(ID_PAYMENT_URL, frameData.toBytes()), true);
        }
    }

    @Override
    public String getPublisherUrl() {
        ID3v2WWWFrameData frameData = this.extractWWWFrameData(ID_PUBLISHER_URL);
        if (frameData != null) {
            return frameData.getUrl();
        }
        return null;
    }

    @Override
    public void setPublisherUrl(String url) {
        if (url != null && url.length() > 0) {
            this.invalidateDataLength();
            ID3v2WWWFrameData frameData = new ID3v2WWWFrameData(this.useFrameUnsynchronisation(), url);
            this.addFrame(this.createFrame(ID_PUBLISHER_URL, frameData.toBytes()), true);
        }
    }

    @Override
    public String getUrl() {
        ID3v2UrlFrameData frameData = this.extractUrlFrameData(this.obseleteFormat ? ID_URL_OBSELETE : ID_URL);
        if (frameData != null) {
            return frameData.getUrl();
        }
        return null;
    }

    @Override
    public void setUrl(String url) {
        if (url != null && url.length() > 0) {
            this.invalidateDataLength();
            ID3v2UrlFrameData frameData = new ID3v2UrlFrameData(this.useFrameUnsynchronisation(), null, url);
            this.addFrame(this.createFrame(ID_URL, frameData.toBytes()), true);
        }
    }

    @Override
    public ArrayList<ID3v2ChapterFrameData> getChapters() {
        if (this.obseleteFormat) {
            return null;
        }
        return this.extractChapterFrameData(ID_CHAPTER);
    }

    @Override
    public void setChapters(ArrayList<ID3v2ChapterFrameData> chapters) {
        if (chapters != null) {
            this.invalidateDataLength();
            boolean first = true;
            for (ID3v2ChapterFrameData chapter : chapters) {
                if (first) {
                    first = false;
                    this.addFrame(this.createFrame(ID_CHAPTER, chapter.toBytes()), true);
                    continue;
                }
                this.addFrame(this.createFrame(ID_CHAPTER, chapter.toBytes()), false);
            }
        }
    }

    @Override
    public ArrayList<ID3v2ChapterTOCFrameData> getChapterTOC() {
        if (this.obseleteFormat) {
            return null;
        }
        return this.extractChapterTOCFrameData(ID_CHAPTER_TOC);
    }

    @Override
    public void setChapterTOC(ArrayList<ID3v2ChapterTOCFrameData> toc) {
        if (toc != null) {
            this.invalidateDataLength();
            boolean first = true;
            for (ID3v2ChapterTOCFrameData ct : toc) {
                if (first) {
                    first = false;
                    this.addFrame(this.createFrame(ID_CHAPTER_TOC, ct.toBytes()), true);
                    continue;
                }
                this.addFrame(this.createFrame(ID_CHAPTER_TOC, ct.toBytes()), false);
            }
        }
    }

    @Override
    public String getEncoder() {
        ID3v2TextFrameData frameData = this.extractTextFrameData(this.obseleteFormat ? ID_ENCODER_OBSELETE : ID_ENCODER);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setEncoder(String encoder) {
        if (encoder != null && encoder.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(encoder));
            this.addFrame(this.createFrame(ID_ENCODER, frameData.toBytes()), true);
        }
    }

    @Override
    public byte[] getAlbumImage() {
        ID3v2PictureFrameData frameData = this.createPictureFrameData(this.obseleteFormat ? ID_IMAGE_OBSELETE : ID_IMAGE);
        if (frameData != null) {
            return frameData.getImageData();
        }
        return null;
    }

    @Override
    public void setAlbumImage(byte[] albumImage, String mimeType) {
        if (albumImage != null && albumImage.length > 0 && mimeType != null && mimeType.length() > 0) {
            this.invalidateDataLength();
            ID3v2PictureFrameData frameData = new ID3v2PictureFrameData(this.useFrameUnsynchronisation(), mimeType, 0, null, albumImage);
            this.addFrame(this.createFrame(ID_IMAGE, frameData.toBytes()), true);
        }
    }

    @Override
    public void clearAlbumImage() {
        this.clearFrameSet(this.obseleteFormat ? ID_IMAGE_OBSELETE : ID_IMAGE);
    }

    @Override
    public String getAlbumImageMimeType() {
        ID3v2PictureFrameData frameData = this.createPictureFrameData(this.obseleteFormat ? ID_IMAGE_OBSELETE : ID_IMAGE);
        if (frameData != null && frameData.getMimeType() != null) {
            return frameData.getMimeType();
        }
        return null;
    }

    @Override
    public void clearFrameSet(String id) {
        if (this.frameSets.remove(id) != null) {
            this.invalidateDataLength();
        }
    }

    private ArrayList<ID3v2ChapterFrameData> extractChapterFrameData(String id) {
        ID3v2FrameSet frameSet = this.frameSets.get(id);
        if (frameSet != null) {
            ArrayList<ID3v2ChapterFrameData> chapterData = new ArrayList<ID3v2ChapterFrameData>();
            List<ID3v2Frame> frames = frameSet.getFrames();
            for (ID3v2Frame frame : frames) {
                try {
                    ID3v2ChapterFrameData frameData = new ID3v2ChapterFrameData(this.useFrameUnsynchronisation(), frame.getData());
                    chapterData.add(frameData);
                }
                catch (InvalidDataException e) {}
            }
            return chapterData;
        }
        return null;
    }

    private ArrayList<ID3v2ChapterTOCFrameData> extractChapterTOCFrameData(String id) {
        ID3v2FrameSet frameSet = this.frameSets.get(id);
        if (frameSet != null) {
            ArrayList<ID3v2ChapterTOCFrameData> chapterData = new ArrayList<ID3v2ChapterTOCFrameData>();
            List<ID3v2Frame> frames = frameSet.getFrames();
            for (ID3v2Frame frame : frames) {
                try {
                    ID3v2ChapterTOCFrameData frameData = new ID3v2ChapterTOCFrameData(this.useFrameUnsynchronisation(), frame.getData());
                    chapterData.add(frameData);
                }
                catch (InvalidDataException e) {}
            }
            return chapterData;
        }
        return null;
    }

    protected ID3v2TextFrameData extractTextFrameData(String id) {
        ID3v2FrameSet frameSet = this.frameSets.get(id);
        if (frameSet != null) {
            ID3v2Frame frame = frameSet.getFrames().get(0);
            try {
                ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), frame.getData());
                return frameData;
            }
            catch (InvalidDataException e) {
                // empty catch block
            }
        }
        return null;
    }

    private ID3v2WWWFrameData extractWWWFrameData(String id) {
        ID3v2FrameSet frameSet = this.frameSets.get(id);
        if (frameSet != null) {
            ID3v2Frame frame = frameSet.getFrames().get(0);
            try {
                ID3v2WWWFrameData frameData = new ID3v2WWWFrameData(this.useFrameUnsynchronisation(), frame.getData());
                return frameData;
            }
            catch (InvalidDataException e) {
                // empty catch block
            }
        }
        return null;
    }

    private ID3v2UrlFrameData extractUrlFrameData(String id) {
        ID3v2FrameSet frameSet = this.frameSets.get(id);
        if (frameSet != null) {
            ID3v2Frame frame = frameSet.getFrames().get(0);
            try {
                ID3v2UrlFrameData frameData = new ID3v2UrlFrameData(this.useFrameUnsynchronisation(), frame.getData());
                return frameData;
            }
            catch (InvalidDataException e) {
                // empty catch block
            }
        }
        return null;
    }

    private ID3v2CommentFrameData extractCommentFrameData(String id, boolean itunes) {
        ID3v2FrameSet frameSet = this.frameSets.get(id);
        if (frameSet != null) {
            for (ID3v2Frame frame : frameSet.getFrames()) {
                try {
                    ID3v2CommentFrameData frameData = new ID3v2CommentFrameData(this.useFrameUnsynchronisation(), frame.getData());
                    if (itunes && ITUNES_COMMENT_DESCRIPTION.equals(frameData.getDescription().toString())) {
                        return frameData;
                    }
                    if (itunes) continue;
                    return frameData;
                }
                catch (InvalidDataException e) {
                }
            }
        }
        return null;
    }

    private ID3v2PictureFrameData createPictureFrameData(String id) {
        ID3v2FrameSet frameSet = this.frameSets.get(id);
        if (frameSet != null) {
            ID3v2Frame frame = frameSet.getFrames().get(0);
            try {
                ID3v2PictureFrameData frameData = this.obseleteFormat ? new ID3v2ObseletePictureFrameData(this.useFrameUnsynchronisation(), frame.getData()) : new ID3v2PictureFrameData(this.useFrameUnsynchronisation(), frame.getData());
                return frameData;
            }
            catch (InvalidDataException e) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractID3v2Tag)) {
            return false;
        }
        if (super.equals(obj)) {
            return true;
        }
        AbstractID3v2Tag other = (AbstractID3v2Tag)obj;
        if (this.unsynchronisation != other.unsynchronisation) {
            return false;
        }
        if (this.extendedHeader != other.extendedHeader) {
            return false;
        }
        if (this.experimental != other.experimental) {
            return false;
        }
        if (this.footer != other.footer) {
            return false;
        }
        if (this.compression != other.compression) {
            return false;
        }
        if (this.dataLength != other.dataLength) {
            return false;
        }
        if (this.extendedHeaderLength != other.extendedHeaderLength) {
            return false;
        }
        if (this.version == null) {
            if (other.version != null) {
                return false;
            }
        } else {
            if (other.version == null) {
                return false;
            }
            if (!this.version.equals(other.version)) {
                return false;
            }
        }
        if (this.frameSets == null) {
            if (other.frameSets != null) {
                return false;
            }
        } else {
            if (other.frameSets == null) {
                return false;
            }
            if (!this.frameSets.equals(other.frameSets)) {
                return false;
            }
        }
        return true;
    }
}

