/*
 * Decompiled with CFR 0.152.
 */
package com.mpatric.mp3agic;

import com.mpatric.mp3agic.BufferTools;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;

public class EncodedText {
    public static final byte TEXT_ENCODING_ISO_8859_1 = 0;
    public static final byte TEXT_ENCODING_UTF_16 = 1;
    public static final byte TEXT_ENCODING_UTF_16BE = 2;
    public static final byte TEXT_ENCODING_UTF_8 = 3;
    public static final String CHARSET_ISO_8859_1 = "ISO-8859-1";
    public static final String CHARSET_UTF_16 = "UTF-16LE";
    public static final String CHARSET_UTF_16BE = "UTF-16BE";
    public static final String CHARSET_UTF_8 = "UTF-8";
    private static final String[] characterSets = new String[]{"ISO-8859-1", "UTF-16LE", "UTF-16BE", "UTF-8"};
    private static final byte[] textEncodingFallback = new byte[]{0, 2, 1, 3};
    private static final byte[][] boms = new byte[][]{new byte[0], {-1, -2}, {-2, -1}, new byte[0]};
    private static final byte[][] terminators = new byte[][]{{0}, {0, 0}, {0, 0}, {0}};
    private byte[] value;
    private byte textEncoding;

    public EncodedText(byte textEncoding, byte[] value) {
        this.textEncoding = textEncoding == 1 && EncodedText.textEncodingForBytesFromBOM(value) == 2 ? (byte)2 : textEncoding;
        this.value = value;
        this.stripBomAndTerminator();
    }

    public EncodedText(String string) throws IllegalArgumentException {
        byte[] arr$ = textEncodingFallback;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            byte textEncoding;
            this.textEncoding = textEncoding = arr$[i$];
            this.value = EncodedText.stringToBytes(string, EncodedText.characterSetForTextEncoding(textEncoding));
            if (this.value == null || this.toString() == null) continue;
            this.stripBomAndTerminator();
            return;
        }
        throw new IllegalArgumentException("Invalid string, could not find appropriate encoding");
    }

    public EncodedText(String string, byte transcodeToTextEncoding) throws IllegalArgumentException, CharacterCodingException {
        this(string);
        this.setTextEncoding(transcodeToTextEncoding, true);
    }

    public EncodedText(byte textEncoding, String string) {
        this.textEncoding = textEncoding;
        this.value = EncodedText.stringToBytes(string, EncodedText.characterSetForTextEncoding(textEncoding));
        this.stripBomAndTerminator();
    }

    public EncodedText(byte[] value) {
        this(EncodedText.textEncodingForBytesFromBOM(value), value);
    }

    private static byte textEncodingForBytesFromBOM(byte[] value) {
        if (value.length >= 2 && value[0] == -1 && value[1] == -2) {
            return 1;
        }
        if (value.length >= 2 && value[0] == -2 && value[1] == -1) {
            return 2;
        }
        if (value.length >= 3 && value[0] == -17 && value[1] == -69 && value[2] == -65) {
            return 3;
        }
        return 0;
    }

    private static String characterSetForTextEncoding(byte textEncoding) {
        try {
            return characterSets[textEncoding];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid text encoding " + textEncoding);
        }
    }

    private void stripBomAndTerminator() {
        int leadingCharsToRemove = 0;
        if (this.value.length >= 2 && (this.value[0] == -2 && this.value[1] == -1 || this.value[0] == -1 && this.value[1] == -2)) {
            leadingCharsToRemove = 2;
        } else if (this.value.length >= 3 && this.value[0] == -17 && this.value[1] == -69 && this.value[2] == -65) {
            leadingCharsToRemove = 3;
        }
        int trailingCharsToRemove = 0;
        byte[] terminator = terminators[this.textEncoding];
        if (this.value.length - leadingCharsToRemove >= terminator.length) {
            boolean haveTerminator = true;
            for (int i = 0; i < terminator.length; ++i) {
                if (this.value[this.value.length - terminator.length + i] == terminator[i]) continue;
                haveTerminator = false;
                break;
            }
            if (haveTerminator) {
                trailingCharsToRemove = terminator.length;
            }
        }
        if (leadingCharsToRemove + trailingCharsToRemove > 0) {
            int newLength = this.value.length - leadingCharsToRemove - trailingCharsToRemove;
            byte[] newValue = new byte[newLength];
            if (newLength > 0) {
                System.arraycopy(this.value, leadingCharsToRemove, newValue, 0, newValue.length);
            }
            this.value = newValue;
        }
    }

    public byte getTextEncoding() {
        return this.textEncoding;
    }

    public void setTextEncoding(byte textEncoding) throws CharacterCodingException {
        this.setTextEncoding(textEncoding, true);
    }

    public void setTextEncoding(byte textEncoding, boolean transcode) throws CharacterCodingException {
        if (this.textEncoding != textEncoding) {
            CharBuffer charBuffer = EncodedText.bytesToCharBuffer(this.value, EncodedText.characterSetForTextEncoding(this.textEncoding));
            byte[] transcodedBytes = EncodedText.charBufferToBytes(charBuffer, EncodedText.characterSetForTextEncoding(textEncoding));
            this.textEncoding = textEncoding;
            this.value = transcodedBytes;
        }
    }

    public byte[] getTerminator() {
        return terminators[this.textEncoding];
    }

    public byte[] toBytes() {
        return this.toBytes(false, false);
    }

    public byte[] toBytes(boolean includeBom) {
        return this.toBytes(includeBom, false);
    }

    public byte[] toBytes(boolean includeBom, boolean includeTerminator) {
        byte[] terminator;
        byte[] bom;
        EncodedText.characterSetForTextEncoding(this.textEncoding);
        int newLength = this.value.length + (includeBom ? boms[this.textEncoding].length : 0) + (includeTerminator ? this.getTerminator().length : 0);
        if (newLength == this.value.length) {
            return this.value;
        }
        byte[] bytes = new byte[newLength];
        int i = 0;
        if (includeBom && (bom = boms[this.textEncoding]).length > 0) {
            System.arraycopy(boms[this.textEncoding], 0, bytes, i, boms[this.textEncoding].length);
            i += boms[this.textEncoding].length;
        }
        if (this.value.length > 0) {
            System.arraycopy(this.value, 0, bytes, i, this.value.length);
            i += this.value.length;
        }
        if (includeTerminator && (terminator = this.getTerminator()).length > 0) {
            System.arraycopy(terminator, 0, bytes, i, terminator.length);
        }
        return bytes;
    }

    public String toString() {
        try {
            return EncodedText.bytesToString(this.value, EncodedText.characterSetForTextEncoding(this.textEncoding));
        }
        catch (CharacterCodingException e) {
            return null;
        }
    }

    public String getCharacterSet() {
        return EncodedText.characterSetForTextEncoding(this.textEncoding);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.textEncoding;
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EncodedText other = (EncodedText)obj;
        if (this.textEncoding != other.textEncoding) {
            return false;
        }
        return Arrays.equals(this.value, other.value);
    }

    private static String bytesToString(byte[] bytes, String characterSet) throws CharacterCodingException {
        CharBuffer cbuf = EncodedText.bytesToCharBuffer(bytes, characterSet);
        String s = cbuf.toString();
        int length = s.indexOf(0);
        if (length == -1) {
            return s;
        }
        return s.substring(0, length);
    }

    protected static CharBuffer bytesToCharBuffer(byte[] bytes, String characterSet) throws CharacterCodingException {
        Charset charset = Charset.forName(characterSet);
        CharsetDecoder decoder = charset.newDecoder();
        return decoder.decode(ByteBuffer.wrap(bytes));
    }

    private static byte[] stringToBytes(String s, String characterSet) {
        try {
            return EncodedText.charBufferToBytes(CharBuffer.wrap(s), characterSet);
        }
        catch (CharacterCodingException e) {
            return null;
        }
    }

    protected static byte[] charBufferToBytes(CharBuffer charBuffer, String characterSet) throws CharacterCodingException {
        Charset charset = Charset.forName(characterSet);
        CharsetEncoder encoder = charset.newEncoder();
        ByteBuffer byteBuffer = encoder.encode(charBuffer);
        return BufferTools.copyBuffer(byteBuffer.array(), 0, byteBuffer.limit());
    }
}

