/*
 * Decompiled with CFR 0.152.
 */
package vazkii.minetunes.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import vazkii.minetunes.gui.GuiDevTools;

public final class CacheHelper {
    public static File getCacheFile(String filename) throws IOException {
        File loc = new File(".");
        File cacheFile = new File(loc, "mineTunes/" + filename);
        if (!cacheFile.exists()) {
            cacheFile.getParentFile().mkdirs();
            cacheFile.createNewFile();
        }
        return cacheFile;
    }

    public static NBTTagCompound getCacheCompound(File file) {
        if (file == null) {
            throw new RuntimeException("No cache file!");
        }
        try {
            NBTTagCompound cmp = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
            return cmp;
        }
        catch (IOException e) {
            NBTTagCompound cmp = new NBTTagCompound();
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)cmp, (OutputStream)new FileOutputStream(file));
                return CacheHelper.getCacheCompound(file);
            }
            catch (IOException e1) {
                GuiDevTools.logThrowable(e1);
                return null;
            }
        }
    }

    public static void injectNBTToFile(File file, NBTTagCompound cmp) {
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)cmp, (OutputStream)new FileOutputStream(file));
        }
        catch (IOException e) {
            GuiDevTools.logThrowable(e);
        }
    }
}

