/*
 * Decompiled with CFR 0.152.
 */
package com.mpatric.mp3agic;

import com.mpatric.mp3agic.BufferTools;
import com.mpatric.mp3agic.InvalidDataException;

public abstract class AbstractID3v2FrameData {
    boolean unsynchronisation;

    public AbstractID3v2FrameData(boolean unsynchronisation) {
        this.unsynchronisation = unsynchronisation;
    }

    protected void synchroniseAndUnpackFrameData(byte[] bytes) throws InvalidDataException {
        if (this.unsynchronisation && BufferTools.sizeSynchronisationWouldSubtract(bytes) > 0) {
            byte[] synchronisedBytes = BufferTools.synchroniseBuffer(bytes);
            this.unpackFrameData(synchronisedBytes);
        } else {
            this.unpackFrameData(bytes);
        }
    }

    protected byte[] packAndUnsynchroniseFrameData() {
        byte[] bytes = this.packFrameData();
        if (this.unsynchronisation && BufferTools.sizeUnsynchronisationWouldAdd(bytes) > 0) {
            return BufferTools.unsynchroniseBuffer(bytes);
        }
        return bytes;
    }

    protected byte[] toBytes() {
        return this.packAndUnsynchroniseFrameData();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.unsynchronisation ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractID3v2FrameData other = (AbstractID3v2FrameData)obj;
        return this.unsynchronisation == other.unsynchronisation;
    }

    protected abstract void unpackFrameData(byte[] var1) throws InvalidDataException;

    protected abstract byte[] packFrameData();

    protected abstract int getLength();
}

