/*
 * Decompiled with CFR 0.152.
 */
package com.mpatric.mp3agic;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FileWrapper {
    protected File file;
    protected long length;
    protected long lastModified;

    protected FileWrapper() {
    }

    public FileWrapper(String filename) throws IOException {
        this.file = new File(filename);
        this.init();
    }

    public FileWrapper(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
        this.init();
    }

    private void init() throws IOException {
        if (!this.file.exists()) {
            throw new FileNotFoundException("File not found " + this.file.getPath());
        }
        if (!this.file.canRead()) {
            throw new IOException("File not readable");
        }
        this.length = this.file.length();
        this.lastModified = this.file.lastModified();
    }

    public String getFilename() {
        return this.file.getPath();
    }

    public long getLength() {
        return this.length;
    }

    public long getLastModified() {
        return this.lastModified;
    }
}

