/*
 * Decompiled with CFR 0.152.
 */
package com.mpatric.mp3agic;

import com.mpatric.mp3agic.AbstractID3v2Tag;
import com.mpatric.mp3agic.BufferTools;
import com.mpatric.mp3agic.EncodedText;
import com.mpatric.mp3agic.ID3v24Frame;
import com.mpatric.mp3agic.ID3v2Frame;
import com.mpatric.mp3agic.ID3v2FrameSet;
import com.mpatric.mp3agic.ID3v2TextFrameData;
import com.mpatric.mp3agic.InvalidDataException;
import com.mpatric.mp3agic.NoSuchTagException;
import com.mpatric.mp3agic.UnsupportedTagException;

public class ID3v24Tag
extends AbstractID3v2Tag {
    public static final String VERSION = "4.0";
    public static final String ID_RECTIME = "TDRC";

    public ID3v24Tag() {
        this.version = VERSION;
    }

    public ID3v24Tag(byte[] buffer) throws NoSuchTagException, UnsupportedTagException, InvalidDataException {
        super(buffer);
    }

    @Override
    protected void unpackFlags(byte[] buffer) {
        this.unsynchronisation = BufferTools.checkBit(buffer[5], 7);
        this.extendedHeader = BufferTools.checkBit(buffer[5], 6);
        this.experimental = BufferTools.checkBit(buffer[5], 5);
        this.footer = BufferTools.checkBit(buffer[5], 4);
    }

    @Override
    protected void packFlags(byte[] bytes, int offset) {
        bytes[offset + 5] = BufferTools.setBit(bytes[offset + 5], 7, this.unsynchronisation);
        bytes[offset + 5] = BufferTools.setBit(bytes[offset + 5], 6, this.extendedHeader);
        bytes[offset + 5] = BufferTools.setBit(bytes[offset + 5], 5, this.experimental);
        bytes[offset + 5] = BufferTools.setBit(bytes[offset + 5], 4, this.footer);
    }

    @Override
    protected boolean useFrameUnsynchronisation() {
        return this.unsynchronisation;
    }

    @Override
    protected ID3v2Frame createFrame(byte[] buffer, int currentOffset) throws InvalidDataException {
        return new ID3v24Frame(buffer, currentOffset);
    }

    @Override
    protected ID3v2Frame createFrame(String id, byte[] data) {
        return new ID3v24Frame(id, data);
    }

    @Override
    public void setGenreDescription(String text) {
        ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(text));
        ID3v2FrameSet frameSet = this.getFrameSets().get("TCON");
        if (frameSet == null) {
            frameSet = new ID3v2FrameSet("TCON");
            this.getFrameSets().put("TCON", frameSet);
        }
        frameSet.clear();
        frameSet.addFrame(this.createFrame("TCON", frameData.toBytes()));
    }

    public String getRecordingTime() {
        ID3v2TextFrameData frameData = this.extractTextFrameData(ID_RECTIME);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    public void setRecordingTime(String recTime) {
        if (recTime != null && recTime.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(recTime));
            this.addFrame(this.createFrame(ID_RECTIME, frameData.toBytes()), true);
        }
    }
}

