/*
 * Decompiled with CFR 0.152.
 */
package com.mpatric.mp3agic;

import com.mpatric.mp3agic.AbstractID3v2FrameData;
import com.mpatric.mp3agic.ByteBufferUtils;
import com.mpatric.mp3agic.ID3v2Frame;
import com.mpatric.mp3agic.InvalidDataException;
import com.mpatric.mp3agic.NotSupportedException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;

public class ID3v2ChapterTOCFrameData
extends AbstractID3v2FrameData {
    protected boolean isRoot;
    protected boolean isOrdered;
    protected String id;
    protected String[] children;
    protected ArrayList<ID3v2Frame> subframes = new ArrayList();

    public ID3v2ChapterTOCFrameData(boolean unsynchronisation) {
        super(unsynchronisation);
    }

    public ID3v2ChapterTOCFrameData(boolean unsynchronisation, boolean isRoot, boolean isOrdered, String id, String[] children) {
        super(unsynchronisation);
        this.isRoot = isRoot;
        this.isOrdered = isOrdered;
        this.id = id;
        this.children = children;
    }

    public ID3v2ChapterTOCFrameData(boolean unsynchronisation, byte[] bytes) throws InvalidDataException {
        super(unsynchronisation);
        this.synchroniseAndUnpackFrameData(bytes);
    }

    @Override
    protected void unpackFrameData(byte[] bytes) throws InvalidDataException {
        ID3v2Frame frame;
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        this.id = ByteBufferUtils.extractNullTerminatedString(bb);
        byte flags = bb.get();
        if ((flags & 1) == 1) {
            this.isRoot = true;
        }
        if ((flags & 2) == 2) {
            this.isOrdered = true;
        }
        int childCount = bb.get();
        this.children = new String[childCount];
        for (int i = 0; i < childCount; ++i) {
            this.children[i] = ByteBufferUtils.extractNullTerminatedString(bb);
        }
        for (int offset = bb.position(); offset < bytes.length; offset += frame.getLength()) {
            frame = new ID3v2Frame(bytes, offset);
            this.subframes.add(frame);
        }
    }

    public void addSubframe(String id, AbstractID3v2FrameData frame) {
        this.subframes.add(new ID3v2Frame(id, frame.toBytes()));
    }

    @Override
    protected byte[] packFrameData() {
        ByteBuffer bb = ByteBuffer.allocate(this.getLength());
        bb.put(this.id.getBytes());
        bb.put((byte)0);
        bb.put(this.getFlags());
        bb.put((byte)this.children.length);
        for (String child : this.children) {
            bb.put(child.getBytes());
            bb.put((byte)0);
        }
        for (ID3v2Frame frame : this.subframes) {
            try {
                bb.put(frame.toBytes());
            }
            catch (NotSupportedException e) {
                e.printStackTrace();
            }
        }
        return bb.array();
    }

    private byte getFlags() {
        byte b = 0;
        if (this.isRoot) {
            b = (byte)(b | 1);
        }
        if (this.isOrdered) {
            b = (byte)(b | 2);
        }
        return b;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public boolean isOrdered() {
        return this.isOrdered;
    }

    public void setOrdered(boolean isOrdered) {
        this.isOrdered = isOrdered;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String[] getChildren() {
        return this.children;
    }

    public void setChildren(String[] children) {
        this.children = children;
    }

    @Deprecated
    public String[] getChilds() {
        return this.children;
    }

    @Deprecated
    public void setChilds(String[] childs) {
        this.children = childs;
    }

    public ArrayList<ID3v2Frame> getSubframes() {
        return this.subframes;
    }

    public void setSubframes(ArrayList<ID3v2Frame> subframes) {
        this.subframes = subframes;
    }

    @Override
    protected int getLength() {
        int length = 3;
        if (this.id != null) {
            length += this.id.length();
        }
        if (this.children != null) {
            length += this.children.length;
            for (String child : this.children) {
                length += child.length();
            }
        }
        if (this.subframes != null) {
            for (ID3v2Frame frame : this.subframes) {
                length += frame.getLength();
            }
        }
        return length;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ID3v2ChapterTOCFrameData [isRoot=");
        builder.append(this.isRoot);
        builder.append(", isOrdered=");
        builder.append(this.isOrdered);
        builder.append(", id=");
        builder.append(this.id);
        builder.append(", children=");
        builder.append(Arrays.toString(this.children));
        builder.append(", subframes=");
        builder.append(this.subframes);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.children);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.isOrdered ? 1231 : 1237);
        result = 31 * result + (this.isRoot ? 1231 : 1237);
        result = 31 * result + (this.subframes == null ? 0 : this.subframes.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ID3v2ChapterTOCFrameData other = (ID3v2ChapterTOCFrameData)obj;
        if (!Arrays.equals(this.children, other.children)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.isOrdered != other.isOrdered) {
            return false;
        }
        if (this.isRoot != other.isRoot) {
            return false;
        }
        return !(this.subframes == null ? other.subframes != null : !this.subframes.equals(other.subframes));
    }
}

