/*
 * Decompiled with CFR 0.152.
 */
package com.mpatric.mp3agic;

import com.mpatric.mp3agic.BufferTools;
import com.mpatric.mp3agic.InvalidDataException;
import com.mpatric.mp3agic.NotSupportedException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class ID3v2Frame {
    private static final int HEADER_LENGTH = 10;
    private static final int ID_OFFSET = 0;
    private static final int ID_LENGTH = 4;
    protected static final int DATA_LENGTH_OFFSET = 4;
    private static final int FLAGS1_OFFSET = 8;
    private static final int FLAGS2_OFFSET = 9;
    private static final int PRESERVE_TAG_BIT = 6;
    private static final int PRESERVE_FILE_BIT = 5;
    private static final int READ_ONLY_BIT = 4;
    private static final int GROUP_BIT = 6;
    private static final int COMPRESSION_BIT = 3;
    private static final int ENCRYPTION_BIT = 2;
    private static final int UNSYNCHRONISATION_BIT = 1;
    private static final int DATA_LENGTH_INDICATOR_BIT = 0;
    protected String id;
    protected int dataLength = 0;
    protected byte[] data = null;
    private boolean preserveTag = false;
    private boolean preserveFile = false;
    private boolean readOnly = false;
    private boolean group = false;
    private boolean compression = false;
    private boolean encryption = false;
    private boolean unsynchronisation = false;
    private boolean dataLengthIndicator = false;

    public ID3v2Frame(byte[] buffer, int offset) throws InvalidDataException {
        this.unpackFrame(buffer, offset);
    }

    public ID3v2Frame(String id, byte[] data) {
        this.id = id;
        this.data = data;
        this.dataLength = data.length;
    }

    protected void unpackFrame(byte[] buffer, int offset) throws InvalidDataException {
        int dataOffset = this.unpackHeader(buffer, offset);
        this.sanityCheckUnpackedHeader();
        this.data = BufferTools.copyBuffer(buffer, dataOffset, this.dataLength);
    }

    protected int unpackHeader(byte[] buffer, int offset) {
        this.id = BufferTools.byteBufferToStringIgnoringEncodingIssues(buffer, offset + 0, 4);
        this.unpackDataLength(buffer, offset);
        this.unpackFlags(buffer, offset);
        return offset + 10;
    }

    protected void unpackDataLength(byte[] buffer, int offset) {
        this.dataLength = BufferTools.unpackInteger(buffer[offset + 4], buffer[offset + 4 + 1], buffer[offset + 4 + 2], buffer[offset + 4 + 3]);
    }

    private void unpackFlags(byte[] buffer, int offset) {
        this.preserveTag = BufferTools.checkBit(buffer[offset + 8], 6);
        this.preserveFile = BufferTools.checkBit(buffer[offset + 8], 5);
        this.readOnly = BufferTools.checkBit(buffer[offset + 8], 4);
        this.group = BufferTools.checkBit(buffer[offset + 9], 6);
        this.compression = BufferTools.checkBit(buffer[offset + 9], 3);
        this.encryption = BufferTools.checkBit(buffer[offset + 9], 2);
        this.unsynchronisation = BufferTools.checkBit(buffer[offset + 9], 1);
        this.dataLengthIndicator = BufferTools.checkBit(buffer[offset + 9], 0);
    }

    protected void sanityCheckUnpackedHeader() throws InvalidDataException {
        for (int i = 0; i < this.id.length(); ++i) {
            if (this.id.charAt(i) >= 'A' && this.id.charAt(i) <= 'Z' || this.id.charAt(i) >= '0' && this.id.charAt(i) <= '9') continue;
            throw new InvalidDataException("Not a valid frame - invalid tag " + this.id);
        }
    }

    public byte[] toBytes() throws NotSupportedException {
        byte[] bytes = new byte[this.getLength()];
        this.packFrame(bytes, 0);
        return bytes;
    }

    public void toBytes(byte[] bytes, int offset) throws NotSupportedException {
        this.packFrame(bytes, offset);
    }

    public void packFrame(byte[] bytes, int offset) throws NotSupportedException {
        this.packHeader(bytes, offset);
        BufferTools.copyIntoByteBuffer(this.data, 0, this.data.length, bytes, offset + 10);
    }

    private void packHeader(byte[] bytes, int i) {
        try {
            BufferTools.stringIntoByteBuffer(this.id, 0, this.id.length(), bytes, 0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        BufferTools.copyIntoByteBuffer(this.packDataLength(), 0, 4, bytes, 4);
        BufferTools.copyIntoByteBuffer(this.packFlags(), 0, 2, bytes, 8);
    }

    protected byte[] packDataLength() {
        return BufferTools.packInteger(this.dataLength);
    }

    private byte[] packFlags() {
        byte[] bytes = new byte[2];
        bytes[0] = BufferTools.setBit(bytes[0], 6, this.preserveTag);
        bytes[0] = BufferTools.setBit(bytes[0], 5, this.preserveFile);
        bytes[0] = BufferTools.setBit(bytes[0], 4, this.readOnly);
        bytes[1] = BufferTools.setBit(bytes[1], 6, this.group);
        bytes[1] = BufferTools.setBit(bytes[1], 3, this.compression);
        bytes[1] = BufferTools.setBit(bytes[1], 2, this.encryption);
        bytes[1] = BufferTools.setBit(bytes[1], 1, this.unsynchronisation);
        bytes[1] = BufferTools.setBit(bytes[1], 0, this.dataLengthIndicator);
        return bytes;
    }

    public String getId() {
        return this.id;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public int getLength() {
        return this.dataLength + 10;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
        this.dataLength = data == null ? 0 : data.length;
    }

    public boolean hasDataLengthIndicator() {
        return this.dataLengthIndicator;
    }

    public boolean hasCompression() {
        return this.compression;
    }

    public boolean hasEncryption() {
        return this.encryption;
    }

    public boolean hasGroup() {
        return this.group;
    }

    public boolean hasPreserveFile() {
        return this.preserveFile;
    }

    public boolean hasPreserveTag() {
        return this.preserveTag;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean hasUnsynchronisation() {
        return this.unsynchronisation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.compression ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.data);
        result = 31 * result + this.dataLength;
        result = 31 * result + (this.dataLengthIndicator ? 1231 : 1237);
        result = 31 * result + (this.encryption ? 1231 : 1237);
        result = 31 * result + (this.group ? 1231 : 1237);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.preserveFile ? 1231 : 1237);
        result = 31 * result + (this.preserveTag ? 1231 : 1237);
        result = 31 * result + (this.readOnly ? 1231 : 1237);
        result = 31 * result + (this.unsynchronisation ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ID3v2Frame other = (ID3v2Frame)obj;
        if (this.compression != other.compression) {
            return false;
        }
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        if (this.dataLength != other.dataLength) {
            return false;
        }
        if (this.dataLengthIndicator != other.dataLengthIndicator) {
            return false;
        }
        if (this.encryption != other.encryption) {
            return false;
        }
        if (this.group != other.group) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.preserveFile != other.preserveFile) {
            return false;
        }
        if (this.preserveTag != other.preserveTag) {
            return false;
        }
        if (this.readOnly != other.readOnly) {
            return false;
        }
        return this.unsynchronisation == other.unsynchronisation;
    }
}

