/*
 * Decompiled with CFR 0.152.
 */
package com.mpatric.mp3agic;

import com.mpatric.mp3agic.AbstractID3v2FrameData;
import com.mpatric.mp3agic.BufferTools;
import com.mpatric.mp3agic.InvalidDataException;
import java.io.UnsupportedEncodingException;

public class ID3v2WWWFrameData
extends AbstractID3v2FrameData {
    protected String url;

    public ID3v2WWWFrameData(boolean unsynchronisation) {
        super(unsynchronisation);
    }

    public ID3v2WWWFrameData(boolean unsynchronisation, String url) {
        super(unsynchronisation);
        this.url = url;
    }

    public ID3v2WWWFrameData(boolean unsynchronisation, byte[] bytes) throws InvalidDataException {
        super(unsynchronisation);
        this.synchroniseAndUnpackFrameData(bytes);
    }

    @Override
    protected void unpackFrameData(byte[] bytes) throws InvalidDataException {
        try {
            this.url = BufferTools.byteBufferToString(bytes, 0, bytes.length);
        }
        catch (UnsupportedEncodingException e) {
            this.url = "";
        }
    }

    @Override
    protected byte[] packFrameData() {
        byte[] bytes = new byte[this.getLength()];
        if (this.url != null && this.url.length() > 0) {
            try {
                BufferTools.stringIntoByteBuffer(this.url, 0, this.url.length(), bytes, 0);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return bytes;
    }

    @Override
    protected int getLength() {
        int length = 0;
        if (this.url != null) {
            length = this.url.length();
        }
        return length;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

