/*
 * Decompiled with CFR 0.152.
 */
package vazkii.minetunes.playlist.provider;

import java.io.File;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import vazkii.minetunes.playlist.Playlist;
import vazkii.minetunes.playlist.provider.IProviderStateCallback;

public abstract class PlaylistProvider {
    IProviderStateCallback callback;
    int foundFiles = 0;
    int processedFiles = 0;
    String name = "";

    public abstract Playlist provide(File var1, IProviderStateCallback var2);

    public abstract String getDescription();

    void updateState() {
        if (this.callback != null) {
            this.callback.setState(this.generateProgressState());
        }
    }

    String generateProgressState() {
        if (this.foundFiles > 0) {
            if (this.processedFiles > 0) {
                int percent = (int)((float)this.processedFiles / (float)this.foundFiles * 100.0f);
                EnumChatFormatting format = EnumChatFormatting.RED;
                if (percent > 50) {
                    format = EnumChatFormatting.YELLOW;
                }
                if (percent > 90) {
                    format = EnumChatFormatting.GREEN;
                }
                return String.format(StatCollector.func_74838_a((String)"minetunes.playlist.generator.processing"), this.processedFiles, this.foundFiles) + format + " (" + percent + "%)";
            }
            return String.format(StatCollector.func_74838_a((String)"minetunes.playlist.generator.scanning"), this.foundFiles);
        }
        return StatCollector.func_74838_a((String)"minetunes.playlist.generator.starting");
    }
}

