/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.enchantview;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerEnchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerOpenContainerEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebombzen.mods.enchantview.Configuration;
import thebombzen.mods.enchantview.TableState;
import thebombzen.mods.thebombzenapi.ThebombzenAPI;
import thebombzen.mods.thebombzenapi.ThebombzenAPIBaseMod;

@Mod(modid="enchantview", name="EnchantView", version="5.0.0", dependencies="required-after:thebombzenapi", guiFactory="thebombzen.mods.enchantview.client.ConfigGuiFactory", acceptedMinecraftVersions="[1.8]")
public class EnchantView
extends ThebombzenAPIBaseMod {
    @Mod.Instance(value="enchantview")
    public static EnchantView instance;
    private Configuration configuration;
    private Map<UUID, Long> tickTimes = new HashMap<UUID, Long>();
    private Map<UUID, TableState> prevTableStates = new HashMap<UUID, TableState>();
    private Map<UUID, int[][]> hints = new HashMap<UUID, int[][]>();

    @NetworkCheckHandler
    public boolean checkNetwork(Map<String, String> modsList, Side remote) {
        return true;
    }

    @SubscribeEvent
    public void playerHasContainerOpen(PlayerOpenContainerEvent event) {
        UUID uuid = event.entityPlayer.func_110124_au();
        if (!(event.entityPlayer.field_71070_bA instanceof ContainerEnchantment)) {
            this.purgeUUID(uuid);
            return;
        }
        ContainerEnchantment container = (ContainerEnchantment)event.entityPlayer.field_71070_bA;
        if (!this.tickTimes.containsKey(uuid)) {
            this.tickTimes.put(uuid, 0L);
        }
        this.tickTimes.put(uuid, this.tickTimes.get(uuid) + 1L);
        TableState state = new TableState(container);
        if (!this.prevTableStates.containsKey(uuid) || !this.prevTableStates.get(uuid).equals(state)) {
            this.prevTableStates.put(uuid, state);
            this.tableUpdated(event.entityPlayer);
        }
        if (this.tickTimes.get(uuid) % 20L == 0L) {
            this.cycleHint(event.entityPlayer);
        }
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        for (UUID uuid : this.tickTimes.keySet()) {
            if (MinecraftServer.func_71276_C().func_175576_a(uuid) != null) continue;
            this.purgeUUID(uuid);
        }
    }

    private void purgeUUID(UUID uuid) {
        this.tickTimes.remove(uuid);
        this.prevTableStates.remove(uuid);
        this.hints.remove(uuid);
    }

    private void tableUpdated(EntityPlayer player) {
        UUID uuid = player.func_110124_au();
        this.tickTimes.put(uuid, 0L);
        player.func_71013_b(0);
        ContainerEnchantment container = (ContainerEnchantment)player.field_71070_bA;
        container.field_178149_f = player.func_175138_ci();
        int[][] hints = new int[3][];
        for (int j = 0; j < 3; ++j) {
            if (container.field_75167_g[j] <= 0) continue;
            List list = (List)ThebombzenAPI.invokePrivateMethod((Object)container, ContainerEnchantment.class, (String[])new String[]{"func_178148_a", "a"}, (Class[])new Class[]{ItemStack.class, Integer.TYPE, Integer.TYPE}, (Object[])new Object[]{container.field_75168_e.func_70301_a(0), j, container.field_75167_g[j]});
            if (list != null && !list.isEmpty()) {
                hints[j] = new int[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    EnchantmentData enchantmentdata = (EnchantmentData)list.get(i);
                    hints[j][i] = enchantmentdata.field_76302_b.field_77352_x | enchantmentdata.field_76303_c << 8;
                }
                continue;
            }
            hints[j] = null;
        }
        this.hints.put(uuid, hints);
    }

    private void cycleHint(EntityPlayer player) {
        UUID uuid = player.func_110124_au();
        ContainerEnchantment container = (ContainerEnchantment)player.field_71070_bA;
        int[][] hints = this.hints.get(uuid);
        if (hints == null) {
            return;
        }
        for (int j = 0; j < 3; ++j) {
            int[] currHints = hints[j];
            if (currHints == null) {
                return;
            }
            container.field_178151_h[j] = currHints[(int)(this.tickTimes.get(uuid) / 20L % (long)currHints.length)];
        }
        container.func_75142_b();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getDownloadLocationURLString() {
        return "http://is.gd/ThebombzensMods#EnchantView";
    }

    public String getLongName() {
        return "EnchantView";
    }

    public String getLongVersionString() {
        return "EnchantView, version 5.0.0, Minecraft 1.8";
    }

    @SideOnly(value=Side.CLIENT)
    public int getNumToggleKeys() {
        return 0;
    }

    public String getShortName() {
        return "EV";
    }

    @SideOnly(value=Side.CLIENT)
    protected String getToggleMessageString(int index, boolean enabled) {
        return null;
    }

    public String getVersionFileURLString() {
        return "https://dl.dropboxusercontent.com/u/51080973/Mods/EnchantView/EVVersion.txt";
    }

    public void init1(FMLPreInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.configuration = new Configuration(this);
        FMLCommonHandler.instance().findContainerFor((Object)((Object)this)).getMetadata().authorList = Arrays.asList("Thebombzen");
    }
}

