/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.enchantview.installer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Scanner;
import java.util.jar.JarFile;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class EVInstallerFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JTextField textField;
    private String clientDirectory = EVInstallerFrame.getMinecraftClientDirectory();
    private String serverDirectory = "";
    private JDialog dialog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        AbstractInterruptibleChannel source = null;
        AbstractInterruptibleChannel destination = null;
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            inStream = new FileInputStream(sourceFile);
            outStream = new FileOutputStream(destFile);
            source = inStream.getChannel();
            destination = outStream.getChannel();
            long count = 0L;
            long size = ((FileChannel)source).size();
            while ((count += ((FileChannel)destination).transferFrom((ReadableByteChannel)((Object)source), count, size - count)) < size) {
            }
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static String getMinecraftClientDirectory() throws IOException {
        String name = System.getProperty("os.name");
        if (name.toLowerCase().contains("windows")) {
            return new File(System.getenv("appdata") + "\\.minecraft").getCanonicalPath();
        }
        if (name.toLowerCase().contains("mac") || name.toLowerCase().contains("osx") || name.toLowerCase().contains("os x")) {
            return new File(System.getProperty("user.home") + "/Library/Application Support/minecraft").getCanonicalPath();
        }
        return new File(System.getProperty("user.home") + "/.minecraft").getCanonicalPath();
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            if (args[0].equals("--no-gui") || args[0].equals("-n")) {
                EVInstallerFrame.installNoGui(EVInstallerFrame.getMinecraftClientDirectory());
                return;
            }
            System.err.println("Run with --no-gui or -n to install without a gui.");
        }
        new EVInstallerFrame().setVisible(true);
    }

    public EVInstallerFrame() throws IOException {
        final EVInstallerFrame frame = this;
        Box superBox = Box.createHorizontalBox();
        superBox.add(Box.createHorizontalStrut(10));
        Box content = Box.createVerticalBox();
        content.add(Box.createVerticalStrut(10));
        JRadioButton installClient = new JRadioButton("Install Client");
        installClient.setSelected(true);
        JRadioButton installServer = new JRadioButton("Install Server");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(installClient);
        buttonGroup.add(installServer);
        Box selectBox = Box.createHorizontalBox();
        selectBox.add(installClient);
        selectBox.add(Box.createHorizontalStrut(10));
        selectBox.add(installServer);
        content.add(selectBox);
        content.add(Box.createVerticalStrut(10));
        JLabel label = new JLabel("Select minecraft folder:");
        Box labelBox = Box.createHorizontalBox();
        labelBox.add(label);
        labelBox.add(Box.createHorizontalGlue());
        content.add(labelBox);
        Box textBox = Box.createHorizontalBox();
        this.textField = new JTextField();
        this.textField.setText(this.clientDirectory);
        textBox.add(this.textField);
        textBox.add(Box.createHorizontalStrut(10));
        JButton browseButton = new JButton("Browse");
        textBox.add(browseButton);
        content.add(textBox);
        content.add(Box.createVerticalStrut(10));
        JLabel forgeLabel = new JLabel("Remember to also install Minecraft Forge.");
        Box forgeLabelBox = Box.createHorizontalBox();
        forgeLabelBox.add(forgeLabel);
        forgeLabelBox.add(Box.createHorizontalGlue());
        content.add(forgeLabelBox);
        Box forgeLinkBox = Box.createHorizontalBox();
        JLabel forgeLinkLabel = new JLabel("<html><a href=\"http://files.minecraftforge.net/\">Download Minecraft Forge Here</a></html>");
        forgeLinkBox.add(forgeLinkLabel);
        forgeLinkBox.add(Box.createHorizontalGlue());
        content.add(forgeLinkBox);
        content.add(Box.createVerticalStrut(10));
        JButton install = new JButton("Install EnchantView");
        Box installBox = Box.createHorizontalBox();
        installBox.add(Box.createHorizontalGlue());
        installBox.add(install);
        installBox.add(Box.createHorizontalGlue());
        content.add(installBox);
        content.add(Box.createVerticalStrut(10));
        superBox.add(content);
        superBox.add(Box.createHorizontalStrut(10));
        installClient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EVInstallerFrame.this.clickedInstallClient();
            }
        });
        installServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                EVInstallerFrame.this.clickedInstallServer();
            }
        });
        install.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        EVInstallerFrame.this.install();
                    }
                }).start();
            }
        });
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JFileChooser jfc = new JFileChooser();
                jfc.setMultiSelectionEnabled(false);
                jfc.setFileSelectionMode(1);
                int result = jfc.showOpenDialog(frame);
                if (result == 0) {
                    EVInstallerFrame.this.textField.setText(jfc.getSelectedFile().getAbsolutePath());
                }
            }
        });
        forgeLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                try {
                    Desktop.getDesktop().browse(new URI("http://files.minecraftforge.net/"));
                }
                catch (IOException e) {
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        });
        this.add(superBox);
        this.setTitle("Install EnchantView");
        this.pack();
        this.setDefaultCloseOperation(3);
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((size.width - this.getWidth()) / 2, (size.height - this.getHeight()) / 2);
        this.dialog = new JDialog(this);
        this.dialog.setLayout(new BorderLayout());
        this.dialog.add(Box.createVerticalStrut(15), "North");
        this.dialog.add(Box.createVerticalStrut(15), "South");
        this.dialog.add(Box.createHorizontalStrut(25), "West");
        this.dialog.add(Box.createHorizontalStrut(25), "East");
        this.dialog.add((Component)new JLabel("Installing..."), "Center");
        this.dialog.setTitle("Installing");
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.pack();
        this.dialog.setLocation(this.getX() + (this.getWidth() - this.dialog.getWidth()) / 2, this.getY() + (this.getHeight() - this.dialog.getHeight()) / 2);
    }

    private void clickedInstallClient() {
        this.serverDirectory = this.textField.getText();
        this.textField.setText(this.clientDirectory);
    }

    private void clickedInstallServer() {
        this.clientDirectory = this.textField.getText();
        this.textField.setText(this.serverDirectory);
    }

    private static String getThebombzenAPILatestVersion() throws IOException {
        String latestVersion = null;
        BufferedReader br = null;
        try {
            URL versionURL = new URL("https://dl.dropboxusercontent.com/u/51080973/mods/ThebombzenAPI/Latest-1.8.txt");
            br = new BufferedReader(new InputStreamReader(versionURL.openStream()));
            latestVersion = br.readLine();
            latestVersion = latestVersion + String.format("%n%s%n", br.readLine());
        }
        catch (MalformedURLException e) {
            throw new Error();
        }
        finally {
            br.close();
        }
        return latestVersion;
    }

    private void install() {
        try {
            this.install(this.textField.getText());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dialog.dispose();
            JOptionPane.showMessageDialog(this, "Error installing. Install manually.", "Error Installing", 0);
        }
        System.exit(0);
    }

    private static void installNoGui(String directory) throws Exception {
        File dir = new File(directory);
        if (!dir.isDirectory()) {
            System.err.println("Invalid directory: " + directory);
            return;
        }
        File modsFolder = new File(directory, "mods");
        modsFolder.mkdir();
        File versionFolder = new File(modsFolder, "1.8");
        versionFolder.mkdir();
        File file = new File(EVInstallerFrame.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        JarFile jarFile = new JarFile(file);
        if (jarFile.getEntry("thebombzen/mods/enchantview/installer/EVInstallerFrame.class") == null) {
            jarFile.close();
            throw new Exception("Unable to open jar file!");
        }
        jarFile.close();
        EVInstallerFrame.installThebombzenAPI(directory);
        File[] mods = modsFolder.listFiles();
        File[] modsVersion = versionFolder.listFiles();
        for (File testMod : mods) {
            if (!testMod.getName().matches("^EnchantView(Mod)?-v\\d\\.\\d(\\.\\d)?-mc(beta)?\\d\\.\\d(\\.\\d)?\\.(jar|zip)$")) continue;
            testMod.delete();
        }
        for (File testMod : modsVersion) {
            if (!testMod.getName().matches("^EnchantView(Mod)?-v\\d\\.\\d(\\.\\d)?-mc(beta)?\\d\\.\\d(\\.\\d)?\\.(jar|zip)$")) continue;
            testMod.delete();
        }
        EVInstallerFrame.copyFile(file, new File(versionFolder, file.getName()));
    }

    private void install(String directory) throws Exception {
        File dir = new File(directory);
        if (!dir.isDirectory()) {
            JOptionPane.showMessageDialog(this, "Something's wrong with the given folder. Check spelling and try again.", "Hmmm...", 0);
            return;
        }
        this.dialog.setVisible(true);
        EVInstallerFrame.installNoGui(directory);
        this.dialog.dispose();
        JOptionPane.showMessageDialog(this, "Successfully installed EnchantView!", "Success!", 1);
    }

    private static void installThebombzenAPI(String directory) throws Exception {
        String latest = EVInstallerFrame.getThebombzenAPILatestVersion();
        Scanner scanner = new Scanner(latest);
        scanner.useDelimiter(String.format("%n", new Object[0]));
        String fileName = scanner.next();
        String url = scanner.next();
        scanner.close();
        File modsFolder = new File(directory, "mods");
        modsFolder.mkdir();
        File versionFolder = new File(modsFolder, "1.8");
        versionFolder.mkdir();
        File thebombzenAPI = new File(versionFolder, fileName);
        if (thebombzenAPI.exists()) {
            return;
        }
        URL downloadURL = new URL(url);
        File[] subFiles = modsFolder.listFiles();
        File[] versionSubFiles = versionFolder.listFiles();
        for (File file : subFiles) {
            if (!file.getName().matches("^ThebombzenAPI-v\\d+\\.\\d+(\\.\\d+)?-mc\\d+\\.\\d+(\\.\\d+)?\\.(zip|jar)$")) continue;
            file.delete();
        }
        for (File file : versionSubFiles) {
            if (!file.getName().matches("^ThebombzenAPI-v\\d+\\.\\d+(\\.\\d+)?-mc\\d+\\.\\d+(\\.\\d+)?\\.(zip|jar)$")) continue;
            file.delete();
        }
        FileOutputStream fos = new FileOutputStream(thebombzenAPI);
        ReadableByteChannel channel = Channels.newChannel(downloadURL.openStream());
        fos.getChannel().transferFrom(channel, 0L, Long.MAX_VALUE);
        channel.close();
        fos.close();
    }
}

