/*
 * Decompiled with CFR 0.152.
 */
package com.pvp.events;

import com.pvp.BetterPvP;
import com.pvp.animation.Animation;
import com.pvp.gui.GuiMisc;
import com.pvp.gui.GuiUpdate;
import com.pvp.gui.MyOptions;
import com.pvp.interfaces.InterfaceHandler;
import com.pvp.minimap.Minimap;
import com.pvp.minimap.Waypoint;
import com.pvp.settings.ModSettings;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiOptions;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class Events {
    public Object lastGuiOpen;
    int deathCounter = 0;
    private static boolean askedToUpdate = false;

    @SubscribeEvent
    public void drawPost(GuiOpenEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.gui instanceof GuiOptions) {
            event.gui = new MyOptions(null, mc.field_71474_y);
            try {
                BetterPvP.getSettings().saveSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.lastGuiOpen = event.gui;
    }

    @SubscribeEvent
    public void drawPre(RenderGameOverlayEvent.Pre event) {
        if (Keyboard.isKeyDown((int)1)) {
            InterfaceHandler.cancel();
        }
        if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR) {
            Minecraft.func_71410_x().field_71460_t.func_78478_c();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            InterfaceHandler.drawInterfaces(event.partialTicks);
            Animation.tick();
        }
    }

    @SubscribeEvent
    public void guiOpen(GuiOpenEvent event) {
        if (event.gui instanceof GuiMainMenu || event.gui instanceof GuiMultiplayer) {
            BetterPvP.getSettings().resetServerSettings();
        }
        if (event.gui instanceof GuiGameOver) {
            ++this.deathCounter;
            if ((this.deathCounter & 1) == 0) {
                this.createDeathpoint((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            }
        }
    }

    public void createDeathpoint(EntityPlayer p) {
        boolean disabled = false;
        if (Minimap.waypoints == null) {
            return;
        }
        for (Waypoint w : Minimap.waypoints) {
            if (w.type != 1) continue;
            if (!BetterPvP.getSettings().getDeathpoints() || !BetterPvP.getSettings().getOldDeathpoints()) {
                Minimap.waypoints.remove(w);
                break;
            }
            disabled = w.disabled;
            w.type = 0;
            w.name = "gui.xaero_deathpoint_old";
            break;
        }
        if (BetterPvP.getSettings().getDeathpoints()) {
            Waypoint deathpoint = new Waypoint(Minimap.myFloor(p.field_70165_t), Minimap.myFloor(p.field_70163_u), Minimap.myFloor(p.field_70161_v), "gui.xaero_deathpoint", "D", 0, 1);
            deathpoint.disabled = disabled;
            Minimap.waypoints.add(deathpoint);
        }
        try {
            BetterPvP.settings.saveSettings();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void chatMessage(ClientChatReceivedEvent e) {
        String text = e.message.func_150254_d();
        if (text.contains("\u00a7c \u00a7r\u00a75 \u00a7r\u00a71 \u00a7r\u00a7f")) {
            String code = text.substring(text.indexOf("f") + 1);
            code = code.replaceAll("\u00a7", "").replaceAll("r", "").replaceAll(" ", "");
            BetterPvP.getSettings().resetServerSettings();
            ModSettings.serverSettings &= Integer.parseInt(code);
            System.out.println("Code: " + code);
        }
    }

    @SubscribeEvent
    public void renderLast(RenderWorldLastEvent event) {
        if (BetterPvP.settings.getShowIngameWaypoints() && Minimap.waypoints != null) {
            Entity entity = Minecraft.func_71410_x().func_175606_aa();
            double d3 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)event.partialTicks;
            double d4 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)event.partialTicks;
            double d5 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)event.partialTicks;
            Tessellator tessellator = Tessellator.func_178181_a();
            WorldRenderer worldrenderer = tessellator.func_178180_c();
            for (Waypoint w : Minimap.waypoints) {
                if (w == null || w.disabled || w.type == 1 && !BetterPvP.getSettings().getDeathpoints()) continue;
                this.renderIngameWaypoint(w, 12.0, d3, d4, d5, entity, worldrenderer, tessellator);
            }
            RenderHelper.func_74518_a();
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
        }
    }

    protected void renderIngameWaypoint(Waypoint w, double radius, double d3, double d4, double d5, Entity entity, WorldRenderer worldrenderer, Tessellator tessellator) {
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        FontRenderer fontrenderer = renderManager.func_78716_a();
        if (fontrenderer == null) {
            return;
        }
        float f = 1.6f;
        float f1 = 0.016666668f * f;
        GlStateManager.func_179094_E();
        float offX = (float)w.x - (float)d3 + 0.5f;
        float offY = (float)w.y - (float)d4 + 1.0f;
        float offZ = (float)w.z - (float)d5 + 0.5f;
        double distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
        float textSize = 1.0f;
        boolean background = false;
        String name = w.getName();
        boolean showDistance = false;
        if (distance > radius) {
            float zoomer = (float)(radius / distance);
            offX *= zoomer;
            offY *= zoomer;
            offY += entity.func_70047_e() * (1.0f - zoomer);
            offZ *= zoomer;
            if (distance > 20.0) {
                textSize = 1.6f;
                if (BetterPvP.getSettings().distance == 1) {
                    float cameraAngle;
                    float Z = (float)(offZ == 0.0f ? 0.001 : (double)offZ);
                    float angle = (float)Math.toDegrees(Math.atan(-offX / Z));
                    if (offZ < 0.0f) {
                        angle = offX < 0.0f ? (angle += 180.0f) : (angle -= 180.0f);
                    }
                    showDistance = angle - (cameraAngle = MathHelper.func_76142_g((float)entity.field_70177_z)) > -20.0f && angle - cameraAngle < 20.0f;
                } else if (BetterPvP.getSettings().distance == 2) {
                    showDistance = true;
                }
                if (showDistance) {
                    name = GuiMisc.simpleFormat.format(distance) + "m";
                    background = true;
                } else {
                    name = "";
                }
            }
        }
        GlStateManager.func_179109_b((float)offX, (float)offY, (float)offZ);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-f1), (float)(-f1), (float)f1);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        w.drawIconInWorld(worldrenderer, tessellator, fontrenderer, name, textSize, background, showDistance);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void renderTick(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.gui instanceof GuiUpdate) {
            askedToUpdate = true;
        } else if (!askedToUpdate && BetterPvP.isOutdated && event.gui instanceof GuiMainMenu) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiUpdate());
            System.out.println("Better PVP Mod is outdated!");
        } else if (BetterPvP.isOutdated) {
            BetterPvP.isOutdated = false;
        }
    }

    @SubscribeEvent
    public void textureStitch(TextureStitchEvent.Post event) {
        Minimap.clearBlockColours = true;
    }
}

