/*
 * Decompiled with CFR 0.152.
 */
package com.pvp.gui;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;

public class GuiDropDown
extends Gui {
    public int x;
    public int y;
    public int xOffset = 0;
    public int yOffset = 0;
    public int w;
    private String[] realOptions = new String[0];
    private String[] options = new String[0];
    private int[] realValues = new int[0];
    private int[] values = new int[0];
    public static final Color background = new Color(0, 0, 0, 200);
    public static final Color trim = new Color(160, 160, 160, 255);
    public static final Color trimInside = new Color(50, 50, 50, 255);
    private static final int h = 11;
    public int selected = 0;
    public boolean closed = true;
    protected String screenTitle;

    public GuiDropDown(String[] options, int x, int y, int w, Integer selected) {
        this(options, GuiDropDown.createDefaultValues(options.length), x, y, w, selected);
    }

    public GuiDropDown(String[] options, int[] values, int x, int y, int w, Integer selected) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.realOptions = options;
        this.realValues = values;
        this.selectValue(selected);
    }

    public static int[] createDefaultValues(int length) {
        int[] values = new int[length];
        for (int i = 0; i < length; ++i) {
            values[i] = i;
        }
        return values;
    }

    public int getX() {
        return this.x + this.xOffset;
    }

    public int getY() {
        return this.y + this.yOffset;
    }

    public int getValue(int slot) {
        return this.values[slot];
    }

    public String getSelectedOption() {
        return this.realOptions[this.selected];
    }

    public void drawSlot(int id, int pos, int mouseX, int mouseY) {
        if (this.closed && this.onDropDown(mouseX, mouseY) || !this.closed && this.onDropDown(mouseX, mouseY, id)) {
            GuiDropDown.func_73734_a((int)this.getX(), (int)(this.getY() + 11 * pos), (int)(this.getX() + this.w), (int)(this.getY() + 11 + 11 * pos), (int)trimInside.hashCode());
        } else {
            GuiDropDown.func_73734_a((int)this.getX(), (int)(this.getY() + 11 * pos), (int)(this.getX() + this.w), (int)(this.getY() + 11 + 11 * pos), (int)background.hashCode());
        }
        this.func_73730_a(this.getX() + 1, this.getX() + this.w - 1, this.getY() + 11 * pos, trimInside.hashCode());
        this.func_73732_a(Minecraft.func_71410_x().field_71466_p, this.options[id], this.getX() + this.w / 2, this.getY() + 2 + 11 * pos, 0xFFFFFF);
    }

    public void drawSelection(int first, int amount, int mouseX, int mouseY) {
        int totalH = 11 * amount;
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
        int height = scaledresolution.func_78328_b();
        this.yOffset = this.y + totalH + 1 > height ? height - this.y - totalH - 1 : 0;
        for (int i = first; i < first + amount; ++i) {
            this.drawSlot(i, i - first, mouseX, mouseY);
        }
        this.func_73728_b(this.getX(), this.getY(), this.getY() + totalH, trim.hashCode());
        this.func_73728_b(this.getX() + this.w, this.getY(), this.getY() + totalH, trim.hashCode());
        this.func_73730_a(this.getX(), this.getX() + this.w, this.getY(), trim.hashCode());
        this.func_73730_a(this.getX(), this.getX() + this.w, this.getY() + totalH, trim.hashCode());
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (!this.closed) {
            int clickedValue = this.getClickedValue(mouseX, mouseY);
            if (clickedValue != -1) {
                this.selectValue(clickedValue);
            }
        } else {
            this.closed = false;
        }
    }

    private int getClickedValue(int mouseX, int mouseY) {
        int xOnMenu = mouseX - this.getX();
        int yOnMenu = mouseY - this.getY();
        if (xOnMenu < 0 || yOnMenu < 0 || xOnMenu > this.w || yOnMenu >= this.options.length * 11) {
            return -1;
        }
        int slot = yOnMenu / 11;
        if (slot >= this.options.length) {
            slot = this.options.length - 1;
        }
        return this.values[slot];
    }

    public boolean onDropDown(int mouseX, int mouseY) {
        int xOnMenu = mouseX - this.getX();
        int yOnMenu = mouseY - this.getY();
        return xOnMenu >= 0 && yOnMenu >= 0 && xOnMenu <= this.w && yOnMenu < (this.closed ? 11 : this.options.length * 11);
    }

    public boolean onDropDown(int mouseX, int mouseY, int id) {
        int xOnMenu = mouseX - this.getX();
        int yOnMenu = mouseY - this.getY();
        return xOnMenu >= 0 && yOnMenu >= id * 11 && xOnMenu <= this.w && yOnMenu < id * 11 + 11;
    }

    public void selectValue(int id) {
        this.selected = id;
        this.closed = true;
        this.options = (String[])this.realOptions.clone();
        this.values = (int[])this.realValues.clone();
        this.options[0] = this.realOptions[this.selected];
        this.values[0] = this.realValues[this.selected];
        for (int i = this.selected; i > 0; --i) {
            this.options[i] = this.realOptions[i - 1];
            this.values[i] = this.realValues[i - 1];
        }
    }

    public void drawButton(int mouseX, int mouseY) {
        this.drawSelection(0, this.closed ? 1 : this.options.length, mouseX, mouseY);
    }
}

