/*
 * Decompiled with CFR 0.152.
 */
package com.pvp.interfaces;

import com.pvp.BetterPvP;
import com.pvp.gui.GuiArmour;
import com.pvp.gui.GuiEditMode;
import com.pvp.gui.GuiMinimap;
import com.pvp.gui.GuiNotifications;
import com.pvp.interfaces.Interface;
import com.pvp.interfaces.Preset;
import com.pvp.minimap.Minimap;
import com.pvp.minimap.Waypoint;
import com.pvp.notifications.Notification;
import com.pvp.notifications.NotificationHandler;
import com.pvp.settings.ModOptions;
import com.pvp.settings.ModSettings;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class InterfaceHandler {
    public static int actionTimer = 0;
    public static ArrayList<Preset> presets = new ArrayList();
    public static ArrayList<Interface> list = new ArrayList();
    public static final ResourceLocation invtextures = new ResourceLocation("textures/gui/container/inventory.png");
    public static Minecraft mc = Minecraft.func_71410_x();
    private static RenderItem itemRenderer = mc.func_175599_af();
    public static int selectedId = -1;
    public static int draggingId = -1;
    public static int draggingOffX = 0;
    public static int draggingOffY = 0;
    public static Minimap minimap;
    public static final ResourceLocation guiTextures;
    public static final ResourceLocation mapTextures;
    public static long arrowWas;
    private static boolean blinking;
    private static long lastBlink;
    public static long lastFlip;
    public static final Color disabled;
    public static final Color enabled;
    public static final Color selected;

    public static void loadPresets() {
        new Preset("gui.xaero_preset_fancy", new int[][]{{0, 0}, {0, 10000}, {0, 10000}, {0, 36}, {0, 0}}, new boolean[][]{{true, false}, {true, false}, {true, false}, {true, false}, {false, true}});
        new Preset("gui.xaero_preset_classic", new int[][]{{0, 0}, {0, 10000}, {0, 10000}, {0, 0}, {0, 0}}, new boolean[][]{{false, true}, {false, true}, {true, false}, {true, false}, {false, false}});
        new Preset("gui.xaero_preset_social", new int[][]{{0, 0}, {0, 0}, {0, 10000}, {0, 41}, {0, 0}}, new boolean[][]{{true, false}, {true, false}, {true, false}, {true, false}, {false, false}});
    }

    public static void load() {
        new Interface("gui.xaero_potion_status", 120, 165, 182, 36, ModOptions.SHOW_EFFECTS){

            @Override
            public void drawInterface(int width, int height, int scale, float partial) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)3008);
                if (!InterfaceHandler.mc.field_71439_g.func_70651_bq().isEmpty()) {
                    InterfaceHandler.displayDebuffEffects(width, height);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                super.drawInterface(width, height, scale, partial);
            }
        };
        new Interface("gui.xaero_armour_status", 150, 98, 400, 41, ModOptions.SHOW_ARMOR){

            @Override
            public void drawInterface(int width, int height, int scale, float partial) {
                GL11.glEnable((int)3008);
                if (!this.centered) {
                    InterfaceHandler.drawClassicArmour(this.x, this.y, this.w, this.h, width, height, this.flipped);
                } else {
                    InterfaceHandler.drawCenteredArmour(this.x, this.y, this.w, this.h, width, height);
                }
                RenderHelper.func_74518_a();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                super.drawInterface(width, height, scale, partial);
            }
        };
        new Interface("gui.xaero_xp_setting", 50, 86, ModOptions.XP){
            private int lastXPCheck = 0;
            public long xpDelay = 0L;

            @Override
            public void drawInterface(int width, int height, int scale, float partial) {
                EntityPlayerSP player = InterfaceHandler.mc.field_71439_g;
                NotificationHandler nh = BetterPvP.notificationHandler;
                if (System.currentTimeMillis() - this.xpDelay >= 1000L) {
                    this.xpDelay = System.currentTimeMillis();
                    int totalXP = player.field_71067_cb;
                    if (this.lastXPCheck != totalXP) {
                        String xp = (totalXP - this.lastXPCheck > 0 ? "\u00a7e+" : "\u00a7e") + (totalXP - this.lastXPCheck) + " XP";
                        nh.notifications.add(new Notification(xp, 5000, this.x + this.w / 2 - InterfaceHandler.mc.field_71466_p.func_78256_a(xp) / 2, this.y + 39));
                        this.lastXPCheck = totalXP;
                    }
                }
                BetterPvP.notificationHandler.drawNotifications();
                super.drawInterface(width, height, scale, partial);
            }
        };
        new Interface("gui.xaero_notifications", 200, 42, ModOptions.NOTIFICATIONS){

            @Override
            public void drawInterface(int width, int height, int scale, float partial) {
                ArrayList<Integer> notifications = new ArrayList<Integer>();
                if ((float)InterfaceHandler.mc.field_71439_g.func_71024_bL().func_75116_a() <= (float)(2 * BetterPvP.settings.lowHunger) && BetterPvP.settings.getNotificationHunger()) {
                    notifications.add(0);
                }
                if (InterfaceHandler.mc.field_71439_g.func_110143_aJ() <= (float)(2 * BetterPvP.settings.lowHealth) && BetterPvP.settings.getNotificationHP()) {
                    notifications.add(1);
                }
                if (InterfaceHandler.tntIsAround() && BetterPvP.settings.getNotificationTNT()) {
                    notifications.add(2);
                }
                if (InterfaceHandler.arrowIsAround() && BetterPvP.settings.getNotificationArrow()) {
                    notifications.add(3);
                }
                if (InterfaceHandler.mc.field_71439_g.func_70086_ai() <= 30 * BetterPvP.settings.lowAir && BetterPvP.settings.getNotificationAir()) {
                    notifications.add(4);
                }
                int between = 32 - 4 * notifications.size();
                int unitSize = 32 + between;
                int length = notifications.size() * unitSize;
                int drawY = this.y + (this.h - 32) / 2;
                GL11.glEnable((int)3008);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (length > 0) {
                    mc.func_110434_K().func_110577_a(guiTextures);
                    if (blinking) {
                        GL11.glColor4f((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
                    }
                    for (int i = 0; i < notifications.size(); ++i) {
                        int n = (Integer)notifications.get(i);
                        int drawX = this.x + this.w / 2 - length / 2 + i * unitSize + between / 2;
                        InterfaceHandler.mc.field_71456_v.func_73729_b(drawX, drawY, 17, n * 32, 32, 32);
                    }
                    mc.func_110434_K().func_110577_a(Gui.field_110324_m);
                }
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                super.drawInterface(width, height, scale, partial);
            }
        };
        minimap = new Minimap(new Interface("gui.xaero_minimap", 128, 128, ModOptions.MINIMAP){
            long lastFBOTry = 0L;

            @Override
            public int getW(int scale) {
                return this.getSize() / scale;
            }

            @Override
            public int getH(int scale) {
                return this.getW(scale);
            }

            @Override
            public int getWC(int scale) {
                return this.getW(scale);
            }

            @Override
            public int getHC(int scale) {
                return this.getH(scale);
            }

            @Override
            public int getW0(int scale) {
                return this.getW(scale);
            }

            @Override
            public int getH0(int scale) {
                return this.getH(scale);
            }

            @Override
            public int getSize() {
                return minimap.getMinimapWidth() + 36 + 2;
            }

            public void drawWaypoint(int specW, int specH, double ps, double pc, double offx, double offy, Waypoint w, String compass) {
                double X;
                double Y = (pc * offx + ps * offy) * Minimap.zoom;
                double borderedX = X = (ps * offx - pc * offy) * Minimap.zoom;
                double borderedY = Y;
                if (borderedX > (double)specW) {
                    borderedX = specW;
                    borderedY = Y * (double)specW / X;
                } else if (borderedX < (double)(-specW)) {
                    borderedX = -specW;
                    borderedY = -Y * (double)specW / X;
                }
                if (borderedY > (double)specH) {
                    borderedY = specH;
                    borderedX = X * (double)specH / Y;
                } else if (borderedY < (double)(-specH)) {
                    borderedY = -specH;
                    borderedX = -X * (double)specH / Y;
                }
                GL11.glPushMatrix();
                GlStateManager.func_179137_b((double)borderedX, (double)borderedY, (double)0.0);
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
                if (w != null) {
                    w.drawIconOnGUI(-4, -4);
                } else {
                    Minecraft.func_71410_x().field_71466_p.func_175063_a(compass, (float)(1 - InterfaceHandler.mc.field_71466_p.func_78256_a(compass) / 2), -3.0f, Minimap.radarPlayers.hashCode());
                }
                GL11.glPopMatrix();
            }

            @Override
            public void drawInterface(int width, int height, int scale, float partial) {
                int specW;
                int mapW;
                if (Minimap.loadedFBO && !OpenGlHelper.func_148822_b()) {
                    Minimap.loadedFBO = false;
                    Minimap.scalingFrameBuffer.func_147608_a();
                    Minimap.rotationFrameBuffer.func_147608_a();
                    Minimap.resetImage();
                }
                if (!Minimap.loadedFBO && !BetterPvP.getSettings().mapSafeMode && System.currentTimeMillis() - this.lastFBOTry > 1000L) {
                    this.lastFBOTry = System.currentTimeMillis();
                    Minimap.loadFrameBuffer();
                }
                long before = System.currentTimeMillis();
                int bufferSize = Minimap.usingFBO() ? minimap.getFBOBufferSize() : minimap.getBufferSize();
                float mapScale = (float)scale / 2.0f;
                int mapH = InterfaceHandler.minimap.minimapHeight = (mapW = (InterfaceHandler.minimap.minimapWidth = minimap.getMinimapWidth()));
                Minimap.frameUpdatePartialTicks = partial;
                minimap.updateZoom();
                Minimap.zoom = minimap.getZoom();
                RenderHelper.func_74518_a();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float sizeFix = (float)bufferSize / 512.0f;
                if (Minimap.usingFBO()) {
                    minimap.renderFrameToFBO(bufferSize, mapW, sizeFix, partial);
                    Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
                    Minimap.rotationFrameBuffer.func_147612_c();
                    sizeFix = 1.0f;
                } else {
                    minimap.updateMapFrame(bufferSize, partial);
                    GL11.glScalef((float)sizeFix, (float)sizeFix, (float)1.0f);
                    Minimap.bindTextureBuffer(Minimap.mapTexture.getBuffer(bufferSize), bufferSize, bufferSize, Minimap.mapTexture.func_110552_b());
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(BetterPvP.getSettings().minimapOpacity / 100.0f));
                }
                GL11.glEnable((int)3008);
                GlStateManager.func_179147_l();
                GL11.glScalef((float)(1.0f / mapScale), (float)(1.0f / mapScale), (float)1.0f);
                int scaledX = (int)((float)this.x * mapScale);
                int scaledY = (int)((float)this.y * mapScale);
                InterfaceHandler.mc.field_71456_v.func_73729_b((int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 0, (int)((float)(mapW / 2 + 1) / sizeFix), (int)((float)(mapH / 2 + 1) / sizeFix));
                if (!Minimap.usingFBO()) {
                    GL11.glScalef((float)(1.0f / sizeFix), (float)(1.0f / sizeFix), (float)1.0f);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                mc.func_110434_K().func_110577_a(guiTextures);
                if (BetterPvP.getSettings().getLockNorth()) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
                    int arrowRotation = (int)Math.round(12.0 * Minimap.getActualAngle() / 180.0) % 24;
                    if (arrowRotation < 0) {
                        arrowRotation += 24;
                    }
                    InterfaceHandler.mc.field_71456_v.func_73729_b(2 * scaledX + 18 + (mapW + 1) / 2 - 15, 2 * scaledY + 18 + (mapH + 1) / 2 - 15, 49 + 31 * (arrowRotation % 4), 31 * (arrowRotation / 4), 31, 31);
                    GL11.glPopMatrix();
                }
                InterfaceHandler.mc.field_71456_v.func_73729_b(scaledX + 9 - 4, scaledY + 9 - 4, 0, 0, 17, 15);
                InterfaceHandler.mc.field_71456_v.func_73729_b(scaledX + 9 - 4 + mapW / 2 - 8, scaledY + 9 - 4, 0, 15, 17, 15);
                InterfaceHandler.mc.field_71456_v.func_73729_b(scaledX + 9 - 4, scaledY + 9 - 4 + mapH / 2 - 6, 0, 30, 17, 15);
                InterfaceHandler.mc.field_71456_v.func_73729_b(scaledX + 9 - 4 + mapW / 2 - 8, scaledY + 9 - 4 + mapH / 2 - 6, 0, 45, 17, 15);
                int horLineLength = (mapW / 2 - 16) / 16;
                for (int i = 0; i < horLineLength; ++i) {
                    InterfaceHandler.mc.field_71456_v.func_73729_b(scaledX + 9 - 4 + 17 + i * 16, scaledY + 9 - 4, 0, 60, 16, 4);
                    InterfaceHandler.mc.field_71456_v.func_73729_b(scaledX + 9 - 4 + 17 + i * 16, scaledY + 9 - 4 + mapH / 2 + 9 - 4, 0, 64, 16, 4);
                }
                int vertLineLength = (mapH / 2 - 14) / 5;
                for (int i = 0; i < vertLineLength; ++i) {
                    InterfaceHandler.mc.field_71456_v.func_73729_b(scaledX + 9 - 4, scaledY + 9 - 4 + 15 + i * 5, 0, 68, 4, 5);
                    InterfaceHandler.mc.field_71456_v.func_73729_b(scaledX + 9 - 4 + mapW / 2 + 9 - 4, scaledY + 9 - 4 + 15 + i * 5, 0, 73, 4, 5);
                }
                double angle = Math.toRadians(Minimap.getRenderAngle());
                double ps = Math.sin(Math.PI - angle);
                double pc = Math.cos(Math.PI - angle);
                int specH = specW = mapW / 2 + 6;
                GL11.glPushMatrix();
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
                GlStateManager.func_179109_b((float)(2 * scaledX + specW - 6 + 18), (float)(2 * scaledY + specH - 6 + 18), (float)0.0f);
                String[] nesw = new String[]{"N", "E", "S", "W"};
                for (int i = 0; i < 4; ++i) {
                    double offx;
                    double d = i == 0 || i == 2 ? 0.0 : (offx = (double)(i == 1 ? 10000 : -10000));
                    double offy = i == 1 || i == 3 ? 0.0 : (double)(i == 2 ? 10000 : -10000);
                    this.drawWaypoint(specW, specH, ps, pc, offx, offy, null, nesw[i]);
                }
                if (BetterPvP.settings.getShowWaypoints() && Minimap.waypoints != null) {
                    double playerX = Minimap.getEntityX((Entity)InterfaceHandler.mc.field_71439_g, partial);
                    double playerZ = Minimap.getEntityZ((Entity)InterfaceHandler.mc.field_71439_g, partial);
                    for (Waypoint w : Minimap.waypoints) {
                        if (w == null || w.disabled || w.type == 1 && !BetterPvP.getSettings().getDeathpoints()) continue;
                        double offx = (double)w.x - playerX;
                        double offy = (double)w.z - playerZ;
                        this.drawWaypoint(specW, specH, ps, pc, offx, offy, w, null);
                    }
                }
                GL11.glPopMatrix();
                if (BetterPvP.settings.getShowCoords()) {
                    int interfaceSize = this.getSize() / 2;
                    int scaledHeight = (int)((float)height * mapScale);
                    String coords = Minimap.myFloor(InterfaceHandler.mc.field_71439_g.field_70165_t) + ", " + Minimap.myFloor(InterfaceHandler.mc.field_71439_g.field_70163_u) + ", " + Minimap.myFloor(InterfaceHandler.mc.field_71439_g.field_70161_v);
                    int stringWidth = InterfaceHandler.mc.field_71466_p.func_78256_a(coords);
                    int stringY = scaledY + (scaledY + interfaceSize / 2 < scaledHeight / 2 ? interfaceSize + 1 : -9);
                    int stringY2 = stringY + (scaledY + interfaceSize < scaledHeight / 2 ? 9 : -9);
                    if (stringWidth >= interfaceSize) {
                        String stringLevel = "" + Minimap.myFloor(InterfaceHandler.mc.field_71439_g.field_70163_u);
                        Minecraft.func_71410_x().field_71466_p.func_175063_a(stringLevel, (float)(scaledX + interfaceSize / 2 - InterfaceHandler.mc.field_71466_p.func_78256_a(stringLevel) / 2), (float)stringY2, Minimap.radarPlayers.hashCode());
                        coords = Minimap.myFloor(InterfaceHandler.mc.field_71439_g.field_70165_t) + ", " + Minimap.myFloor(InterfaceHandler.mc.field_71439_g.field_70161_v);
                        stringWidth = InterfaceHandler.mc.field_71466_p.func_78256_a(coords);
                    }
                    Minecraft.func_71410_x().field_71466_p.func_175063_a(coords, (float)(scaledX + interfaceSize / 2 - stringWidth / 2), (float)stringY, Minimap.radarPlayers.hashCode());
                }
                GL11.glScalef((float)mapScale, (float)mapScale, (float)1.0f);
                GL11.glEnable((int)3008);
                GlStateManager.func_179147_l();
                super.drawInterface(width, height, scale, partial);
            }
        });
    }

    public static void drawCenteredArmour(int x, int y, int w, int h, int width, int height) {
        String str;
        boolean enchanted;
        ItemStack stack;
        int slot;
        String drawEnchants = null;
        for (slot = 2; slot < 4; ++slot) {
            stack = InterfaceHandler.mc.field_71439_g.field_71071_by.field_70460_b[slot];
            if (stack == null) continue;
            enchanted = stack.func_77948_v();
            drawEnchants = InterfaceHandler.drawEnchants(enchanted ? stack.func_77986_q() : null);
            str = InterfaceHandler.getDamageString(stack);
            if (!BetterPvP.getSettings().getShowEnchants()) {
                drawEnchants = null;
            }
            InterfaceHandler.drawItemWithName(stack, str, drawEnchants, x + w / 2 - 91 - 3, y + 3 + 19 - 19 * (slot - 2), true, stack.func_77958_k() - stack.func_77952_i() <= 10);
        }
        for (slot = 0; slot < 2; ++slot) {
            stack = InterfaceHandler.mc.field_71439_g.field_71071_by.field_70460_b[slot];
            if (stack == null) continue;
            enchanted = stack.func_77948_v();
            drawEnchants = InterfaceHandler.drawEnchants(enchanted ? stack.func_77986_q() : null);
            str = InterfaceHandler.getDamageString(stack);
            if (!BetterPvP.getSettings().getShowEnchants()) {
                drawEnchants = null;
            }
            InterfaceHandler.drawItemWithName(stack, str, drawEnchants, x + w / 2 + 91 + 3, y + 3 + 19 - 19 * slot, false, stack.func_77958_k() - stack.func_77952_i() <= 10);
        }
        if (InterfaceHandler.mc.field_71439_g.field_71071_by.func_70448_g() != null) {
            ItemStack stack2;
            boolean enchanted2 = InterfaceHandler.mc.field_71439_g.field_71071_by.func_70448_g().func_77948_v();
            drawEnchants = InterfaceHandler.drawEnchants(enchanted2 ? InterfaceHandler.mc.field_71439_g.field_71071_by.func_70448_g().func_77986_q() : null);
            String str2 = InterfaceHandler.getDamageString(InterfaceHandler.mc.field_71439_g.field_71071_by.func_70448_g());
            int iconY = y > height / 2 ? y - 16 : y + h;
            if (!BetterPvP.getSettings().getShowEnchants()) {
                drawEnchants = null;
            }
            InterfaceHandler.drawItemWithName(stack2, str2, drawEnchants, width - 3, iconY, true, (stack2 = InterfaceHandler.mc.field_71439_g.field_71071_by.func_70448_g()).func_77958_k() - stack2.func_77952_i() <= 10);
            if (BetterPvP.getSettings().getArchery() && InterfaceHandler.hasABow()) {
                ItemStack arrow = new ItemStack(Item.func_150899_d((int)262));
                int arrowY = y > height / 2 ? iconY - 19 : iconY + 19;
                InterfaceHandler.drawItemWithName(arrow, InterfaceHandler.getArrowAmountString(), null, width - 3, arrowY, true, false);
            }
        }
    }

    public static void drawClassicArmour(int x, int y, int w, int h, int width, int height, boolean flipped) {
        ItemStack[] items = new ItemStack[5];
        String drawEnchants = null;
        boolean itemUp = y > height / 2;
        items[0] = itemUp ? InterfaceHandler.mc.field_71439_g.field_71071_by.func_70448_g() : InterfaceHandler.mc.field_71439_g.field_71071_by.field_70460_b[3];
        items[1] = InterfaceHandler.mc.field_71439_g.field_71071_by.field_70460_b[itemUp ? 3 : 2];
        items[2] = InterfaceHandler.mc.field_71439_g.field_71071_by.field_70460_b[itemUp ? 2 : 1];
        items[3] = InterfaceHandler.mc.field_71439_g.field_71071_by.field_70460_b[itemUp ? 1 : 0];
        items[4] = itemUp ? InterfaceHandler.mc.field_71439_g.field_71071_by.field_70460_b[0] : InterfaceHandler.mc.field_71439_g.field_71071_by.func_70448_g();
        boolean flip = x < width / 2 && flipped || !flipped && x >= width / 2;
        int iconX = x + (flip ? w - 3 : 3);
        for (int i = 0; i < items.length; ++i) {
            ItemStack stack = items[i];
            if (stack == null) continue;
            boolean enchanted = stack.func_77948_v();
            drawEnchants = InterfaceHandler.drawEnchants(enchanted ? stack.func_77986_q() : null);
            String str = InterfaceHandler.getDamageString(stack);
            if (!BetterPvP.getSettings().getShowEnchants()) {
                drawEnchants = null;
            }
            InterfaceHandler.drawItemWithName(stack, str, drawEnchants, iconX, y + 3 + 19 * i, flip, stack.func_77958_k() - stack.func_77952_i() <= 10);
        }
        if (BetterPvP.getSettings().getArchery() && InterfaceHandler.hasABow()) {
            ItemStack arrow = new ItemStack(Item.func_150899_d((int)262));
            int arrowY = itemUp ? y - 16 : y + h;
            InterfaceHandler.drawItemWithName(arrow, InterfaceHandler.getArrowAmountString(), null, iconX, arrowY, flip, false);
        }
    }

    public static void drawItemWithName(ItemStack stack, String name, String name1, int x, int y, boolean flipped, boolean flash) {
        int iconX = x - (flipped ? 16 : 0);
        int iconY = y;
        int stringX = iconX + (flipped ? -3 - InterfaceHandler.mc.field_71466_p.func_78256_a(name) : 19);
        int stringY = iconY;
        int enchantX = iconX + (flipped ? -3 - InterfaceHandler.mc.field_71466_p.func_78256_a(name1) : 19);
        int enchantY = iconY + 9;
        InterfaceHandler.mc.field_71466_p.func_175063_a(name, (float)stringX, (float)stringY, 0xFFFFFF);
        if (name1 != null) {
            InterfaceHandler.mc.field_71466_p.func_175063_a(name1, (float)enchantX, (float)enchantY, 0xFFFFFF);
        }
        RenderHelper.func_74520_c();
        InterfaceHandler.itemRenderer.field_77023_b -= 1000.0f;
        itemRenderer.func_180450_b(stack, iconX, iconY);
        InterfaceHandler.itemRenderer.field_77023_b += 1000.0f;
        String size = "" + stack.field_77994_a;
        if (stack.field_77994_a <= 1) {
            size = "";
        }
        itemRenderer.func_180453_a(InterfaceHandler.mc.field_71466_p, stack, iconX, iconY, size);
        RenderHelper.func_74518_a();
    }

    public static boolean tntIsAround() {
        for (int i = 0; i < InterfaceHandler.mc.field_71439_g.field_70170_p.field_72996_f.size(); ++i) {
            if (!(InterfaceHandler.mc.field_71439_g.field_70170_p.field_72996_f.get(i) instanceof EntityTNTPrimed) && (!(InterfaceHandler.mc.field_71439_g.field_70170_p.field_72996_f.get(i) instanceof EntityCreeper) || ((EntityCreeper)InterfaceHandler.mc.field_71439_g.field_70170_p.field_72996_f.get(i)).func_70832_p() != 1)) continue;
            Entity e = (Entity)InterfaceHandler.mc.field_71439_g.field_70170_p.field_72996_f.get(i);
            if (!(e.field_70165_t - InterfaceHandler.mc.field_71439_g.field_70165_t < 5.0) || !(e.field_70165_t - InterfaceHandler.mc.field_71439_g.field_70165_t > -5.0) || !(e.field_70163_u - InterfaceHandler.mc.field_71439_g.field_70163_u < 5.0) || !(e.field_70163_u - InterfaceHandler.mc.field_71439_g.field_70163_u > -5.0) || !(e.field_70161_v - InterfaceHandler.mc.field_71439_g.field_70161_v < 5.0) || !(e.field_70161_v - InterfaceHandler.mc.field_71439_g.field_70161_v > -5.0)) continue;
            return true;
        }
        return false;
    }

    public static boolean arrowIsAround() {
        if (System.currentTimeMillis() - arrowWas < 5000L) {
            return true;
        }
        for (int i = 0; i < InterfaceHandler.mc.field_71439_g.field_70170_p.field_72996_f.size(); ++i) {
            Entity e = (Entity)InterfaceHandler.mc.field_71439_g.field_70170_p.field_72996_f.get(i);
            if (!(e instanceof EntityArrow) || e.field_70142_S == e.field_70165_t && e.field_70137_T == e.field_70163_u && e.field_70136_U == e.field_70161_v || ((EntityArrow)e).field_70250_c == InterfaceHandler.mc.field_71439_g || !(e.field_70165_t - InterfaceHandler.mc.field_71439_g.field_70165_t < 5.0) || !(e.field_70165_t - InterfaceHandler.mc.field_71439_g.field_70165_t > -5.0) || !(e.field_70163_u - InterfaceHandler.mc.field_71439_g.field_70163_u < 5.0) || !(e.field_70163_u - InterfaceHandler.mc.field_71439_g.field_70163_u > -5.0) || !(e.field_70161_v - InterfaceHandler.mc.field_71439_g.field_70161_v < 5.0) || !(e.field_70161_v - InterfaceHandler.mc.field_71439_g.field_70161_v > -5.0)) continue;
            arrowWas = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public static String getArrowAmountString() {
        String toReturn = null;
        int arrows = 0;
        for (int i = 0; i < InterfaceHandler.mc.field_71439_g.field_71071_by.field_70462_a.length; ++i) {
            ItemStack stack = InterfaceHandler.mc.field_71439_g.field_71071_by.field_70462_a[i];
            if (stack == null || stack.func_77973_b() != Item.func_150899_d((int)262)) continue;
            arrows += stack.field_77994_a;
        }
        toReturn = arrows + "";
        return toReturn;
    }

    public static boolean hasABow() {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = InterfaceHandler.mc.field_71439_g.field_71071_by.field_70462_a[i];
            if (stack == null || !(stack.func_77973_b() instanceof ItemBow)) continue;
            return true;
        }
        return false;
    }

    public static void drawInterfaces(float partial) {
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
        int width = scaledresolution.func_78326_a();
        int height = scaledresolution.func_78328_b();
        int scale = scaledresolution.func_78325_e();
        int mouseX = Mouse.getX() * width / Minecraft.func_71410_x().field_71443_c;
        int mouseY = height - Mouse.getY() * height / Minecraft.func_71410_x().field_71440_d - 1;
        InterfaceHandler.updateInterfaces(mouseX, mouseY, width, height, scale);
        for (Interface l : list) {
            if (!BetterPvP.settings.getBooleanValue(l.option)) continue;
            l.drawInterface(width, height, scale, partial);
        }
    }

    public static boolean overAButton(int mouseX, int mouseY) {
        if (InterfaceHandler.mc.field_71462_r instanceof GuiEditMode) {
            for (int k = 0; k < ((GuiEditMode)InterfaceHandler.mc.field_71462_r).getButtons().size(); ++k) {
                GuiButton b = (GuiButton)((GuiEditMode)InterfaceHandler.mc.field_71462_r).getButtons().get(k);
                if (mouseX < b.field_146128_h || mouseY < b.field_146129_i || mouseX >= b.field_146128_h + 150 || mouseY >= b.field_146129_i + 20) continue;
                return true;
            }
        }
        return false;
    }

    public static void confirm() {
        for (Interface l : list) {
            l.bx = l.actualx;
            l.by = l.actualy;
            l.bcentered = l.centered;
            l.bflipped = l.flipped;
            l.bfromRight = l.fromRight;
        }
    }

    public static void cancel() {
        for (Interface l : list) {
            l.actualx = l.bx;
            l.actualy = l.by;
            l.centered = l.bcentered;
            l.flipped = l.bflipped;
            l.fromRight = l.bfromRight;
        }
    }

    public static void applyPreset(int id) {
        for (Interface l : list) {
            actionTimer = 10;
            l.actualx = InterfaceHandler.presets.get((int)id).coords[l.id][0];
            l.actualy = InterfaceHandler.presets.get((int)id).coords[l.id][1];
            l.centered = InterfaceHandler.presets.get((int)id).types[l.id][0];
            l.flipped = l.cflipped;
            l.fromRight = InterfaceHandler.presets.get((int)id).types[l.id][1];
        }
    }

    public static void displayDebuffEffects(int width, int height) {
        block21: {
            Collection var4;
            int var1 = InterfaceHandler.list.get((int)0).x;
            int var2 = InterfaceHandler.list.get((int)0).y;
            int w = InterfaceHandler.list.get((int)0).w;
            int h = InterfaceHandler.list.get((int)0).h;
            boolean flipped = InterfaceHandler.list.get((int)0).flipped;
            if (flipped) {
                var2 = var2 + h - 30;
            }
            if ((var4 = InterfaceHandler.mc.field_71439_g.func_70651_bq()).isEmpty()) break block21;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            if (!InterfaceHandler.list.get((int)0).centered) {
                int var5 = 25;
                if (var4.size() > 6) {
                    var5 = 135 / (var4.size() - 1);
                }
                for (PotionEffect var7 : InterfaceHandler.mc.field_71439_g.func_70651_bq()) {
                    int duration = var7.func_76459_b();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (duration <= 200 && !blinking) {
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
                    }
                    Potion var8 = Potion.field_76425_a[var7.func_76456_a()];
                    mc.func_110434_K().func_110577_a(invtextures);
                    if (var8.func_76400_d()) {
                        int var9 = var8.func_76392_e();
                        if (!flipped) {
                            InterfaceHandler.mc.field_71456_v.func_73729_b(var1 > width / 2 ? var1 + w - 24 : var1 + 6, var2 + 7, 0 + var9 % 8 * 18, 198 + var9 / 8 * 18, 18, 18);
                        } else {
                            InterfaceHandler.mc.field_71456_v.func_73729_b(var1 <= width / 2 ? var1 + w - 24 : var1 + 6, var2 + 7, 0 + var9 % 8 * 18, 198 + var9 / 8 * 18, 18, 18);
                        }
                    }
                    String potionName = I18n.func_135052_a((String)var8.func_76393_a(), (Object[])new Object[0]);
                    if (var7.func_76458_c() == 1) {
                        potionName = potionName + " II";
                    } else if (var7.func_76458_c() == 2) {
                        potionName = potionName + " III";
                    } else if (var7.func_76458_c() == 3) {
                        potionName = potionName + " IV";
                    }
                    String durationString = Potion.func_76389_a((PotionEffect)var7);
                    if (!BetterPvP.getSettings().getShowEffectNames()) {
                        potionName = durationString;
                        durationString = "";
                    }
                    if (!flipped) {
                        InterfaceHandler.mc.field_71466_p.func_175063_a(potionName, var1 > width / 2 ? (float)(var1 + w - 28 - InterfaceHandler.mc.field_71466_p.func_78256_a(potionName)) : (float)(var1 + 10 + 18), (float)(var2 + 6), 0xFFFFFF);
                        InterfaceHandler.mc.field_71466_p.func_175063_a(durationString, var1 > width / 2 ? (float)(var1 + w - 28 - InterfaceHandler.mc.field_71466_p.func_78256_a(durationString)) : (float)(var1 + 10 + 18), (float)(var2 + 6 + 10), 0xFFFFFF);
                    } else {
                        InterfaceHandler.mc.field_71466_p.func_175063_a(potionName, var1 <= width / 2 ? (float)(var1 + w - 28 - InterfaceHandler.mc.field_71466_p.func_78256_a(potionName)) : (float)(var1 + 10 + 18), (float)(var2 + 6), 0xFFFFFF);
                        InterfaceHandler.mc.field_71466_p.func_175063_a(durationString, var1 <= width / 2 ? (float)(var1 + w - 28 - InterfaceHandler.mc.field_71466_p.func_78256_a(durationString)) : (float)(var1 + 10 + 18), (float)(var2 + 6 + 10), 0xFFFFFF);
                    }
                    var2 += flipped ? -var5 : var5;
                }
            } else {
                int var5 = 26;
                if (var4.size() > 7) {
                    var5 = 182 / var4.size();
                }
                int totalSize = var4.size() * var5;
                int currentX = var1 + w / 2 - totalSize / 2 + (var5 - 18) / 2;
                int currentY = InterfaceHandler.list.get((int)0).y + 7;
                for (PotionEffect var7 : InterfaceHandler.mc.field_71439_g.func_70651_bq()) {
                    int duration = var7.func_76459_b();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (duration <= 200 && !blinking) {
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
                    }
                    Potion var8 = Potion.field_76425_a[var7.func_76456_a()];
                    mc.func_110434_K().func_110577_a(invtextures);
                    if (var8.func_76400_d()) {
                        int var9 = var8.func_76392_e();
                        InterfaceHandler.mc.field_71456_v.func_73729_b(currentX, currentY, 0 + var9 % 8 * 18, 198 + var9 / 8 * 18, 18, 18);
                    }
                    String var10 = Potion.func_76389_a((PotionEffect)var7);
                    InterfaceHandler.mc.field_71466_p.func_175063_a(var10, (float)(currentX + 10 - InterfaceHandler.mc.field_71466_p.func_78256_a(var10) / 2), (float)(currentY + 15), 0xFFFFFF);
                    currentX += var5;
                }
            }
        }
    }

    public static String getDamageString(ItemStack stack) {
        String toReturn = stack.func_77973_b().func_77653_i(stack);
        try {
            if (((ItemFood)stack.func_77973_b()).func_150905_g(stack) > 0) {
                return I18n.func_135052_a((String)"gui.xaero_restores", (Object[])new Object[0]) + " " + (double)((ItemFood)stack.func_77973_b()).func_150905_g(stack) / 2.0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stack.func_77958_k() == 0) {
            return toReturn;
        }
        int percent = (stack.func_77958_k() - stack.func_77952_i()) * 100 / stack.func_77958_k();
        if (BetterPvP.getSettings().durability == 0) {
            toReturn = percent + "%";
        } else if (BetterPvP.getSettings().durability == 1) {
            toReturn = stack.func_77958_k() - stack.func_77952_i() + 1 + "/" + (stack.func_77958_k() + 1);
        } else if (BetterPvP.getSettings().durability == 2) {
            toReturn = stack.func_77958_k() - stack.func_77952_i() + 1 + "/" + (stack.func_77958_k() + 1) + " (" + percent + "%)";
        }
        if (percent <= 5) {
            toReturn = "\u00a7d" + toReturn;
        } else if (percent <= 25) {
            toReturn = "\u00a7c" + toReturn;
        } else if (percent <= 50) {
            toReturn = "\u00a76" + toReturn;
        } else if (percent <= 75) {
            toReturn = "\u00a7e" + toReturn;
        }
        return toReturn;
    }

    private static String drawEnchants(NBTTagList etl) {
        if (etl == null) {
            return null;
        }
        String s = "";
        int count = etl.func_74745_c();
        for (int i = 0; i < count; ++i) {
            short short1 = etl.func_150305_b(i).func_74765_d("id");
            short short2 = etl.func_150305_b(i).func_74765_d("lvl");
            String e = "";
            if (Enchantment.func_180306_c((int)short1) != null) {
                e = Enchantment.func_180306_c((int)short1).func_77316_c((int)short2);
            }
            e = InterfaceHandler.translateEchant(e, count, s.length() + e.length());
            s = s + e + ", ";
        }
        if (s.length() >= 2) {
            s = s.substring(0, s.length() - 2);
        }
        return "\u00a7" + ModSettings.ENCHANT_COLORS[BetterPvP.getSettings().enchantColor] + s;
    }

    private static String translateEchant(String s, int count, int length) {
        if (count <= 1) {
            return s;
        }
        String[] words = s.split(" ");
        s = "";
        for (int i = 0; i < words.length; ++i) {
            String s1 = words[i];
            s = s + (i == words.length - 1 ? " " + s1 : s1.substring(0, 1).toUpperCase());
        }
        return s;
    }

    public static void updateInterfaces(int mouseX, int mouseY, int width, int height, int scale) {
        if (actionTimer <= 0) {
            if (System.currentTimeMillis() - lastBlink >= 500L) {
                lastBlink = System.currentTimeMillis();
                boolean bl = blinking = !blinking;
            }
            if (BetterPvP.events.lastGuiOpen instanceof GuiEditMode) {
                int i;
                if (Mouse.isButtonDown((int)1)) {
                    selectedId = -1;
                }
                if ((i = InterfaceHandler.getInterfaceId(mouseX, mouseY, width, height, scale)) == -1) {
                    i = selectedId;
                }
                if (i != -1) {
                    if (Mouse.isButtonDown((int)0) && draggingId == -1) {
                        draggingId = i;
                        selectedId = i;
                        if (InterfaceHandler.list.get((int)i).fromRight) {
                            InterfaceHandler.list.get((int)i).x = width - InterfaceHandler.list.get((int)i).x;
                        }
                        draggingOffX = InterfaceHandler.list.get((int)i).x - mouseX;
                        draggingOffY = InterfaceHandler.list.get((int)i).y - mouseY;
                        if (InterfaceHandler.list.get((int)i).fromRight) {
                            InterfaceHandler.list.get((int)i).x = width - InterfaceHandler.list.get((int)i).x;
                        }
                    } else if (!Mouse.isButtonDown((int)0) && draggingId != -1) {
                        draggingId = -1;
                        draggingOffX = 0;
                        draggingOffY = 0;
                    }
                    if (selectedId != -1) {
                        i = selectedId;
                    }
                    if (Keyboard.isKeyDown((int)33) && System.currentTimeMillis() - lastFlip > 300L) {
                        lastFlip = System.currentTimeMillis();
                        boolean bl = InterfaceHandler.list.get((int)i).flipped = !InterfaceHandler.list.get((int)i).flipped;
                    }
                    if (Keyboard.isKeyDown((int)46) && System.currentTimeMillis() - lastFlip > 300L) {
                        lastFlip = System.currentTimeMillis();
                        boolean bl = InterfaceHandler.list.get((int)i).centered = !InterfaceHandler.list.get((int)i).centered;
                    }
                    if (Keyboard.isKeyDown((int)31)) {
                        selectedId = -1;
                        draggingId = -1;
                        switch (i) {
                            case 1: {
                                InterfaceHandler.mc.field_71462_r.field_146297_k.func_147108_a((GuiScreen)new GuiArmour(InterfaceHandler.mc.field_71462_r, BetterPvP.getSettings()));
                                break;
                            }
                            case 3: {
                                InterfaceHandler.mc.field_71462_r.field_146297_k.func_147108_a((GuiScreen)new GuiNotifications(InterfaceHandler.mc.field_71462_r, BetterPvP.getSettings()));
                                break;
                            }
                            case 4: {
                                InterfaceHandler.mc.field_71462_r.field_146297_k.func_147108_a((GuiScreen)new GuiMinimap(InterfaceHandler.mc.field_71462_r, BetterPvP.getSettings()));
                            }
                        }
                    }
                }
                if (draggingId != -1) {
                    if (!InterfaceHandler.list.get((int)InterfaceHandler.draggingId).centered) {
                        InterfaceHandler.list.get((int)InterfaceHandler.draggingId).actualx = mouseX + draggingOffX;
                        if (InterfaceHandler.list.get((int)InterfaceHandler.draggingId).fromRight) {
                            InterfaceHandler.list.get((int)InterfaceHandler.draggingId).actualx = width - InterfaceHandler.list.get((int)InterfaceHandler.draggingId).actualx;
                        }
                    }
                    if (InterfaceHandler.list.get((int)InterfaceHandler.draggingId).actualx > width / 2) {
                        InterfaceHandler.list.get((int)InterfaceHandler.draggingId).fromRight = !InterfaceHandler.list.get((int)InterfaceHandler.draggingId).fromRight;
                        InterfaceHandler.list.get((int)InterfaceHandler.draggingId).actualx = width - InterfaceHandler.list.get((int)InterfaceHandler.draggingId).actualx;
                    }
                    InterfaceHandler.list.get((int)InterfaceHandler.draggingId).actualy = mouseY + draggingOffY;
                }
            }
        } else {
            --actionTimer;
        }
        for (Interface j : list) {
            j.x = j.actualx;
            j.y = j.actualy;
            if (j.fromRight) {
                j.x = width - j.x;
            }
            if (j.centered) {
                if (j.multi) {
                    j.w = j.getWC(scale);
                    j.h = j.getHC(scale);
                }
                j.x = width / 2 - j.getW(scale) / 2;
            } else if (j.multi) {
                j.w = j.getW0(scale);
                j.h = j.getH0(scale);
            }
            if (j.x < 5) {
                j.x = 0;
            }
            if (j.y < 5) {
                j.y = 0;
            }
            if (j.x + j.getW(scale) > width - 5) {
                j.x = width - j.getW(scale);
            }
            if (j.y + j.getH(scale) <= height - 5) continue;
            j.y = height - j.getH(scale);
        }
    }

    public static void drawBoxes(int mouseX, int mouseY, int width, int height, int scale) {
        if (BetterPvP.events.lastGuiOpen instanceof GuiEditMode) {
            int mouseOverId = InterfaceHandler.getInterfaceId(mouseX, mouseY, width, height, scale);
            for (int i = 0; i < list.size(); ++i) {
                if (!BetterPvP.settings.getBooleanValue(InterfaceHandler.list.get((int)i).option)) continue;
                int x = InterfaceHandler.list.get((int)i).x;
                if (InterfaceHandler.list.get((int)i).fromRight) {
                    x = width - x;
                }
                int y = InterfaceHandler.list.get((int)i).y;
                int w = list.get(i).getW(scale);
                int h = list.get(i).getH(scale);
                int x2 = x + w;
                int y2 = y + h;
                if (selectedId == i || !InterfaceHandler.overAButton(mouseX, mouseY) && mouseX >= x && mouseX <= x2 && mouseY >= y && mouseY <= y2 || i == draggingId) {
                    Gui.func_73734_a((int)x, (int)y, (int)x2, (int)y2, (int)(selectedId == i ? selected.hashCode() : enabled.hashCode()));
                    if (draggingId != -1 || i != mouseOverId) continue;
                    InterfaceHandler.list.get((int)i).cBox.drawBox(mouseX, mouseY, width, height);
                    continue;
                }
                Gui.func_73734_a((int)x, (int)y, (int)x2, (int)y2, (int)disabled.hashCode());
            }
        }
    }

    public static int getInterfaceId(int mouseX, int mouseY, int width, int height, int scale) {
        int toReturn = -1;
        int size = 0;
        for (int i = 0; i < list.size(); ++i) {
            int x = InterfaceHandler.list.get((int)i).x;
            if (InterfaceHandler.list.get((int)i).fromRight) {
                x = width - x;
            }
            int y = InterfaceHandler.list.get((int)i).y;
            int x2 = x + list.get(i).getW(scale);
            int y2 = y + list.get(i).getH(scale);
            int isize = list.get(i).getSize();
            if (size != 0 && isize >= size || InterfaceHandler.overAButton(mouseX, mouseY) || mouseX < x || mouseX >= x2 || mouseY < y || mouseY >= y2) continue;
            size = isize;
            toReturn = i;
        }
        return toReturn;
    }

    static {
        guiTextures = new ResourceLocation("xaerobetterpvp", "gui/guis.png");
        mapTextures = new ResourceLocation("xaeromaptexture");
        arrowWas = 0L;
        blinking = true;
        lastBlink = 0L;
        lastFlip = 0L;
        disabled = new Color(189, 189, 189, 80);
        enabled = new Color(255, 255, 255, 100);
        selected = new Color(255, 255, 255, 130);
    }
}

