/*
 * Decompiled with CFR 0.152.
 */
package com.pvp.minimap;

import com.pvp.BetterPvP;
import com.pvp.interfaces.InterfaceHandler;
import com.pvp.minimap.Minimap;
import com.pvp.settings.ModSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.resources.I18n;

public class Waypoint {
    public int x;
    public int y;
    public int z;
    public String name;
    public String symbol;
    public int color;
    public boolean disabled = false;
    public int type = 0;

    public Waypoint(int x, int y, int z, String name, String symbol, int color) {
        this(x, y, z, name, symbol, color, 0);
    }

    public Waypoint(int x, int y, int z, String name, String symbol, int color, int type) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.symbol = symbol;
        this.color = color;
        this.type = type;
        this.name = name;
    }

    public double getDistanceSq(double x, double y, double z) {
        double d3 = (double)this.x - x;
        double d4 = (double)this.y - y;
        double d5 = (double)this.z - z;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public String getName() {
        return I18n.func_135052_a((String)this.name, (Object[])new Object[0]);
    }

    public void drawIconInWorld(WorldRenderer worldrenderer, Tessellator tessellator, FontRenderer fontrenderer, String text, float textSize, boolean background, boolean showDistance) {
        GlStateManager.func_179152_a((float)BetterPvP.getSettings().waypointsScale, (float)BetterPvP.getSettings().waypointsScale, (float)1.0f);
        if (this.type == 0) {
            int c = ModSettings.COLORS[this.color];
            int l = c >> 16 & 0xFF;
            int i1 = c >> 8 & 0xFF;
            int j1 = c & 0xFF;
            GlStateManager.func_179090_x();
            int s = fontrenderer.func_78256_a(this.symbol) / 2;
            worldrenderer.func_178970_b();
            worldrenderer.func_178961_b(l, i1, j1, 120);
            worldrenderer.func_178984_b(-5.0, -9.0, 0.0);
            worldrenderer.func_178984_b(-5.0, 0.0, 0.0);
            worldrenderer.func_178984_b(4.0, 0.0, 0.0);
            worldrenderer.func_178984_b(4.0, -9.0, 0.0);
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
            fontrenderer.func_78276_b(this.symbol, -s, -8, 0x20FFFFFF);
            fontrenderer.func_78276_b(this.symbol, -s, -8, -1);
            GlStateManager.func_179152_a((float)(textSize / 2.0f), (float)(textSize / 2.0f), (float)1.0f);
            int t = fontrenderer.func_78256_a(text) / 2;
            if (background) {
                GlStateManager.func_179090_x();
                worldrenderer.func_178970_b();
                worldrenderer.func_178961_b(0, 0, 0, 70);
                worldrenderer.func_178984_b((double)(-t) - 1.0, 1.0, 0.0);
                worldrenderer.func_178984_b((double)(-t) - 1.0, 11.0, 0.0);
                worldrenderer.func_178984_b((double)t + 1.0, 11.0, 0.0);
                worldrenderer.func_178984_b((double)t + 1.0, 1.0, 0.0);
                tessellator.func_78381_a();
                GlStateManager.func_179098_w();
            }
            fontrenderer.func_78276_b(text, -t, 2, 0x20FFFFFF);
            fontrenderer.func_78276_b(text, -t, 2, -1);
        } else if (this.type == 1) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(InterfaceHandler.guiTextures);
            float f = 0.00390625f;
            float f1 = 0.00390625f;
            worldrenderer.func_178970_b();
            worldrenderer.func_178961_b(256, 256, 256, 200);
            worldrenderer.func_178985_a(-5.0, -9.0, 0.0, 0.0, (double)(78.0f * f1));
            worldrenderer.func_178985_a(-5.0, 0.0, 0.0, 0.0, (double)(87.0f * f1));
            worldrenderer.func_178985_a(4.0, 0.0, 0.0, (double)(9.0f * f), (double)(87.0f * f1));
            worldrenderer.func_178985_a(4.0, -9.0, 0.0, (double)(9.0f * f), (double)(78.0f * f1));
            tessellator.func_78381_a();
            if (!showDistance) {
                text = this.getName();
                textSize = 1.0f;
            }
            GlStateManager.func_179152_a((float)(textSize / 2.0f), (float)(textSize / 2.0f), (float)1.0f);
            int t = fontrenderer.func_78256_a(text) / 2;
            if (background) {
                GlStateManager.func_179090_x();
                worldrenderer.func_178970_b();
                worldrenderer.func_178961_b(0, 0, 0, 70);
                worldrenderer.func_178984_b((double)(-t) - 1.0, 1.0, 0.0);
                worldrenderer.func_178984_b((double)(-t) - 1.0, 11.0, 0.0);
                worldrenderer.func_178984_b((double)t + 1.0, 11.0, 0.0);
                worldrenderer.func_178984_b((double)t + 1.0, 1.0, 0.0);
                tessellator.func_78381_a();
                GlStateManager.func_179098_w();
            }
            fontrenderer.func_78276_b(text, -t, 2, 0x20FFFFFF);
            fontrenderer.func_78276_b(text, -t, 2, -1);
        }
    }

    public void drawIconOnGUI(int drawX, int drawY) {
        if (this.type == 0) {
            int rectX2 = drawX + 9;
            int rectY2 = drawY + 9;
            Gui.func_73734_a((int)drawX, (int)drawY, (int)rectX2, (int)rectY2, (int)ModSettings.COLORS[this.color]);
            int j = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.symbol) / 2;
            Minecraft.func_71410_x().field_71466_p.func_175063_a(this.symbol, (float)(drawX + 5 - j), (float)(drawY + 1), Minimap.radarPlayers.hashCode());
        } else if (this.type == 1) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(InterfaceHandler.guiTextures);
            Minecraft.func_71410_x().field_71456_v.func_73729_b(drawX, drawY, 0, 78, 9, 9);
        }
    }
}

