/*
 * Decompiled with CFR 0.152.
 */
package com.pvp.settings;

import com.pvp.BetterPvP;
import com.pvp.events.ControlsHandler;
import com.pvp.gui.GuiSlimeSeed;
import com.pvp.interfaces.Interface;
import com.pvp.interfaces.InterfaceHandler;
import com.pvp.minimap.Minimap;
import com.pvp.minimap.Waypoint;
import com.pvp.settings.ModOptions;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;

public class ModSettings {
    public static final int defaultSettings = Integer.MAX_VALUE;
    public static int ignoreUpdate;
    public static final String format = "\u00a7";
    private static boolean keysLoaded;
    public static final String[] ENCHANT_COLORS;
    public static final String[] ENCHANT_COLOR_NAMES;
    public static final int[] COLORS;
    public static final String[] DURABILITY;
    public static final String[] MINIMAP_SIZE;
    public static int serverSettings;
    public static KeyBinding keyBindEat;
    public static KeyBinding keyBindToggleSneak;
    public static KeyBinding keyBindPvP1;
    public static KeyBinding keyBindPvP2;
    public static KeyBinding keyBindPvP3;
    public static KeyBinding keyBindPvP4;
    public static KeyBinding keyBindPvP5;
    public static KeyBinding keyBindPvP6;
    public static KeyBinding keyBindPvP7;
    public static KeyBinding keyBindPvP8;
    public static KeyBinding keyBindPvP9;
    public static KeyBinding keyBindSettings;
    public static KeyBinding keyBindZoom;
    public static KeyBinding keyBindZoom1;
    public static KeyBinding newWaypoint;
    public static KeyBinding keyWaypoints;
    public static KeyBinding keyLargeMap;
    public static KeyBinding keyToggleMap;
    private boolean minimap = true;
    public int zoom = 2;
    public float[] zooms = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
    public int entityAmount = 1;
    private boolean showPlayers = true;
    private boolean showMobs = true;
    private boolean showItems = true;
    private boolean showOther = true;
    private boolean caveMaps = true;
    private boolean showOtherTeam = true;
    private boolean showWaypoints = true;
    private boolean deathpoints = true;
    private boolean oldDeathpoints = true;
    private boolean chunkGrid = false;
    private boolean slimeChunks = false;
    public long serverSlimeSeed = 0L;
    private boolean showIngameWaypoints = true;
    private boolean showCoords = true;
    private boolean lockNorth = false;
    private boolean antiAliasing = true;
    public boolean displayRedstone = true;
    public boolean mapSafeMode = false;
    public int distance = 1;
    public static final String[] distanceTypes;
    public int blockColours = 0;
    public static final String[] blockColourTypes;
    public boolean lighting = true;
    public int mapSize = 2;
    public int playersColor = 15;
    public int mobsColor = 14;
    public int hostileColor = 14;
    public int itemsColor = 12;
    public int otherColor = 5;
    public float minimapOpacity = 100.0f;
    public float waypointsScale = 1.0f;
    private boolean betterSprint = true;
    private boolean betterNumbers = true;
    private boolean showEffects = true;
    private boolean showArmor = true;
    private boolean keepSneak = true;
    private boolean notifications = true;
    public boolean notification_hunger = true;
    public boolean notification_hp = true;
    public boolean notification_tnt = true;
    public boolean notification_arrow = true;
    public boolean notification_air = true;
    private boolean showEnchants = true;
    private boolean xp = true;
    private boolean archery = true;
    private boolean showEffectNames = true;
    public int enchantColor = 7;
    public int durability = 2;
    public int lowHunger = 3;
    public int lowHealth = 2;
    public int lowAir = 3;

    public ModSettings() {
        if (!keysLoaded) {
            BetterPvP.ch = new ControlsHandler();
            keysLoaded = true;
        }
    }

    public static boolean isKeyRepeat(KeyBinding kb) {
        return kb != keyWaypoints && kb != keyBindSettings && kb != newWaypoint && kb != keyLargeMap && kb != keyToggleMap && kb != keyBindToggleSneak;
    }

    public boolean getMinimap() {
        return this.minimap && !this.minimapDisabled();
    }

    public boolean getShowPlayers() {
        return this.showPlayers && !this.minimapDisplayPlayersDisabled();
    }

    public boolean getShowMobs() {
        return this.showMobs && !this.minimapDisplayMobsDisabled();
    }

    public boolean getShowItems() {
        return this.showItems && !this.minimapDisplayItemsDisabled();
    }

    public boolean getShowOther() {
        return this.showOther && !this.minimapDisplayOtherDisabled();
    }

    public boolean getCaveMaps() {
        return this.caveMaps && !this.caveMapsDisabled();
    }

    public boolean getShowOtherTeam() {
        return this.showOtherTeam && !this.showOtherTeamDisabled();
    }

    public boolean getShowWaypoints() {
        return this.showWaypoints && !this.showWaypointsDisabled();
    }

    public boolean getDeathpoints() {
        return this.deathpoints && !this.deathpointsDisabled();
    }

    public boolean getOldDeathpoints() {
        return this.oldDeathpoints;
    }

    public boolean getChunkGrid() {
        return this.chunkGrid;
    }

    public boolean customSlimeSeedNeeded() {
        return !(Minecraft.func_71410_x().field_71462_r instanceof GuiSlimeSeed) && Minecraft.func_71410_x().func_71401_C() == null && Minecraft.func_71410_x().field_71441_e != null;
    }

    public boolean getSlimeChunks() {
        return this.slimeChunks && (this.serverSlimeSeed != -1L || Minecraft.func_71410_x().func_71401_C() != null);
    }

    public boolean getShowIngameWaypoints() {
        return this.showIngameWaypoints && !this.showWaypointsDisabled();
    }

    public boolean getShowCoords() {
        return this.showCoords;
    }

    public boolean getLockNorth() {
        return this.lockNorth;
    }

    public boolean getAntiAliasing() {
        return !Minimap.triedFBO || this.antiAliasing && Minimap.usingFBO();
    }

    public boolean getBetterSprint() {
        return this.betterSprint && !this.betterSprintDisabled();
    }

    public boolean getBetterNumbers() {
        return this.betterNumbers && !this.quickItemsDisabled();
    }

    public boolean getShowEffects() {
        return this.showEffects && !this.potionStatusDisabled();
    }

    public boolean getShowArmor() {
        return this.showArmor && !this.armourStatusDisabled();
    }

    public boolean getKeepSneak() {
        return this.keepSneak && !this.toggleSneakDisabled();
    }

    public boolean getNotifications() {
        return this.notifications && !this.notificationsDisabled();
    }

    public boolean getNotificationHunger() {
        return this.notification_hunger && !this.notificationHungerDisabled();
    }

    public boolean getNotificationHP() {
        return this.notification_hp && !this.notificationHPDisabled();
    }

    public boolean getNotificationTNT() {
        return this.notification_tnt && !this.notificationTNTDisabled();
    }

    public boolean getNotificationArrow() {
        return this.notification_arrow && !this.notificationArrowDisabled();
    }

    public boolean getNotificationAir() {
        return this.notification_air && !this.notificationAirDisabled();
    }

    public boolean getShowEnchants() {
        return this.showEnchants && !this.armourStatusShowEnchantsDisabled();
    }

    public boolean getXP() {
        return this.xp && !this.xpDropsDisabled();
    }

    public boolean getArchery() {
        return this.archery && !this.archeryStatusDisabled();
    }

    public boolean getShowEffectNames() {
        return this.showEffectNames;
    }

    public void saveSettings() throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(BetterPvP.optionsFile));
        writer.println("ignoreUpdate:" + ignoreUpdate);
        writer.println("betterSprint:" + this.betterSprint);
        writer.println("showArmor:" + this.showArmor);
        writer.println("showEffects:" + this.showEffects);
        writer.println("showEffectNames:" + this.showEffectNames);
        writer.println("keepSneak:" + this.keepSneak);
        writer.println("enchantColor:" + this.enchantColor);
        writer.println("durability:" + this.durability);
        writer.println("notifications:" + this.notifications);
        writer.println("notification_hunger:" + this.notification_hunger);
        writer.println("notification_hp:" + this.notification_hp);
        writer.println("notification_tnt:" + this.notification_tnt);
        writer.println("notification_arrow:" + this.notification_arrow);
        writer.println("notification_air:" + this.notification_air);
        writer.println("xp:" + this.xp);
        writer.println("showEnchants:" + this.showEnchants);
        writer.println("betterNumbers:" + this.betterNumbers);
        writer.println("archery:" + this.archery);
        writer.println("lowHealth:" + this.lowHealth);
        writer.println("lowHunger:" + this.lowHunger);
        writer.println("lowAir:" + this.lowAir);
        writer.println("minimap:" + this.minimap);
        writer.println("caveMaps:" + this.caveMaps);
        writer.println("showPlayers:" + this.showPlayers);
        writer.println("showMobs:" + this.showMobs);
        writer.println("showItems:" + this.showItems);
        writer.println("showOther:" + this.showOther);
        writer.println("showOtherTeam:" + this.showOtherTeam);
        writer.println("showWaypoints:" + this.showWaypoints);
        writer.println("showIngameWaypoints:" + this.showIngameWaypoints);
        writer.println("displayRedstone:" + this.displayRedstone);
        writer.println("deathpoints:" + this.deathpoints);
        writer.println("oldDeathpoints:" + this.oldDeathpoints);
        writer.println("distance:" + this.distance);
        writer.println("showCoords:" + this.showCoords);
        writer.println("lockNorth:" + this.lockNorth);
        writer.println("zoom:" + this.zoom);
        writer.println("mapSize:" + this.mapSize);
        writer.println("entityAmount:" + this.entityAmount);
        writer.println("chunkGrid:" + this.chunkGrid);
        writer.println("slimeChunks:" + this.slimeChunks);
        writer.println("playersColor:" + this.playersColor);
        writer.println("mobsColor:" + this.mobsColor);
        writer.println("hostileColor:" + this.hostileColor);
        writer.println("itemsColor:" + this.itemsColor);
        writer.println("otherColor:" + this.otherColor);
        writer.println("mapSafeMode:" + this.mapSafeMode);
        writer.println("minimapOpacity:" + this.minimapOpacity);
        writer.println("waypointsScale:" + this.waypointsScale);
        writer.println("antiAliasing:" + this.antiAliasing);
        writer.println("blockColours:" + this.blockColours);
        writer.println("lighting:" + this.lighting);
        for (Interface l : InterfaceHandler.list) {
            writer.println("interface:" + l.iname + ":" + l.actualx + ":" + l.actualy + ":" + l.centered + ":" + l.flipped + ":" + l.fromRight);
        }
        if (!Minimap.waypointMap.isEmpty()) {
            Set<Map.Entry<String, ArrayList<Waypoint>>> keyMap = Minimap.waypointMap.entrySet();
            for (Map.Entry<String, ArrayList<Waypoint>> entry : keyMap) {
                String worldID = entry.getKey();
                ArrayList<Waypoint> waypoints = entry.getValue();
                for (Waypoint w : waypoints) {
                    writer.println("waypoint:" + worldID + ":" + w.name + ":" + w.symbol + ":" + w.x + ":" + w.y + ":" + w.z + ":" + w.color + ":" + w.disabled + ":" + w.type);
                }
            }
        }
        for (int i = 0; i < ControlsHandler.toAdd.length; ++i) {
            KeyBinding kb = ControlsHandler.toAdd[i];
            writer.println("key_" + kb.func_151464_g() + ":" + kb.func_151463_i());
        }
        writer.close();
    }

    public void loadSettings() throws IOException {
        String s;
        if (!BetterPvP.optionsFile.exists()) {
            this.saveSettings();
            return;
        }
        Minimap.waypointMap.clear();
        BufferedReader reader = new BufferedReader(new FileReader(BetterPvP.optionsFile));
        block2: while ((s = reader.readLine()) != null) {
            String[] args = s.split(":");
            try {
                if (args[0].equalsIgnoreCase("ignoreUpdate")) {
                    ignoreUpdate = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("betterSprint")) {
                    this.betterSprint = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("showArmor")) {
                    this.showArmor = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("showEffects")) {
                    this.showEffects = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("showEffectNames")) {
                    this.showEffectNames = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("keepSneak")) {
                    this.keepSneak = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("notifications")) {
                    this.notifications = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("xp")) {
                    this.xp = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("showEnchants")) {
                    this.showEnchants = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("betterNumbers")) {
                    this.betterNumbers = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("archery")) {
                    this.archery = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("notification_hunger")) {
                    this.notification_hunger = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("notification_hp")) {
                    this.notification_hp = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("notification_tnt")) {
                    this.notification_tnt = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("notification_arrow")) {
                    this.notification_arrow = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("notification_air")) {
                    this.notification_air = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("enchantColor")) {
                    this.enchantColor = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("durability")) {
                    this.durability = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("lowHealth")) {
                    this.lowHealth = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("lowHunger")) {
                    this.lowHunger = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("lowAir")) {
                    this.lowAir = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("minimap")) {
                    this.minimap = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("caveMaps")) {
                    this.caveMaps = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("showPlayers")) {
                    this.showPlayers = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("showMobs")) {
                    this.showMobs = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("showItems")) {
                    this.showItems = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("showOther")) {
                    this.showOther = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("showOtherTeam")) {
                    this.showOtherTeam = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("showWaypoints")) {
                    this.showWaypoints = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("deathpoints")) {
                    this.deathpoints = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("oldDeathpoints")) {
                    this.oldDeathpoints = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("showIngameWaypoints")) {
                    this.showIngameWaypoints = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("displayRedstone")) {
                    this.displayRedstone = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("distance")) {
                    this.distance = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("showCoords")) {
                    this.showCoords = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("lockNorth")) {
                    this.lockNorth = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("zoom")) {
                    this.zoom = Integer.parseInt(args[1]);
                    if (this.zoom < this.zooms.length) continue;
                    this.zoom = this.zooms.length - 1;
                    continue;
                }
                if (args[0].equalsIgnoreCase("mapSize")) {
                    this.mapSize = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("entityAmount")) {
                    this.entityAmount = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("chunkGrid")) {
                    this.chunkGrid = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("slimeChunks")) {
                    this.slimeChunks = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("playersColor")) {
                    this.playersColor = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("mobsColor")) {
                    this.mobsColor = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("hostileColor")) {
                    this.hostileColor = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("itemsColor")) {
                    this.itemsColor = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("otherColor")) {
                    this.otherColor = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("mapSafeMode")) {
                    this.mapSafeMode = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("minimapOpacity")) {
                    this.minimapOpacity = Float.valueOf(args[1]).floatValue();
                    continue;
                }
                if (args[0].equalsIgnoreCase("waypointsScale")) {
                    this.waypointsScale = Float.valueOf(args[1]).floatValue();
                    continue;
                }
                if (args[0].equalsIgnoreCase("antiAliasing")) {
                    this.antiAliasing = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("blockColours")) {
                    this.blockColours = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("lighting")) {
                    this.lighting = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("interface")) {
                    for (Interface l : InterfaceHandler.list) {
                        if (!args[1].equals(l.iname)) continue;
                        l.actualx = l.x = Integer.parseInt(args[2]);
                        l.bx = l.x;
                        l.actualy = l.y = Integer.parseInt(args[3]);
                        l.by = l.y;
                        l.bcentered = l.centered = args[4].equals("true");
                        l.bflipped = l.flipped = args[5].equals("true");
                        l.bfromRight = l.fromRight = args[6].equals("true");
                    }
                    continue;
                }
                if (args[0].equalsIgnoreCase("waypoint")) {
                    if (!args[1].contains("_")) {
                        args[1] = args[1] + "_null";
                    }
                    Minimap.addWorld(args[1]);
                    ArrayList<Waypoint> waypoints = Minimap.waypointMap.get(args[1]);
                    if (waypoints == null) continue;
                    Waypoint loadWaypoint = new Waypoint(Integer.parseInt(args[4]), Integer.parseInt(args[5]), Integer.parseInt(args[6]), args[2], args[3], Integer.parseInt(args[7]));
                    if (args.length > 8) {
                        loadWaypoint.disabled = args[8].equals("true");
                    }
                    if (args.length > 9) {
                        loadWaypoint.type = Integer.parseInt(args[9]);
                    }
                    waypoints.add(loadWaypoint);
                    continue;
                }
                if (!args[0].startsWith("key_")) continue;
                for (int i = 0; i < ControlsHandler.toAdd.length; ++i) {
                    KeyBinding kb = ControlsHandler.toAdd[i];
                    if (!kb.func_151464_g().equals(args[0].substring(4))) continue;
                    kb.func_151462_b(Integer.parseInt(args[1]));
                    continue block2;
                }
            }
            catch (Exception e) {
                System.out.println("Skipping setting:" + args[0]);
            }
        }
        KeyBinding.func_74508_b();
    }

    public String getKeyBinding(ModOptions par1EnumOptions) {
        String s = par1EnumOptions.getEnumString() + ": ";
        if (par1EnumOptions.getEnumFloat()) {
            float f1 = this.getOptionFloatValue(par1EnumOptions);
            return s + f1;
        }
        if (par1EnumOptions == ModOptions.ENCHANT_COLOR) {
            s = s + format + ENCHANT_COLORS[this.enchantColor] + I18n.func_135052_a((String)ENCHANT_COLOR_NAMES[this.enchantColor], (Object[])new Object[0]);
        } else if (par1EnumOptions == ModOptions.DURABILITY) {
            s = s + I18n.func_135052_a((String)DURABILITY[this.durability], (Object[])new Object[0]);
        } else if (par1EnumOptions == ModOptions.CUSTOMIZATION) {
            s = par1EnumOptions.getEnumString();
        } else if (par1EnumOptions == ModOptions.EDIT) {
            s = par1EnumOptions.getEnumString();
        } else if (par1EnumOptions == ModOptions.DOTS) {
            s = par1EnumOptions.getEnumString();
        } else if (par1EnumOptions == ModOptions.RESET) {
            s = par1EnumOptions.getEnumString();
        } else if (par1EnumOptions == ModOptions.ZOOM) {
            s = s + this.zooms[this.zoom] + "x";
        } else if (par1EnumOptions == ModOptions.COLOURS) {
            s = s + I18n.func_135052_a((String)blockColourTypes[this.blockColours], (Object[])new Object[0]);
        } else if (par1EnumOptions == ModOptions.DISTANCE) {
            s = s + I18n.func_135052_a((String)distanceTypes[this.distance], (Object[])new Object[0]);
        } else if (par1EnumOptions == ModOptions.SLIME_CHUNKS && this.customSlimeSeedNeeded()) {
            s = par1EnumOptions.getEnumString();
        } else if (par1EnumOptions == ModOptions.SIZE) {
            s = s + I18n.func_135052_a((String)MINIMAP_SIZE[this.mapSize], (Object[])new Object[0]);
        } else if (par1EnumOptions == ModOptions.EAMOUNT) {
            s = this.entityAmount == 0 ? s + I18n.func_135052_a((String)"gui.xaero_unlimited", (Object[])new Object[0]) : s + 100 * this.entityAmount;
        } else if (par1EnumOptions == ModOptions.NOTIFICATIONS_HUNGER_LOW) {
            s = s + (float)this.lowHunger;
        } else if (par1EnumOptions == ModOptions.NOTIFICATIONS_HP_LOW) {
            s = s + (float)this.lowHealth;
        } else if (par1EnumOptions == ModOptions.NOTIFICATIONS_AIR_LOW) {
            s = s + (float)this.lowAir;
        } else {
            boolean clientSetting = this.getClientBooleanValue(par1EnumOptions);
            boolean serverSetting = this.getBooleanValue(par1EnumOptions);
            s = s + ModSettings.getTranslation(clientSetting) + (serverSetting != clientSetting ? "\u00a7e (" + ModSettings.getTranslation(serverSetting) + ")" : "");
        }
        return s;
    }

    public boolean getBooleanValue(ModOptions o) {
        if (o == ModOptions.MINIMAP) {
            return this.getMinimap();
        }
        if (o == ModOptions.CAVE_MAPS) {
            return this.getCaveMaps();
        }
        if (o == ModOptions.DISPLAY_OTHER_TEAM) {
            return this.getShowOtherTeam();
        }
        if (o == ModOptions.WAYPOINTS) {
            return this.getShowWaypoints();
        }
        if (o == ModOptions.DEATHPOINTS) {
            return this.getDeathpoints();
        }
        if (o == ModOptions.OLD_DEATHPOINTS) {
            return this.getOldDeathpoints();
        }
        if (o == ModOptions.INGAME_WAYPOINTS) {
            return this.getShowIngameWaypoints();
        }
        if (o == ModOptions.REDSTONE) {
            return this.displayRedstone;
        }
        if (o == ModOptions.COORDS) {
            return this.getShowCoords();
        }
        if (o == ModOptions.NORTH) {
            return this.getLockNorth();
        }
        if (o == ModOptions.PLAYERS) {
            return this.getShowPlayers();
        }
        if (o == ModOptions.MOBS) {
            return this.getShowMobs();
        }
        if (o == ModOptions.ITEMS) {
            return this.getShowItems();
        }
        if (o == ModOptions.ENTITIES) {
            return this.getShowOther();
        }
        if (o == ModOptions.CHUNK_GRID) {
            return this.getChunkGrid();
        }
        if (o == ModOptions.SLIME_CHUNKS) {
            return this.slimeChunks;
        }
        if (o == ModOptions.SAFE_MAP) {
            return Minimap.triedFBO && !Minimap.usingFBO();
        }
        if (o == ModOptions.AA) {
            return this.getAntiAliasing();
        }
        if (o == ModOptions.LIGHT) {
            return this.lighting;
        }
        if (o == ModOptions.BETTER_SPRINT) {
            return this.getBetterSprint();
        }
        if (o == ModOptions.SHOW_ARMOR) {
            return this.getShowArmor();
        }
        if (o == ModOptions.SHOW_EFFECTS) {
            return this.getShowEffects();
        }
        if (o == ModOptions.POTION_NAMES) {
            return this.getShowEffectNames();
        }
        if (o == ModOptions.KEEP_SNEAK) {
            return this.getKeepSneak();
        }
        if (o == ModOptions.NOTIFICATIONS) {
            return this.getNotifications();
        }
        if (o == ModOptions.XP) {
            return this.getXP();
        }
        if (o == ModOptions.SHOW_ENCHANTS) {
            return this.getShowEnchants();
        }
        if (o == ModOptions.ARCHERY) {
            return this.getArchery();
        }
        if (o == ModOptions.NUMBERS) {
            return this.getBetterNumbers();
        }
        if (o == ModOptions.NOTIFICATIONS_HUNGER) {
            return this.getNotificationHunger();
        }
        if (o == ModOptions.NOTIFICATIONS_HP) {
            return this.getNotificationHP();
        }
        if (o == ModOptions.NOTIFICATIONS_TNT) {
            return this.getNotificationTNT();
        }
        if (o == ModOptions.NOTIFICATIONS_ARROW) {
            return this.getNotificationArrow();
        }
        if (o == ModOptions.NOTIFICATIONS_AIR) {
            return this.getNotificationAir();
        }
        return false;
    }

    public boolean getClientBooleanValue(ModOptions o) {
        if (o == ModOptions.MINIMAP) {
            return this.minimap;
        }
        if (o == ModOptions.CAVE_MAPS) {
            return this.caveMaps;
        }
        if (o == ModOptions.DISPLAY_OTHER_TEAM) {
            return this.showOtherTeam;
        }
        if (o == ModOptions.WAYPOINTS) {
            return this.showWaypoints;
        }
        if (o == ModOptions.DEATHPOINTS) {
            return this.deathpoints;
        }
        if (o == ModOptions.OLD_DEATHPOINTS) {
            return this.oldDeathpoints;
        }
        if (o == ModOptions.INGAME_WAYPOINTS) {
            return this.showIngameWaypoints;
        }
        if (o == ModOptions.REDSTONE) {
            return this.displayRedstone;
        }
        if (o == ModOptions.COORDS) {
            return this.showCoords;
        }
        if (o == ModOptions.NORTH) {
            return this.lockNorth;
        }
        if (o == ModOptions.PLAYERS) {
            return this.showPlayers;
        }
        if (o == ModOptions.MOBS) {
            return this.showMobs;
        }
        if (o == ModOptions.ITEMS) {
            return this.showItems;
        }
        if (o == ModOptions.ENTITIES) {
            return this.showOther;
        }
        if (o == ModOptions.CHUNK_GRID) {
            return this.chunkGrid;
        }
        if (o == ModOptions.SLIME_CHUNKS) {
            return this.slimeChunks;
        }
        if (o == ModOptions.SAFE_MAP) {
            return this.mapSafeMode;
        }
        if (o == ModOptions.AA) {
            return this.antiAliasing;
        }
        if (o == ModOptions.LIGHT) {
            return this.lighting;
        }
        if (o == ModOptions.BETTER_SPRINT) {
            return this.betterSprint;
        }
        if (o == ModOptions.SHOW_ARMOR) {
            return this.showArmor;
        }
        if (o == ModOptions.SHOW_EFFECTS) {
            return this.showEffects;
        }
        if (o == ModOptions.POTION_NAMES) {
            return this.showEffectNames;
        }
        if (o == ModOptions.KEEP_SNEAK) {
            return this.keepSneak;
        }
        if (o == ModOptions.NOTIFICATIONS) {
            return this.notifications;
        }
        if (o == ModOptions.XP) {
            return this.xp;
        }
        if (o == ModOptions.SHOW_ENCHANTS) {
            return this.showEnchants;
        }
        if (o == ModOptions.ARCHERY) {
            return this.archery;
        }
        if (o == ModOptions.NUMBERS) {
            return this.betterNumbers;
        }
        if (o == ModOptions.NOTIFICATIONS_HUNGER) {
            return this.notification_hunger;
        }
        if (o == ModOptions.NOTIFICATIONS_HP) {
            return this.notification_hp;
        }
        if (o == ModOptions.NOTIFICATIONS_TNT) {
            return this.notification_tnt;
        }
        if (o == ModOptions.NOTIFICATIONS_ARROW) {
            return this.notification_arrow;
        }
        if (o == ModOptions.NOTIFICATIONS_AIR) {
            return this.notification_air;
        }
        return false;
    }

    private static String getTranslation(boolean o) {
        return I18n.func_135052_a((String)("gui.xaero_" + (o ? "on" : "off")), (Object[])new Object[0]);
    }

    public void setOptionValue(ModOptions par1EnumOptions, int par2) throws IOException {
        if (par1EnumOptions == ModOptions.ZOOM) {
            this.zoom = (this.zoom + 1) % this.zooms.length;
        } else if (par1EnumOptions == ModOptions.SIZE) {
            this.mapSize = (this.mapSize + 1) % 4;
            Minimap.resetImage();
            Minimap.frameUpdateNeeded = Minimap.usingFBO();
        } else if (par1EnumOptions == ModOptions.EAMOUNT) {
            this.entityAmount = (this.entityAmount + 1) % 11;
        } else if (par1EnumOptions == ModOptions.MINIMAP) {
            this.minimap = !this.minimap;
        } else if (par1EnumOptions == ModOptions.CAVE_MAPS) {
            this.caveMaps = !this.caveMaps;
        } else if (par1EnumOptions == ModOptions.DISPLAY_OTHER_TEAM) {
            this.showOtherTeam = !this.showOtherTeam;
        } else if (par1EnumOptions == ModOptions.WAYPOINTS) {
            this.showWaypoints = !this.showWaypoints;
        } else if (par1EnumOptions == ModOptions.DEATHPOINTS) {
            this.deathpoints = !this.deathpoints;
        } else if (par1EnumOptions == ModOptions.OLD_DEATHPOINTS) {
            this.oldDeathpoints = !this.oldDeathpoints;
        } else if (par1EnumOptions == ModOptions.INGAME_WAYPOINTS) {
            this.showIngameWaypoints = !this.showIngameWaypoints;
        } else if (par1EnumOptions == ModOptions.REDSTONE) {
            this.displayRedstone = !this.displayRedstone;
        } else if (par1EnumOptions == ModOptions.DISTANCE) {
            this.distance = (this.distance + 1) % distanceTypes.length;
        } else if (par1EnumOptions == ModOptions.COORDS) {
            this.showCoords = !this.showCoords;
        } else if (par1EnumOptions == ModOptions.NORTH) {
            this.lockNorth = !this.lockNorth;
        } else if (par1EnumOptions == ModOptions.PLAYERS) {
            this.showPlayers = !this.showPlayers;
        } else if (par1EnumOptions == ModOptions.MOBS) {
            this.showMobs = !this.showMobs;
        } else if (par1EnumOptions == ModOptions.ITEMS) {
            this.showItems = !this.showItems;
        } else if (par1EnumOptions == ModOptions.ENTITIES) {
            this.showOther = !this.showOther;
        } else if (par1EnumOptions == ModOptions.CHUNK_GRID) {
            this.chunkGrid = !this.chunkGrid;
            Minimap.frameUpdateNeeded = Minimap.usingFBO();
        } else if (par1EnumOptions == ModOptions.SLIME_CHUNKS) {
            if (this.customSlimeSeedNeeded()) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiSlimeSeed(Minecraft.func_71410_x().field_71462_r));
                return;
            }
            this.slimeChunks = !this.slimeChunks;
            Minimap.frameUpdateNeeded = Minimap.usingFBO();
        } else if (par1EnumOptions == ModOptions.SAFE_MAP) {
            this.mapSafeMode = !this.mapSafeMode;
            Minimap.resetImage();
            Minimap.frameUpdateNeeded = Minimap.usingFBO();
        } else if (par1EnumOptions == ModOptions.AA) {
            this.antiAliasing = !this.antiAliasing;
        } else if (par1EnumOptions == ModOptions.COLOURS) {
            this.blockColours = (this.blockColours + 1) % blockColourTypes.length;
        } else if (par1EnumOptions == ModOptions.LIGHT) {
            this.lighting = !this.lighting;
        } else if (par1EnumOptions == ModOptions.ENCHANT_COLOR) {
            this.enchantColor = (this.enchantColor + 1) % ENCHANT_COLORS.length;
        } else if (par1EnumOptions == ModOptions.DURABILITY) {
            this.durability = (this.durability + 1) % 3;
        } else if (par1EnumOptions == ModOptions.NOTIFICATIONS_HUNGER) {
            this.notification_hunger = !this.notification_hunger;
        } else if (par1EnumOptions == ModOptions.NOTIFICATIONS_HP) {
            this.notification_hp = !this.notification_hp;
        } else if (par1EnumOptions == ModOptions.NOTIFICATIONS_HUNGER_LOW) {
            this.lowHunger = (this.lowHunger + 1) % 11;
            if (this.lowHunger == 0) {
                this.lowHunger = 1;
            }
        } else if (par1EnumOptions == ModOptions.NOTIFICATIONS_HP_LOW) {
            this.lowHealth = (this.lowHealth + 1) % 11;
            if (this.lowHealth == 0) {
                this.lowHealth = 1;
            }
        } else if (par1EnumOptions == ModOptions.NOTIFICATIONS_AIR_LOW) {
            this.lowAir = (this.lowAir + 1) % 11;
            if (this.lowAir == 0) {
                this.lowAir = 1;
            }
        } else if (par1EnumOptions == ModOptions.NOTIFICATIONS_TNT) {
            this.notification_tnt = !this.notification_tnt;
        } else if (par1EnumOptions == ModOptions.NOTIFICATIONS_ARROW) {
            this.notification_arrow = !this.notification_arrow;
        } else if (par1EnumOptions == ModOptions.NOTIFICATIONS_AIR) {
            this.notification_air = !this.notification_air;
        } else if (par1EnumOptions == ModOptions.NUMBERS) {
            this.betterNumbers = !this.betterNumbers;
        } else if (par1EnumOptions == ModOptions.SHOW_EFFECTS) {
            this.showEffects = !this.showEffects;
        } else if (par1EnumOptions == ModOptions.POTION_NAMES) {
            this.showEffectNames = !this.showEffectNames;
        } else if (par1EnumOptions == ModOptions.BETTER_SPRINT) {
            this.betterSprint = !this.betterSprint;
        } else if (par1EnumOptions == ModOptions.SHOW_ARMOR) {
            this.showArmor = !this.showArmor;
        } else if (par1EnumOptions == ModOptions.KEEP_SNEAK) {
            this.keepSneak = !this.keepSneak;
        } else if (par1EnumOptions == ModOptions.NOTIFICATIONS) {
            this.notifications = !this.notifications;
        } else if (par1EnumOptions == ModOptions.ARCHERY) {
            this.archery = !this.archery;
        } else if (par1EnumOptions == ModOptions.XP) {
            this.xp = !this.xp;
        } else if (par1EnumOptions == ModOptions.SHOW_ENCHANTS) {
            this.showEnchants = !this.showEnchants;
        }
        this.saveSettings();
        if (Minecraft.func_71410_x().field_71462_r != null) {
            Minecraft.func_71410_x().field_71462_r.func_73866_w_();
        }
    }

    public void setOptionFloatValue(ModOptions options, float f) throws IOException {
        if (options == ModOptions.OPACITY) {
            this.minimapOpacity = f;
        }
        if (options == ModOptions.WAYPOINTS_SCALE) {
            this.waypointsScale = f;
        }
        this.saveSettings();
    }

    public float getOptionFloatValue(ModOptions options) {
        if (options == ModOptions.OPACITY) {
            return this.minimapOpacity;
        }
        if (options == ModOptions.WAYPOINTS_SCALE) {
            return this.waypointsScale;
        }
        return 1.0f;
    }

    public boolean minimapDisabled() {
        return (serverSettings & 1) == 0;
    }

    public boolean armourStatusDisabled() {
        return (serverSettings & 2) == 0;
    }

    public boolean potionStatusDisabled() {
        return (serverSettings & 4) == 0;
    }

    public boolean archeryStatusDisabled() {
        return (serverSettings & 8) == 0;
    }

    public boolean notificationsDisabled() {
        return (serverSettings & 0x10) == 0;
    }

    public boolean xpDropsDisabled() {
        return (serverSettings & 0x20) == 0;
    }

    public boolean betterSprintDisabled() {
        return (serverSettings & 0x40) == 0;
    }

    public boolean toggleSneakDisabled() {
        return (serverSettings & 0x80) == 0;
    }

    public boolean quickItemsDisabled() {
        return (serverSettings & 0x100) == 0;
    }

    public boolean armourStatusShowEnchantsDisabled() {
        return (serverSettings & 0x200) == 0;
    }

    public boolean minimapDisplayPlayersDisabled() {
        return (serverSettings & 0x400) == 0;
    }

    public boolean minimapDisplayMobsDisabled() {
        return (serverSettings & 0x800) == 0;
    }

    public boolean minimapDisplayItemsDisabled() {
        return (serverSettings & 0x1000) == 0;
    }

    public boolean minimapDisplayOtherDisabled() {
        return (serverSettings & 0x2000) == 0;
    }

    public boolean caveMapsDisabled() {
        return (serverSettings & 0x4000) == 0;
    }

    public boolean showOtherTeamDisabled() {
        return (serverSettings & 0x8000) == 0;
    }

    public boolean showWaypointsDisabled() {
        return (serverSettings & 0x10000) == 0;
    }

    public boolean notificationHungerDisabled() {
        return (serverSettings & 0x20000) == 0;
    }

    public boolean notificationHPDisabled() {
        return (serverSettings & 0x40000) == 0;
    }

    public boolean notificationTNTDisabled() {
        return (serverSettings & 0x80000) == 0;
    }

    public boolean notificationArrowDisabled() {
        return (serverSettings & 0x100000) == 0;
    }

    public boolean deathpointsDisabled() {
        return (serverSettings & 0x200000) == 0;
    }

    public boolean notificationAirDisabled() {
        return (serverSettings & 0x400000) == 0;
    }

    public void resetServerSettings() {
        serverSettings = Integer.MAX_VALUE;
    }

    public static void setServerSettings() {
    }

    static {
        keysLoaded = false;
        ENCHANT_COLORS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        ENCHANT_COLOR_NAMES = new String[]{"gui.xaero_black", "gui.xaero_dark_blue", "gui.xaero_dark_green", "gui.xaero_dark_aqua", "gui.xaero_dark_red", "gui.xaero_dark_purple", "gui.xaero_gold", "gui.xaero_gray", "gui.xaero_dark_gray", "gui.xaero_blue", "gui.xaero_green", "gui.xaero_aqua", "gui.xaero_red", "gui.xaero_purple", "gui.xaero_yellow", "gui.xaero_white"};
        COLORS = new int[]{new Color(0, 0, 0, 255).hashCode(), new Color(0, 0, 170, 255).hashCode(), new Color(0, 170, 0, 255).hashCode(), new Color(0, 170, 170, 255).hashCode(), new Color(170, 0, 0, 255).hashCode(), new Color(170, 0, 170, 255).hashCode(), new Color(255, 170, 0, 255).hashCode(), new Color(170, 170, 170, 255).hashCode(), new Color(85, 85, 85, 255).hashCode(), new Color(85, 85, 255, 255).hashCode(), new Color(85, 255, 85, 255).hashCode(), new Color(85, 255, 255, 255).hashCode(), new Color(255, 0, 0, 255).hashCode(), new Color(255, 85, 255, 255).hashCode(), new Color(255, 255, 85, 255).hashCode(), new Color(255, 255, 255, 255).hashCode()};
        DURABILITY = new String[]{"gui.xaero_percent", "gui.xaero_numeral", "gui.xaero_both"};
        MINIMAP_SIZE = new String[]{"gui.xaero_tiny", "gui.xaero_small", "gui.xaero_medium", "gui.xaero_large", "gui.xaero_large"};
        serverSettings = Integer.MAX_VALUE;
        keyBindEat = new KeyBinding("gui.xaero_quick_eat", 33, "Better PVP Mod");
        keyBindToggleSneak = new KeyBinding("gui.xaero_toggle_sneak", 46, "Better PVP Mod");
        keyBindPvP1 = new KeyBinding("gui.xaero_quick_use_1", 79, "Better PVP Mod");
        keyBindPvP2 = new KeyBinding("gui.xaero_quick_use_2", 80, "Better PVP Mod");
        keyBindPvP3 = new KeyBinding("gui.xaero_quick_use_3", 81, "Better PVP Mod");
        keyBindPvP4 = new KeyBinding("gui.xaero_quick_use_4", 75, "Better PVP Mod");
        keyBindPvP5 = new KeyBinding("gui.xaero_quick_use_5", 76, "Better PVP Mod");
        keyBindPvP6 = new KeyBinding("gui.xaero_quick_use_6", 77, "Better PVP Mod");
        keyBindPvP7 = new KeyBinding("gui.xaero_quick_use_7", 71, "Better PVP Mod");
        keyBindPvP8 = new KeyBinding("gui.xaero_quick_use_8", 72, "Better PVP Mod");
        keyBindPvP9 = new KeyBinding("gui.xaero_quick_use_9", 73, "Better PVP Mod");
        keyBindSettings = new KeyBinding("gui.xaero_better_pvp_settings", 21, "Better PVP Mod");
        keyBindZoom = new KeyBinding("gui.xaero_zoom_in", 23, "Better PVP Mod");
        keyBindZoom1 = new KeyBinding("gui.xaero_zoom_out", 24, "Better PVP Mod");
        newWaypoint = new KeyBinding("gui.xaero_new_waypoint", 48, "Better PVP Mod");
        keyWaypoints = new KeyBinding("gui.xaero_waypoints_key", 22, "Better PVP Mod");
        keyLargeMap = new KeyBinding("gui.xaero_enlarge_map", 44, "Better PVP Mod");
        keyToggleMap = new KeyBinding("gui.xaero_toggle_map", 35, "Better PVP Mod");
        distanceTypes = new String[]{"gui.xaero_off", "gui.xaero_looking_at", "gui.xaero_all"};
        blockColourTypes = new String[]{"gui.xaero_accurate", "gui.xaero_vanilla"};
    }
}

