/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.environment;

import com.sonicjumper.enhancedvisuals.Base;
import com.sonicjumper.enhancedvisuals.environment.BaseEnvironmentEffect;
import com.sonicjumper.enhancedvisuals.environment.TemperatureFactor;
import com.sonicjumper.enhancedvisuals.event.VisualEventHandler;
import com.sonicjumper.enhancedvisuals.util.EntityUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;

public class TemperatureHandler
extends BaseEnvironmentEffect {
    private float temperature = 1.0f;
    private ArrayList<TemperatureFactor> factors = new ArrayList();

    public TemperatureHandler(VisualEventHandler veh) {
        super(veh);
        this.factors.add(new TemperatureFactor(){

            @Override
            public boolean runFactor() {
                float currentWorldTemp = TemperatureHandler.this.parent.mc.field_71441_e.func_180494_b((BlockPos)new BlockPos((int)((int)Math.floor((double)TemperatureHandler.this.parent.mc.field_71439_g.field_70165_t)), (int)0, (int)((int)Math.floor((double)TemperatureHandler.this.parent.mc.field_71439_g.field_70161_v)))).field_76750_F;
                this.factor = currentWorldTemp + (TemperatureHandler.this.parent.mc.field_71439_g.func_70027_ad() ? 4.0f : 0.0f) - TemperatureHandler.this.parent.wetnessHandler.getWetness() * (TemperatureHandler.this.parent.mc.field_71439_g.func_70051_ag() ? 4.0f : 1.0f);
                return true;
            }

            @Override
            public float getFactorRate() {
                return (float)(TemperatureHandler.this.parent.mc.field_71439_g.func_70051_ag() ? 4.0E-4 : 1.0E-4);
            }
        });
        this.factors.add(new TemperatureFactor(){

            @Override
            public boolean runFactor() {
                this.factor = 0.0f;
                int leatherCount = 0;
                for (int j = 0; j < 4; ++j) {
                    ItemArmor armor;
                    ItemStack wornItem = TemperatureHandler.this.parent.mc.field_71439_g.func_82169_q(j);
                    if (wornItem == null || !(wornItem.func_77973_b() instanceof ItemArmor) || !(armor = (ItemArmor)wornItem.func_77973_b()).func_82812_d().equals((Object)ItemArmor.ArmorMaterial.LEATHER)) continue;
                    ++leatherCount;
                }
                if (TemperatureHandler.this.temperature < 0.15f * (float)leatherCount) {
                    this.factor = 0.15f * (float)leatherCount;
                }
                return this.factor != 0.0f;
            }

            @Override
            public float getFactorRate() {
                return 1.0E-4f;
            }
        });
        this.factors.add(new TemperatureFactor(){

            @Override
            public boolean runFactor() {
                double dist;
                this.factor = 1.0f;
                float heat = 0.0f;
                if (EntityUtil.isBlockNearEntity((Entity)TemperatureHandler.this.parent.mc.field_71439_g, (Block)Blocks.field_150480_ab, 8)) {
                    dist = EntityUtil.getDistanceToNearestBlock((Entity)TemperatureHandler.this.parent.mc.field_71439_g, (Block)Blocks.field_150480_ab, 8);
                    heat = Math.max((float)(1.0 / dist) * 2.0f, heat);
                }
                if (EntityUtil.isBlockNearEntity((Entity)TemperatureHandler.this.parent.mc.field_71439_g, (Block)Blocks.field_150353_l, 8)) {
                    dist = EntityUtil.getDistanceToNearestBlock((Entity)TemperatureHandler.this.parent.mc.field_71439_g, (Block)Blocks.field_150353_l, 8);
                    heat = Math.max((float)(1.0 / dist) * 5.0f, heat);
                }
                if (EntityUtil.isBlockNearEntity((Entity)TemperatureHandler.this.parent.mc.field_71439_g, (Block)Blocks.field_150356_k, 8)) {
                    dist = EntityUtil.getDistanceToNearestBlock((Entity)TemperatureHandler.this.parent.mc.field_71439_g, (Block)Blocks.field_150356_k, 8);
                    heat = Math.max((float)(1.0 / dist) * 5.0f, heat);
                }
                this.factor += heat;
                return this.factor != 1.0f;
            }

            @Override
            public float getFactorRate() {
                return 1.0E-4f;
            }
        });
    }

    @Override
    public void onTick() {
        for (TemperatureFactor tf : this.factors) {
            if (!tf.runFactor()) continue;
            this.temperature += (tf.getFactor() - this.temperature) * tf.getFactorRate();
        }
        this.temperature = this.temperature > 2.0f ? 2.0f : this.temperature;
        float f = this.temperature = this.temperature < 0.0f ? 0.0f : this.temperature;
        if (this.temperature < 0.25f) {
            float cold = (1.0f - this.temperature * 4.0f) * 0.75f;
            Base.instance.manager.adjustColdOverlay(cold < 1.0f ? cold : 1.0f);
        }
        if (this.temperature > 1.0f) {
            float heat = (this.temperature - 1.0f) * 0.75f;
            Base.instance.manager.adjustHeatOverlay(heat < 1.0f ? heat : 1.0f);
        }
    }

    @Override
    public void resetEffect() {
        this.temperature = 1.0f;
    }
}

