/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.shaders;

import com.google.gson.JsonSyntaxException;
import com.sonicjumper.enhancedvisuals.Base;
import com.sonicjumper.enhancedvisuals.shaders.ShaderGroupCustom;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class ShaderHelper {
    private Minecraft mc;
    private IResourceManager resourceManager;
    private ShaderGroupCustom theShaderGroup;
    private String shaderName;
    private boolean useShader;

    public ShaderHelper(Minecraft minecraft, IResourceManager resourceManager) {
        this.mc = minecraft;
        this.resourceManager = resourceManager;
    }

    public boolean isShaderActive(String name) {
        return name.equals(this.shaderName);
    }

    public void loadShader(String name, ResourceLocation shadersPostLocation) {
        if (this.theShaderGroup != null) {
            this.theShaderGroup.deleteShaderGroup();
        }
        try {
            this.theShaderGroup = new ShaderGroupCustom(this.mc.func_110434_K(), this.resourceManager, this.mc.func_147110_a(), shadersPostLocation);
            this.theShaderGroup.createBindFramebuffers(this.mc.field_71443_c, this.mc.field_71440_d);
            this.useShader = true;
            this.shaderName = name;
        }
        catch (IOException ioexception) {
            Base.log.warn("Failed to load shader: " + shadersPostLocation, (Throwable)ioexception);
            this.useShader = false;
            this.shaderName = "";
        }
        catch (JsonSyntaxException jsonsyntaxexception) {
            Base.log.warn("Failed to load shader: " + shadersPostLocation, (Throwable)jsonsyntaxexception);
            this.useShader = false;
            this.shaderName = "";
        }
    }

    public void drawShaders(float partialTicks) {
        if (Base.instance.shaderHelper.getShaderGroup() != null && this.useShader) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179096_D();
            Base.instance.shaderHelper.getShaderGroup().loadShaderGroup(partialTicks);
            GlStateManager.func_179121_F();
        }
        this.mc.func_147110_a().func_147610_a(false);
    }

    public ShaderGroupCustom getShaderGroup() {
        return this.theShaderGroup;
    }

    public void removeShader(String name) {
        this.useShader = false;
        this.theShaderGroup = null;
    }
}

