/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.visuals;

import com.sonicjumper.enhancedvisuals.filters.AbstractBufferedImageOp;
import com.sonicjumper.enhancedvisuals.filters.BoxBlurFilter;
import com.sonicjumper.enhancedvisuals.render.BlurHelper;
import com.sonicjumper.enhancedvisuals.visuals.Blur;
import com.sonicjumper.enhancedvisuals.visuals.VisualType;
import java.awt.Color;
import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;

public class BoxBlur
extends Blur {
    protected int blurRadius;
    protected int blurIterations;

    public BoxBlur(VisualType type, int time, Color rgba, boolean resets, float scale, int radius, int iterations) {
        super(type, time, rgba, resets, scale);
        this.blurRadius = radius;
        this.blurIterations = iterations;
    }

    @Override
    public void resetBufferedImage(float translucency) {
        if (this.resetsOnTick || this.image == null) {
            long time = Minecraft.func_71386_F();
            long totalTime = Minecraft.func_71386_F();
            Minecraft mc = Minecraft.func_71410_x();
            BufferedImage screen = BlurHelper.captureScreenAsImage(mc.field_71443_c, mc.field_71440_d);
            System.out.println("Capture Time: " + (Minecraft.func_71386_F() - time));
            time = Minecraft.func_71386_F();
            BufferedImage scaledImage = BlurHelper.scaleImage(screen, this.blurScaling);
            System.out.println("Scale Time: " + (Minecraft.func_71386_F() - time));
            ((BoxBlurFilter)this.filter).setRadius((int)((float)this.blurRadius * translucency));
            time = Minecraft.func_71386_F();
            BufferedImage filtered = this.filter.filter(scaledImage, null);
            System.out.println("Filter Time: " + (Minecraft.func_71386_F() - time));
            this.image = this.prepareImage(filtered);
            System.out.println("Total Time: " + (Minecraft.func_71386_F() - totalTime));
        }
    }

    @Override
    public AbstractBufferedImageOp getFilter() {
        BoxBlurFilter bbf = new BoxBlurFilter();
        bbf.setRadius(this.getRadius());
        bbf.setIterations(this.getIterations());
        return bbf;
    }

    public int getRadius() {
        return this.blurRadius;
    }

    public int getIterations() {
        return this.blurIterations;
    }
}

