/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.visuals;

import com.sonicjumper.enhancedvisuals.visuals.Animation;
import com.sonicjumper.enhancedvisuals.visuals.Overlay;
import com.sonicjumper.enhancedvisuals.visuals.Shader;
import com.sonicjumper.enhancedvisuals.visuals.Splat;
import com.sonicjumper.enhancedvisuals.visuals.Visual;
import com.sonicjumper.enhancedvisuals.visuals.VisualType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntitySquid;

public class VisualManager {
    private ArrayList<Visual> playerVisuals = new ArrayList();
    private ArrayList<Visual> permVisuals = new ArrayList();
    private Overlay heatOverlay;
    private Overlay iceOverlay;
    private Overlay wetOverlay;
    private Random rand = new Random();

    public VisualManager() {
        this.heatOverlay = new Overlay(VisualType.heat, -1, new Color(1.0f, 1.0f, 1.0f, 0.0f));
        this.iceOverlay = new Overlay(VisualType.ice, -1, new Color(1.0f, 1.0f, 1.0f, 0.0f));
        this.wetOverlay = new Overlay(VisualType.waterO, -1, new Color(1.0f, 1.0f, 1.0f, 0.0f));
        this.permVisuals.add(this.heatOverlay);
        this.permVisuals.add(this.iceOverlay);
        this.permVisuals.add(this.wetOverlay);
    }

    public ArrayList<Visual> getActiveVisuals() {
        ArrayList<Visual> alv = new ArrayList<Visual>();
        alv.addAll(this.playerVisuals);
        alv.addAll(this.permVisuals);
        return alv;
    }

    public ArrayList<Shader> getActiveShaders() {
        ArrayList<Shader> shaders = new ArrayList<Shader>();
        for (Visual v : this.playerVisuals) {
            if (!(v instanceof Shader)) continue;
            shaders.add((Shader)v);
        }
        return shaders;
    }

    public void removeVisual(Visual v) {
        v.beingRemoved();
        this.playerVisuals.remove(v);
    }

    public void clearAllVisuals() {
        this.playerVisuals.clear();
    }

    public void addVisuals(VisualType vt, int num, int minTime, int maxTime) {
        this.addVisualsWithShading(vt, num, minTime, maxTime, Color.WHITE);
    }

    public void addVisualDirect(Visual v) {
        this.playerVisuals.add(v);
    }

    public void addRandomNumVisualsWithColor(VisualType vt, int minNum, int maxNum, int minTime, int maxTime, Color color) {
        if (maxNum <= minNum) {
            this.addVisualsWithShading(vt, minNum, minTime, maxTime, color);
        } else {
            this.addVisualsWithShading(vt, minNum + this.rand.nextInt(maxNum - minNum), minTime, maxTime, color);
        }
    }

    public void addVisualsWithShading(VisualType vt, int num, int minTime, int maxTime, Color color) {
        for (int i = 0; i < num; ++i) {
            Visual v = vt.getCatagory().ordinal() == Visual.VisualCatagory.Animation.ordinal() ? (minTime == maxTime ? new Animation(vt, minTime, color) : new Animation(vt, minTime + this.rand.nextInt(maxTime - minTime), color)) : (vt.getCatagory().ordinal() == Visual.VisualCatagory.Overlay.ordinal() ? (minTime == maxTime ? new Overlay(vt, minTime, color) : new Overlay(vt, minTime + this.rand.nextInt(maxTime - minTime), color)) : (vt.getCatagory().ordinal() == Visual.VisualCatagory.Splat.ordinal() ? (minTime == maxTime ? new Splat(vt, minTime, color) : new Splat(vt, minTime + this.rand.nextInt(maxTime - minTime), color)) : (minTime == maxTime ? new Visual(vt, minTime, color) : new Visual(vt, minTime + this.rand.nextInt(maxTime - minTime), color))));
            this.playerVisuals.add(v);
        }
    }

    public void createVisualFromDamage(VisualType type, float damage, EntityLivingBase bleedingEntity) {
        this.createVisualFromDamageAndDistance(type, damage, bleedingEntity, 1.0);
    }

    public void createVisualFromDamageAndDistance(VisualType type, float damage, EntityLivingBase bleedingEntity, double distanceSqToEntity) {
        if (damage <= 0.0f) {
            return;
        }
        double distance = Math.sqrt(distanceSqToEntity);
        distance = Math.max(distance, 1.0);
        double distMultiplier = 1.0 / (distance / 2.0);
        float rate = 0.0f;
        float health = bleedingEntity.func_110143_aJ() - damage;
        if (health > 12.0f) {
            rate = 1.0f;
        }
        if (health <= 12.0f && health > 8.0f) {
            rate = 1.5f;
        }
        if (health <= 8.0f && health > 4.0f) {
            rate = 2.0f;
        }
        if (health <= 4.0f && health > 0.0f) {
            rate = 2.5f;
        }
        if (health <= 0.0f) {
            rate = 3.0f;
        }
        int splats = (int)((double)(damage * rate) * distMultiplier);
        if (type.equals(VisualType.splatter) || type.equals(VisualType.slash) || type.equals(VisualType.pierce) || type.equals(VisualType.impact)) {
            if (bleedingEntity instanceof EntityCreeper) {
                this.addVisualsWithShading(type, splats, 500, 1500, new Color(0.0f, 0.4f, 0.0f, 0.7f));
            } else if (bleedingEntity instanceof EntitySkeleton) {
                this.addVisualsWithShading(type, splats, 500, 1500, new Color(0.1f, 0.1f, 0.1f, 0.7f));
            } else if (bleedingEntity instanceof EntitySquid) {
                this.addVisualsWithShading(type, splats, 500, 1500, new Color(0.0f, 0.0f, 0.2f, 0.7f));
            } else {
                this.addVisualsWithShading(type, splats, 500, 1500, new Color(0.3f, 0.01f, 0.01f, 0.7f));
            }
        } else if (type.equals(VisualType.dust)) {
            this.addVisualsWithShading(type, splats * 20, 100, 1000, new Color(0.2f, 0.2f, 0.2f, 1.0f));
        }
    }

    private float randMultiplier(double min, double max) {
        return (float)(min + this.rand.nextDouble() * (max - min));
    }

    public void adjustHeatOverlay(float intensity) {
        this.heatOverlay.setTranslucency(intensity);
    }

    public void adjustColdOverlay(float intensity) {
        this.iceOverlay.setTranslucency(intensity);
    }

    public void adjustWetOverlay(float intensity) {
        this.wetOverlay.setTranslucency(intensity);
    }
}

