/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.environment;

import com.sonicjumper.enhancedvisuals.Base;
import com.sonicjumper.enhancedvisuals.ConfigCore;
import com.sonicjumper.enhancedvisuals.environment.BaseEnvironmentEffect;
import com.sonicjumper.enhancedvisuals.event.VisualEventHandler;
import com.sonicjumper.enhancedvisuals.visuals.Blur;
import com.sonicjumper.enhancedvisuals.visuals.BoxGlowBlur;
import com.sonicjumper.enhancedvisuals.visuals.BoxReverseGlowBlur;
import com.sonicjumper.enhancedvisuals.visuals.GlowBlur;
import com.sonicjumper.enhancedvisuals.visuals.ReverseGlowBlur;
import com.sonicjumper.enhancedvisuals.visuals.VisualType;
import java.awt.Color;

public class EyeSensitivityHandler
extends BaseEnvironmentEffect {
    private float eyeAdjustment = 0.4f;
    private int glowBuffer;

    public EyeSensitivityHandler(VisualEventHandler veh) {
        super(veh);
    }

    @Override
    public void onTick() {
        float currentPlayerBrightness = this.parent.mc.field_71439_g.func_70013_c(0.0f);
        this.eyeAdjustment = currentPlayerBrightness <= this.eyeAdjustment ? (float)((double)this.eyeAdjustment + (double)(currentPlayerBrightness - this.eyeAdjustment) * 0.01) : (float)((double)this.eyeAdjustment + (double)(currentPlayerBrightness - this.eyeAdjustment) * 0.05);
        if (currentPlayerBrightness - this.eyeAdjustment > 0.5f) {
            if (this.glowBuffer <= 0) {
                Blur r;
                if (ConfigCore.useTrueGlow) {
                    GlowBlur g = new GlowBlur(VisualType.blur, (int)((currentPlayerBrightness - this.eyeAdjustment) * 200.0f), new Color(1.0f, 1.0f, 1.0f, 1.0f), true, ConfigCore.blurQuality, (int)(15.0f * (currentPlayerBrightness - this.eyeAdjustment)), (currentPlayerBrightness - this.eyeAdjustment) * 2.0f);
                    r = new ReverseGlowBlur(VisualType.blur, (int)((currentPlayerBrightness - this.eyeAdjustment) * 25.0f), new Color(1.0f, 1.0f, 1.0f, 1.0f), true, ConfigCore.blurQuality, (int)(15.0f * (currentPlayerBrightness - this.eyeAdjustment)), (currentPlayerBrightness - this.eyeAdjustment) * 2.0f, g);
                } else {
                    BoxGlowBlur g = new BoxGlowBlur(VisualType.blur, (int)((currentPlayerBrightness - this.eyeAdjustment) * 200.0f), new Color(1.0f, 1.0f, 1.0f, 1.0f), true, ConfigCore.blurQuality, (int)(15.0f * (currentPlayerBrightness - this.eyeAdjustment)), 1, (currentPlayerBrightness - this.eyeAdjustment) * 2.0f);
                    r = new BoxReverseGlowBlur(VisualType.blur, (int)((currentPlayerBrightness - this.eyeAdjustment) * 25.0f), new Color(1.0f, 1.0f, 1.0f, 1.0f), true, ConfigCore.blurQuality, (int)(15.0f * (currentPlayerBrightness - this.eyeAdjustment)), 1, (currentPlayerBrightness - this.eyeAdjustment) * 2.0f, g);
                }
                Base.instance.manager.addVisualDirect(r);
                this.glowBuffer = (int)((currentPlayerBrightness - this.eyeAdjustment) * 200.0f);
            }
            this.eyeAdjustment += currentPlayerBrightness - this.eyeAdjustment;
        }
        if (this.glowBuffer > 0) {
            --this.glowBuffer;
        }
    }

    @Override
    public void resetEffect() {
        this.eyeAdjustment = 0.4f;
    }
}

