/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.render;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class BlurHelper {
    private static IntBuffer intBuffer;
    private static ByteBuffer byteBuffer;
    private static int[] intDataArray;
    private static byte[] byteDataArray;

    public static BufferedImage scaleImage(BufferedImage image, float scale) {
        AffineTransform at = new AffineTransform();
        at.scale(scale, scale);
        AffineTransformOp scaleOp = new AffineTransformOp(at, 1);
        return scaleOp.filter(image, new BufferedImage((int)((float)image.getWidth() * scale), (int)((float)image.getHeight() * scale), 1));
    }

    public static BufferedImage captureScreenAsImage() {
        return BlurHelper.captureScreenAsImage(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
    }

    public static BufferedImage captureScreenAsImage(int par1, int par2) {
        int k = par1 * par2;
        if (intBuffer == null || intBuffer.capacity() < k) {
            intBuffer = BufferUtils.createIntBuffer((int)k);
            intDataArray = new int[k];
        }
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        long time = Minecraft.func_71386_F();
        intBuffer.clear();
        GL11.glReadPixels((int)0, (int)0, (int)par1, (int)par2, (int)32993, (int)33639, (IntBuffer)intBuffer);
        System.out.println("Read Pixels Time: " + (Minecraft.func_71386_F() - time));
        intBuffer.get(intDataArray);
        BlurHelper.flipImage(intDataArray, par1, par2);
        time = Minecraft.func_71386_F();
        BufferedImage bufferedImage = new BufferedImage(par1, par2, 1);
        BlurHelper.setRGB(bufferedImage, 0, 0, par1, par2, intDataArray);
        System.out.println("New Image Creation Time: " + (Minecraft.func_71386_F() - time));
        return bufferedImage;
    }

    private static void flipImage(int[] par0ArrayOfInteger, int par1, int par2) {
        int[] aint1 = new int[par1];
        int k = par2 / 2;
        for (int l = 0; l < k; ++l) {
            System.arraycopy(par0ArrayOfInteger, l * par1, aint1, 0, par1);
            System.arraycopy(par0ArrayOfInteger, (par2 - 1 - l) * par1, par0ArrayOfInteger, l * par1, par1);
            System.arraycopy(aint1, 0, par0ArrayOfInteger, (par2 - 1 - l) * par1, par1);
        }
    }

    private static void flipImage(byte[] par0ArrayOfByte, int par1, int par2) {
        byte[] aint1 = new byte[par1];
        int k = par2 / 2;
        for (int l = 0; l < k; ++l) {
            System.arraycopy(par0ArrayOfByte, l * par1, aint1, 0, par1);
            System.arraycopy(par0ArrayOfByte, (par2 - 1 - l) * par1, par0ArrayOfByte, l * par1, par1);
            System.arraycopy(aint1, 0, par0ArrayOfByte, (par2 - 1 - l) * par1, par1);
        }
    }

    private static void setRGB(BufferedImage image, int x, int y, int width, int height, int[] pixels) {
        int type = image.getType();
        if (type == 2 || type == 1) {
            image.getRaster().setDataElements(x, y, width, height, pixels);
        } else {
            image.setRGB(x, y, width, height, pixels, 0, width);
        }
    }
}

