/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.shaders.util;

public class Color {
    public static final Color TRANSPARENT = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Color WHITE = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    public static final Color YELLOW = new Color(1.0f, 1.0f, 0.0f, 1.0f);
    public static final Color RED = new Color(1.0f, 0.0f, 0.0f, 1.0f);
    public static final Color BLUE = new Color(0.0f, 0.0f, 1.0f, 1.0f);
    public static final Color GREEN = new Color(0.0f, 1.0f, 0.0f, 1.0f);
    public static final Color BLACK = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    public static final Color GRAY = new Color(0.5f, 0.5f, 0.5f, 1.0f);
    public static final Color CYAN = new Color(0.0f, 1.0f, 1.0f, 1.0f);
    public static final Color DARK_GRAY = new Color(0.3f, 0.3f, 0.3f, 1.0f);
    public static final Color LIGHT_GRAY = new Color(0.7f, 0.7f, 0.7f, 1.0f);
    public static final Color PINK = new Color(255, 175, 175, 255);
    public static final Color ORANGE = new Color(255, 200, 0, 255);
    public static final Color MAGENTA = new Color(255, 0, 255, 255);
    public float r;
    public float g;
    public float b;
    public float a;

    public Color(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public Color(float r, float g, float b) {
        this(r, g, b, 1.0f);
    }

    public Color(int r, int g, int b, int a) {
        this((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public Color(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Color() {
        this(WHITE);
    }

    public Color(Color color) {
        this(color.r, color.g, color.b, color.a);
    }

    public Color(int value) {
        int r = (value & 0xFF0000) >> 16;
        int g = (value & 0xFF00) >> 8;
        int b = value & 0xFF;
        int a = (value & 0xFF000000) >> 24;
        if (a < 0) {
            a += 256;
        }
        if (a == 0) {
            a = 255;
        }
        this.r = (float)r / 255.0f;
        this.g = (float)g / 255.0f;
        this.b = (float)b / 255.0f;
        this.a = (float)a / 255.0f;
    }

    public static Color decode(String nm) {
        return new Color(Integer.decode(nm));
    }

    public int red() {
        return (int)(this.r * 255.0f);
    }

    public int green() {
        return (int)(this.g * 255.0f);
    }

    public int blue() {
        return (int)(this.b * 255.0f);
    }

    public int alpha() {
        return (int)(this.a * 255.0f);
    }

    public void set(Color color) {
        this.set(color.r, color.g, color.b, color.a);
    }

    public void set(float r, float g, float b, float a) {
        this.set(r, g, b);
        this.a = a;
    }

    public void set(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public int toIntBits() {
        int color = (int)(255.0f * this.a) << 24 | (int)(255.0f * this.b) << 16 | (int)(255.0f * this.g) << 8 | (int)(255.0f * this.r);
        return color;
    }

    public int hashCode() {
        return (int)(this.r + this.g + this.b + this.a) * 255;
    }

    public boolean equals(Object other) {
        if (other instanceof Color) {
            Color o = (Color)other;
            return o.r == this.r && o.g == this.g && o.b == this.b && o.a == this.a;
        }
        return false;
    }

    public String toString() {
        return "Color (" + this.r + "," + this.g + "," + this.b + "," + this.a + ")";
    }
}

