/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.util;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class SplatUtil {
    private static Random rand;

    public static List<Point2D> generateRandomSplatStreak(int totalSplats) {
        if (rand == null) {
            rand = new Random();
        }
        ArrayList<Point2D> listOfPoints = new ArrayList<Point2D>();
        Point2D.Double startPoint = new Point2D.Double(rand.nextDouble(), rand.nextDouble());
        Point2D endPoint = SplatUtil.generateRandomPointWithDistance(startPoint, 0.5);
        Point2D controlPoint = SplatUtil.generateRandomPointWithDistance(startPoint, 0.25);
        System.out.println("Start: " + ((Object)startPoint).toString());
        System.out.println("Control: " + controlPoint.toString());
        System.out.println("End: " + endPoint.toString());
        float steps = totalSplats;
        int i = 0;
        while ((float)i < steps + 1.0f) {
            double y;
            float t = (float)i / steps;
            double x = (double)((1.0f - t) * (1.0f - t)) * ((Point2D)startPoint).getX() + (double)(2.0f * (1.0f - t) * t) * controlPoint.getX() + (double)(t * t) * endPoint.getX();
            Point2D point = SplatUtil.generateRandomPointWithDistance(new Point2D.Double(x, y = (double)((1.0f - t) * (1.0f - t)) * ((Point2D)startPoint).getY() + (double)(2.0f * (1.0f - t) * t) * controlPoint.getY() + (double)(t * t) * endPoint.getY()), 0.05f);
            if (point.getX() >= 0.0 && point.getX() <= 1.0 && point.getY() >= 0.0 && point.getY() <= 1.0) {
                listOfPoints.add(point);
            }
            ++i;
        }
        return listOfPoints;
    }

    public static Point2D generateRandomPointWithDistance(Point2D point, double maxDistance) {
        double distInXSq = (double)rand.nextFloat() * Math.pow(maxDistance, 2.0);
        double distInYSq = Math.pow(maxDistance, 2.0) - distInXSq;
        double newXPos = (float)(rand.nextInt(2) == 0 ? point.getX() + Math.sqrt(distInXSq) : point.getX() - Math.sqrt(distInXSq));
        double newYPos = (float)(rand.nextInt(2) == 0 ? point.getY() + Math.sqrt(distInYSq) : point.getY() - Math.sqrt(distInYSq));
        return new Point2D.Double(newXPos, newYPos);
    }
}

