/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.visuals;

import com.sonicjumper.enhancedvisuals.filters.AbstractBufferedImageOp;
import com.sonicjumper.enhancedvisuals.filters.GlowFilter;
import com.sonicjumper.enhancedvisuals.render.BlurHelper;
import com.sonicjumper.enhancedvisuals.visuals.Blur;
import com.sonicjumper.enhancedvisuals.visuals.VisualType;
import java.awt.Color;
import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;

public class GlowBlur
extends Blur {
    private float glowAmount;
    protected int blurRadius;

    public GlowBlur(VisualType type, int time, Color rgba, boolean resets, float scale, int radius, float amount) {
        super(type, time, rgba, resets, scale);
        this.glowAmount = amount;
        this.blurRadius = radius;
    }

    @Override
    public void resetBufferedImage(float translucency) {
        if (this.resetsOnTick || this.image == null) {
            BufferedImage screen = BlurHelper.captureScreenAsImage(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
            BufferedImage scaledImage = BlurHelper.scaleImage(screen, this.blurScaling);
            ((GlowFilter)this.filter).setRadius((int)((float)this.blurRadius * translucency));
            ((GlowFilter)this.filter).setAmount(this.glowAmount * translucency);
            long time = Minecraft.func_71386_F();
            BufferedImage filtered = this.filter.filter(scaledImage, null);
            System.out.println("Filter Time: " + (Minecraft.func_71386_F() - time));
            this.image = this.prepareImage(filtered);
        }
    }

    @Override
    public AbstractBufferedImageOp getFilter() {
        GlowFilter gf = new GlowFilter();
        gf.setRadius(this.getRadius());
        gf.setAmount(this.getGlowAmount());
        return gf;
    }

    protected int getRadius() {
        return this.blurRadius;
    }

    public float getGlowAmount() {
        return this.glowAmount;
    }
}

