/*
 * Decompiled with CFR 0.152.
 */
package divblocks.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import divblocks.proxy.ServerProxy;
import divblocks.utils.TableDoubleSlab;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDoubleSlab
extends Block {
    public final BlockDoubleSlabHalf bottom;
    public final BlockDoubleSlabHalf top;
    private static final TableDoubleSlab slabsTable = new TableDoubleSlab();

    public BlockDoubleSlab(ItemStack bottomItemStack, ItemStack topItemStack, Material material) {
        super(material);
        this.bottom = new BlockDoubleSlabHalf(bottomItemStack, (BlockSlab)Block.func_149634_a((Item)bottomItemStack.func_77973_b()), bottomItemStack.func_77960_j());
        this.top = new BlockDoubleSlabHalf(topItemStack, (BlockSlab)Block.func_149634_a((Item)topItemStack.func_77973_b()), topItemStack.func_77960_j());
        slabsTable.put(this.bottom.block instanceof BlockStoneSlab ? 0 : 1, this.top.block instanceof BlockStoneSlab ? 0 : 1, bottomItemStack.func_77960_j() + (topItemStack.func_77960_j() << 4), this);
        if (material == Material.field_151575_d) {
            this.func_149711_c(2.0f);
            this.func_149752_b(5.0f);
            this.func_149672_a(field_149766_f);
        } else {
            this.func_149711_c(2.0f);
            this.func_149752_b(10.0f);
            this.func_149672_a(field_149780_i);
        }
    }

    public int func_149645_b() {
        return ServerProxy.renderDoubleSlabId;
    }

    public static BlockDoubleSlab get(BlockSlab bottomBlock, BlockSlab topBlock, Integer metadata) {
        return slabsTable.get(bottomBlock instanceof BlockStoneSlab ? 0 : 1, topBlock instanceof BlockStoneSlab ? 0 : 1, metadata);
    }

    public boolean func_149655_b(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if ((metadata & 8) == 0) {
            return this.top.block.func_149688_o().func_76230_c();
        }
        return this.bottom.block.func_149688_o().func_76230_c();
    }

    public void func_149690_a(World world, int x, int y, int z, int metadata, float randomMax, int fortune) {
        if (!world.field_72995_K && !world.restoringBlockSnapshots) {
            this.func_149642_a(world, x, y, z, new ItemStack((Block)this.top.block, 1, this.top.metadata));
            this.func_149642_a(world, x, y, z, new ItemStack((Block)this.bottom.block, 1, this.bottom.metadata));
        }
    }

    protected void func_149642_a(World world, int x, int y, int z, ItemStack itemStack) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots) {
            if (((Boolean)this.captureDrops.get()).booleanValue()) {
                ((List)this.capturedDrops.get()).add(itemStack);
                return;
            }
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, itemStack);
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        return side != 0 && (side == 1 || (double)hitY <= 0.5) ? metadata : metadata | 8;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta == 0) {
            return this.bottom.block.func_149691_a(side, this.bottom.metadata);
        }
        return this.top.block.func_149691_a(side, this.top.metadata);
    }

    public static final class BlockDoubleSlabHalf
    extends Block {
        public final BlockSlab block;
        public final int metadata;
        public final ItemStack stack;

        public BlockDoubleSlabHalf(ItemStack stack, BlockSlab block, int metadata) {
            super(block.func_149688_o());
            this.stack = stack;
            this.block = block;
            this.metadata = metadata;
        }

        @SideOnly(value=Side.CLIENT)
        public IIcon func_149691_a(int side, int meta) {
            return this.block.func_149691_a(side, this.metadata);
        }

        @SideOnly(value=Side.CLIENT)
        public void getBound(IBlockAccess world, int x, int y, int z, int k) {
            if (k == 0) {
                this.block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
            } else {
                this.block.func_149676_a(0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }
}

