/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.lib;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.lib.TexturedQuadTC;
import thaumcraft.common.config.Config;

public class UtilsFX {
    public static final String[] colorNames = new String[]{"White", "Orange", "Magenta", "Light Blue", "Yellow", "Lime", "Pink", "Gray", "Light Gray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};
    public static final String[] colorCodes = new String[]{"\u00a7f", "\u00a76", "\u00a7d", "\u00a79", "\u00a7e", "\u00a7a", "\u00a7d", "\u00a78", "\u00a77", "\u00a7b", "\u00a75", "\u00a79", "\u00a74", "\u00a72", "\u00a7c", "\u00a78"};
    public static final int[] colors = new int[]{0xF0F0F0, 15435844, 12801229, 6719955, 14602026, 4312372, 14188952, 0x434343, 0xA0A0A0, 2651799, 8073150, 2437522, 5320730, 3887386, 11743532, 0x1E1B1B};
    static DecimalFormat myFormatter = new DecimalFormat("#######.##");
    public static float sysPartialTicks = 0.0f;

    public static void renderFacingQuad(double px, double py, double pz, int gridX, int gridY, int frame, float scale, int color, float alpha, int blend, float partialTicks) {
        if (Minecraft.func_71410_x().func_175606_aa() instanceof EntityPlayer) {
            Tessellator tessellator = Tessellator.func_178181_a();
            WorldRenderer wr = tessellator.func_178180_c();
            float arX = ActiveRenderInfo.func_178808_b();
            float arZ = ActiveRenderInfo.func_178803_d();
            float arYZ = ActiveRenderInfo.func_178805_e();
            float arXY = ActiveRenderInfo.func_178807_f();
            float arXZ = ActiveRenderInfo.func_178809_c();
            EntityPlayer player = (EntityPlayer)Minecraft.func_71410_x().func_175606_aa();
            double iPX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
            double iPY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
            double iPZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)blend);
            GlStateManager.func_179092_a((int)516, (float)0.003921569f);
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslated((double)(-iPX), (double)(-iPY), (double)(-iPZ));
            Vec3 v1 = new Vec3((double)(-arX * scale - arYZ * scale), (double)(-arXZ * scale), (double)(-arZ * scale - arXY * scale));
            Vec3 v2 = new Vec3((double)(-arX * scale + arYZ * scale), (double)(arXZ * scale), (double)(-arZ * scale + arXY * scale));
            Vec3 v3 = new Vec3((double)(arX * scale + arYZ * scale), (double)(arXZ * scale), (double)(arZ * scale + arXY * scale));
            Vec3 v4 = new Vec3((double)(arX * scale - arYZ * scale), (double)(-arXZ * scale), (double)(arZ * scale - arXY * scale));
            int xm = frame % gridX;
            int ym = frame / gridY;
            float f1 = (float)xm / (float)gridX;
            float f2 = f1 + 1.0f / (float)gridX;
            float f3 = (float)ym / (float)gridY;
            float f4 = f3 + 1.0f / (float)gridY;
            TexturedQuadTC quad = new TexturedQuadTC(new PositionTextureVertex[]{new PositionTextureVertex((float)px + (float)v1.field_72450_a, (float)py + (float)v1.field_72448_b, (float)pz + (float)v1.field_72449_c, f2, f4), new PositionTextureVertex((float)px + (float)v2.field_72450_a, (float)py + (float)v2.field_72448_b, (float)pz + (float)v2.field_72449_c, f2, f3), new PositionTextureVertex((float)px + (float)v3.field_72450_a, (float)py + (float)v3.field_72448_b, (float)pz + (float)v3.field_72449_c, f1, f3), new PositionTextureVertex((float)px + (float)v4.field_72450_a, (float)py + (float)v4.field_72448_b, (float)pz + (float)v4.field_72449_c, f1, f4)});
            quad.draw(tessellator.func_178180_c(), 1.0f, 220, color, alpha);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179084_k();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179121_F();
        }
    }

    public static void drawTexturedQuad(int par1, int par2, int par3, int par4, int par5, int par6, double zLevel) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator var9 = Tessellator.func_178181_a();
        var9.func_178180_c().func_178970_b();
        var9.func_178180_c().func_178985_a((double)(par1 + 0), (double)(par2 + par6), zLevel, (double)((float)(par3 + 0) * var7), (double)((float)(par4 + par6) * var8));
        var9.func_178180_c().func_178985_a((double)(par1 + par5), (double)(par2 + par6), zLevel, (double)((float)(par3 + par5) * var7), (double)((float)(par4 + par6) * var8));
        var9.func_178180_c().func_178985_a((double)(par1 + par5), (double)(par2 + 0), zLevel, (double)((float)(par3 + par5) * var7), (double)((float)(par4 + 0) * var8));
        var9.func_178180_c().func_178985_a((double)(par1 + 0), (double)(par2 + 0), zLevel, (double)((float)(par3 + 0) * var7), (double)((float)(par4 + 0) * var8));
        var9.func_78381_a();
    }

    public static void drawTexturedQuadFull(int par1, int par2, double zLevel) {
        Tessellator var9 = Tessellator.func_178181_a();
        var9.func_178180_c().func_178970_b();
        var9.func_178180_c().func_178985_a((double)(par1 + 0), (double)(par2 + 16), zLevel, 0.0, 1.0);
        var9.func_178180_c().func_178985_a((double)(par1 + 16), (double)(par2 + 16), zLevel, 1.0, 1.0);
        var9.func_178180_c().func_178985_a((double)(par1 + 16), (double)(par2 + 0), zLevel, 1.0, 0.0);
        var9.func_178180_c().func_178985_a((double)(par1 + 0), (double)(par2 + 0), zLevel, 0.0, 0.0);
        var9.func_78381_a();
    }

    public static void drawItemInGUI(int x, int y, ItemStack stack, GuiScreen gui) {
        boolean blendon = GL11.glIsEnabled((int)3042);
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74520_c();
        gui.field_146297_k.func_175599_af().func_180450_b(stack, x, y);
        gui.field_146297_k.func_175599_af().func_180453_a(gui.field_146297_k.field_71466_p, stack, x, y, "");
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        if (!blendon) {
            GlStateManager.func_179084_k();
        }
        GlStateManager.func_179121_F();
    }

    public static void renderItemInGUI(int x, int y, int z, ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        try {
            GlStateManager.func_179094_E();
            RenderHelper.func_74520_c();
            GlStateManager.func_179140_f();
            GlStateManager.func_179091_B();
            GlStateManager.func_179142_g();
            GlStateManager.func_179145_e();
            mc.func_175599_af().field_77023_b = z;
            mc.func_175599_af().func_180450_b(stack, x, y);
            mc.func_175599_af().field_77023_b = 0.0f;
            GlStateManager.func_179140_f();
            GlStateManager.func_179121_F();
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void renderQuadCentered(ResourceLocation texture, float scale, float red, float green, float blue, int brightness, int blend, float opacity) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        UtilsFX.renderQuadCentered(1, 1, 0, scale, red, green, blue, brightness, blend, opacity);
    }

    public static void renderQuadCentered(ResourceLocation texture, int gridX, int gridY, int frame, float scale, float red, float green, float blue, int brightness, int blend, float opacity) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        UtilsFX.renderQuadCentered(gridX, gridY, frame, scale, red, green, blue, brightness, blend, opacity);
    }

    public static void renderQuadCentered() {
        UtilsFX.renderQuadCentered(1, 1, 0, 1.0f, 1.0f, 1.0f, 1.0f, 200, 771, 1.0f);
    }

    public static void renderQuadCentered(int gridX, int gridY, int frame, float scale, float red, float green, float blue, int brightness, int blend, float opacity) {
        boolean blendon = GL11.glIsEnabled((int)3042);
        Tessellator tessellator = Tessellator.func_178181_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)blend);
        int xm = frame % gridX;
        int ym = frame / gridY;
        float f1 = (float)xm / (float)gridX;
        float f2 = f1 + 1.0f / (float)gridX;
        float f3 = (float)ym / (float)gridY;
        float f4 = f3 + 1.0f / (float)gridY;
        Color c = new Color(red, green, blue);
        TexturedQuadTC quad = new TexturedQuadTC(new PositionTextureVertex[]{new PositionTextureVertex(-0.5f, 0.5f, 0.0f, f2, f4), new PositionTextureVertex(0.5f, 0.5f, 0.0f, f2, f3), new PositionTextureVertex(0.5f, -0.5f, 0.0f, f1, f3), new PositionTextureVertex(-0.5f, -0.5f, 0.0f, f1, f4)});
        quad.draw(tessellator.func_178180_c(), scale, brightness, c.getRGB(), opacity);
        if (!blendon) {
            GlStateManager.func_179084_k();
        }
    }

    public static void renderQuadFromIcon(TextureAtlasSprite icon, float scale, float red, float green, float blue, int brightness, int blend, float opacity) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        Tessellator tessellator = Tessellator.func_178181_a();
        float f1 = icon.func_94212_f();
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94209_e();
        float f4 = icon.func_94210_h();
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)blend);
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)opacity);
        tessellator.func_178180_c().func_178970_b();
        if (brightness > -1) {
            tessellator.func_178180_c().func_178963_b(brightness);
        }
        tessellator.func_178180_c().func_178960_a(red, green, blue, opacity);
        tessellator.func_178180_c().func_178980_d(0.0f, 0.0f, 1.0f);
        tessellator.func_178180_c().func_178985_a(0.0, 0.0, 0.0, (double)f1, (double)f4);
        tessellator.func_178180_c().func_178985_a(1.0, 0.0, 0.0, (double)f3, (double)f4);
        tessellator.func_178180_c().func_178985_a(1.0, 1.0, 0.0, (double)f3, (double)f2);
        tessellator.func_178180_c().func_178985_a(0.0, 1.0, 0.0, (double)f1, (double)f2);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
    }

    public static void drawTag(int x, int y, Aspect aspect, float amount, int bonus, double z, int blend, float alpha) {
        UtilsFX.drawTag(x, y, aspect, amount, bonus, z, blend, alpha, false);
    }

    public static void drawTag(int x, int y, Aspect aspect, float amt, int bonus, double z) {
        UtilsFX.drawTag(x, y, aspect, amt, bonus, z, 771, 1.0f, false);
    }

    public static void drawTag(int x, int y, Aspect aspect) {
        UtilsFX.drawTag(x, y, aspect, 0.0f, 0, 0.0, 771, 1.0f, true);
    }

    public static void drawTag(int x, int y, Aspect aspect, float amount, int bonus, double z, int blend, float alpha, boolean bw) {
        UtilsFX.drawTag((double)x, (double)y, aspect, amount, bonus, z, blend, alpha, bw);
    }

    public static void drawTag(double x, double y, Aspect aspect, float amount, int bonus, double z, int blend, float alpha, boolean bw) {
        if (aspect == null) {
            return;
        }
        boolean blendon = GL11.glIsEnabled((int)3042);
        Minecraft mc = Minecraft.func_71410_x();
        boolean isLightingEnabled = GL11.glIsEnabled((int)2896);
        Color color = new Color(aspect.getColor());
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)blend);
        GL11.glPushMatrix();
        mc.field_71446_o.func_110577_a(aspect.getImage());
        if (!bw) {
            GL11.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)alpha);
        } else {
            GL11.glColor4f((float)0.1f, (float)0.1f, (float)0.1f, (float)(alpha * 0.8f));
        }
        Tessellator var9 = Tessellator.func_178181_a();
        var9.func_178180_c().func_178970_b();
        if (!bw) {
            var9.func_178180_c().func_178960_a((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, alpha);
        } else {
            var9.func_178180_c().func_178960_a(0.1f, 0.1f, 0.1f, alpha * 0.8f);
        }
        var9.func_178180_c().func_178985_a(x + 0.0, y + 16.0, z, 0.0, 1.0);
        var9.func_178180_c().func_178985_a(x + 16.0, y + 16.0, z, 1.0, 1.0);
        var9.func_178180_c().func_178985_a(x + 16.0, y + 0.0, z, 1.0, 0.0);
        var9.func_178180_c().func_178985_a(x + 0.0, y + 0.0, z, 0.0, 0.0);
        var9.func_78381_a();
        GL11.glPopMatrix();
        if (amount > 0.0f) {
            GL11.glPushMatrix();
            float q = 0.5f;
            if (!Config.largeTagText) {
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                q = 1.0f;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String am = myFormatter.format(amount);
            int sw = mc.field_71466_p.func_78256_a(am);
            mc.field_71466_p.func_175063_a(am, (float)(32 - sw + (int)x * 2) * q, (float)(32 - mc.field_71466_p.field_78288_b + (int)y * 2) * q, 0xFFFFFF);
            GL11.glPopMatrix();
        }
        if (bonus > 0) {
            GL11.glPushMatrix();
            mc.field_71446_o.func_110577_a(ParticleEngine.particleTexture);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int px = 16 * (mc.field_71439_g.field_70173_aa % 16);
            UtilsFX.drawTexturedQuad((int)x - 4, (int)y - 4, px, 80, 16, 16, z);
            if (bonus > 1) {
                float q = 0.5f;
                if (!Config.largeTagText) {
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                    q = 1.0f;
                }
                String am = "" + bonus;
                int sw = mc.field_71466_p.func_78256_a(am) / 2;
                GL11.glTranslated((double)0.0, (double)0.0, (double)-1.0);
                mc.field_71466_p.func_175063_a(am, (float)(8 - sw + (int)x * 2) * q, (float)(15 - mc.field_71466_p.field_78288_b + (int)y * 2) * q, 0xFFFFFF);
            }
            GL11.glPopMatrix();
        }
        if (!blendon) {
            GL11.glDisable((int)3042);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        if (isLightingEnabled) {
            GL11.glEnable((int)2896);
        } else {
            GL11.glDisable((int)2896);
        }
        GL11.glPopMatrix();
    }

    public static void drawCustomTooltip(GuiScreen gui, FontRenderer fr, List textList, int x, int y, int subTipColor) {
        if (!textList.isEmpty()) {
            int w;
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int widestLineWidth = 0;
            Iterator textLineEntry = textList.iterator();
            int totalHeight = -2;
            while (textLineEntry.hasNext()) {
                String textLine = (String)textLineEntry.next();
                int lineWidth = fr.func_78256_a(textLine);
                if (textLine.startsWith("@@")) {
                    lineWidth /= 2;
                }
                if (lineWidth > widestLineWidth) {
                    widestLineWidth = lineWidth;
                }
                totalHeight += textLine.startsWith("@@") ? 7 : 10;
            }
            int sX = x + 12;
            int sY = y - 12;
            if (textList.size() > 1) {
                totalHeight += 2;
            }
            int n = w = gui == null ? Integer.MAX_VALUE : gui.field_146294_l;
            if (widestLineWidth + sX > w) {
                sX -= widestLineWidth + 24;
            }
            Minecraft.func_71410_x().func_175599_af().field_77023_b = 300.0f;
            int var10 = -267386864;
            UtilsFX.drawGradientRect(sX - 3, sY - 4, sX + widestLineWidth + 3, sY - 3, var10, var10);
            UtilsFX.drawGradientRect(sX - 3, sY + totalHeight + 3, sX + widestLineWidth + 3, sY + totalHeight + 4, var10, var10);
            UtilsFX.drawGradientRect(sX - 3, sY - 3, sX + widestLineWidth + 3, sY + totalHeight + 3, var10, var10);
            UtilsFX.drawGradientRect(sX - 4, sY - 3, sX - 3, sY + totalHeight + 3, var10, var10);
            UtilsFX.drawGradientRect(sX + widestLineWidth + 3, sY - 3, sX + widestLineWidth + 4, sY + totalHeight + 3, var10, var10);
            int var11 = 0x505000FF;
            int var12 = (var11 & 0xFEFEFE) >> 1 | var11 & 0xFF000000;
            UtilsFX.drawGradientRect(sX - 3, sY - 3 + 1, sX - 3 + 1, sY + totalHeight + 3 - 1, var11, var12);
            UtilsFX.drawGradientRect(sX + widestLineWidth + 2, sY - 3 + 1, sX + widestLineWidth + 3, sY + totalHeight + 3 - 1, var11, var12);
            UtilsFX.drawGradientRect(sX - 3, sY - 3, sX + widestLineWidth + 3, sY - 3 + 1, var11, var11);
            UtilsFX.drawGradientRect(sX - 3, sY + totalHeight + 2, sX + widestLineWidth + 3, sY + totalHeight + 3, var12, var12);
            for (int i = 0; i < textList.size(); ++i) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)sX, (float)sY, (float)0.0f);
                String tl = (String)textList.get(i);
                boolean shift = false;
                GL11.glPushMatrix();
                if (tl.startsWith("@@")) {
                    tl = tl.replaceAll("@@", "");
                    sY += 7;
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
                    shift = true;
                } else {
                    sY += 10;
                }
                if (subTipColor != -99) {
                    tl = i == 0 ? "\u00a7" + Integer.toHexString(subTipColor) + tl : "\u00a77" + tl;
                }
                GL11.glTranslated((double)0.0, (double)0.0, (double)301.0);
                fr.func_175063_a(tl, 0.0f, shift ? 3.0f : 0.0f, -1);
                GL11.glPopMatrix();
                if (i == 0) {
                    sY += 2;
                }
                GL11.glPopMatrix();
            }
            Minecraft.func_71410_x().func_175599_af().field_77023_b = 0.0f;
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
        }
    }

    public static void drawGradientRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        boolean blendon = GL11.glIsEnabled((int)3042);
        float var7 = (float)(par5 >> 24 & 0xFF) / 255.0f;
        float var8 = (float)(par5 >> 16 & 0xFF) / 255.0f;
        float var9 = (float)(par5 >> 8 & 0xFF) / 255.0f;
        float var10 = (float)(par5 & 0xFF) / 255.0f;
        float var11 = (float)(par6 >> 24 & 0xFF) / 255.0f;
        float var12 = (float)(par6 >> 16 & 0xFF) / 255.0f;
        float var13 = (float)(par6 >> 8 & 0xFF) / 255.0f;
        float var14 = (float)(par6 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator var15 = Tessellator.func_178181_a();
        var15.func_178180_c().func_178970_b();
        var15.func_178180_c().func_178960_a(var8, var9, var10, var7);
        var15.func_178180_c().func_178984_b((double)par3, (double)par2, 300.0);
        var15.func_178180_c().func_178984_b((double)par1, (double)par2, 300.0);
        var15.func_178180_c().func_178960_a(var12, var13, var14, var11);
        var15.func_178180_c().func_178984_b((double)par1, (double)par4, 300.0);
        var15.func_178180_c().func_178984_b((double)par3, (double)par4, 300.0);
        var15.func_78381_a();
        GL11.glShadeModel((int)7424);
        if (!blendon) {
            GL11.glDisable((int)3042);
        }
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static int getGuiXSize(GuiContainer gui) {
        try {
            return (Integer)ReflectionHelper.getPrivateValue(GuiContainer.class, (Object)gui, (String[])new String[]{"xSize", "f", "field_146999_f"});
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int getGuiYSize(GuiContainer gui) {
        try {
            return (Integer)ReflectionHelper.getPrivateValue(GuiContainer.class, (Object)gui, (String[])new String[]{"ySize", "g", "field_147000_g"});
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static float getGuiZLevel(Gui gui) {
        try {
            return ((Float)ReflectionHelper.getPrivateValue(Gui.class, (Object)gui, (String[])new String[]{"zLevel", "e", "field_73735_i"})).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public static ResourceLocation getMCParticleTexture() {
        try {
            return (ResourceLocation)ReflectionHelper.getPrivateValue(EffectRenderer.class, null, (String[])new String[]{"particleTextures", "field_110737_b", "b"});
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void renderBillboardQuad(double scale) {
        GL11.glPushMatrix();
        UtilsFX.rotateToPlayer();
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_178970_b();
        tessellator.func_178180_c().func_178985_a(-scale, -scale, 0.0, 0.0, 0.0);
        tessellator.func_178180_c().func_178985_a(-scale, scale, 0.0, 0.0, 1.0);
        tessellator.func_178180_c().func_178985_a(scale, scale, 0.0, 1.0, 1.0);
        tessellator.func_178180_c().func_178985_a(scale, -scale, 0.0, 1.0, 0.0);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    public static void renderBillboardQuadWithRotation(float rot, double scale) {
        GL11.glPushMatrix();
        UtilsFX.rotateToPlayer();
        GL11.glRotatef((float)rot, (float)0.0f, (float)0.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_178970_b();
        tessellator.func_178180_c().func_178985_a(-scale, -scale, 0.0, 0.0, 0.0);
        tessellator.func_178180_c().func_178985_a(-scale, scale, 0.0, 0.0, 1.0);
        tessellator.func_178180_c().func_178985_a(scale, scale, 0.0, 1.0, 1.0);
        tessellator.func_178180_c().func_178985_a(scale, -scale, 0.0, 1.0, 0.0);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    public static void rotateToPlayer() {
        GL11.glRotatef((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)Minecraft.func_71410_x().func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    public static boolean renderItemStack(Minecraft mc, ItemStack itm, int x, int y, String txt) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderItem itemRender = mc.func_175599_af();
        boolean isLightingEnabled = GL11.glIsEnabled((int)2896);
        boolean rc = false;
        if (itm != null && itm.func_77973_b() != null) {
            rc = true;
            boolean isRescaleNormalEnabled = GL11.glIsEnabled((int)32826);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)32826);
            GL11.glEnable((int)2896);
            int short1 = 240;
            int short2 = 240;
            RenderHelper.func_74520_c();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)short1 / 1.0f), (float)((float)short2 / 1.0f));
            itemRender.func_180450_b(itm, x, y);
            itemRender.func_180453_a(mc.field_71466_p, itm, x, y, txt);
            GL11.glPopMatrix();
            if (isRescaleNormalEnabled) {
                GL11.glEnable((int)32826);
            } else {
                GL11.glDisable((int)32826);
            }
        }
        if (isLightingEnabled) {
            GL11.glEnable((int)2896);
        } else {
            GL11.glDisable((int)2896);
        }
        return rc;
    }

    public static void drawBeam(Vector S, Vector E, Vector P, float width) {
        Vector PS = UtilsFX.Sub(S, P);
        Vector SE = UtilsFX.Sub(E, S);
        Vector normal = UtilsFX.Cross(PS, SE);
        normal = normal.normalize();
        Vector half = UtilsFX.Mul(normal, width);
        Vector p1 = UtilsFX.Add(S, half);
        Vector p2 = UtilsFX.Sub(S, half);
        Vector p3 = UtilsFX.Add(E, half);
        Vector p4 = UtilsFX.Sub(E, half);
        UtilsFX.drawQuad(Tessellator.func_178181_a(), p1, p3, p4, p2);
    }

    public static void drawQuad(Tessellator tessellator, Vector p1, Vector p2, Vector p3, Vector p4) {
        tessellator.func_178180_c().func_178985_a((double)p1.getX(), (double)p1.getY(), (double)p1.getZ(), 0.0, 0.0);
        tessellator.func_178180_c().func_178985_a((double)p2.getX(), (double)p2.getY(), (double)p2.getZ(), 1.0, 0.0);
        tessellator.func_178180_c().func_178985_a((double)p3.getX(), (double)p3.getY(), (double)p3.getZ(), 1.0, 1.0);
        tessellator.func_178180_c().func_178985_a((double)p4.getX(), (double)p4.getY(), (double)p4.getZ(), 0.0, 1.0);
    }

    private static Vector Cross(Vector a, Vector b) {
        float x = a.y * b.z - a.z * b.y;
        float y = a.z * b.x - a.x * b.z;
        float z = a.x * b.y - a.y * b.x;
        return new Vector(x, y, z);
    }

    public static Vector Sub(Vector a, Vector b) {
        return new Vector(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    private static Vector Add(Vector a, Vector b) {
        return new Vector(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    private static Vector Mul(Vector a, float f) {
        return new Vector(a.x * f, a.y * f, a.z * f);
    }

    public static void renderItemIn2D(String sprite, float thickness) {
        float f9;
        float f8;
        float f7;
        int k;
        GL11.glPushMatrix();
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_147117_R().func_110572_b(sprite);
        float f1 = icon.func_94212_f();
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94209_e();
        float f4 = icon.func_94210_h();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_178970_b();
        tessellator.func_178180_c().func_178980_d(0.0f, 0.0f, 1.0f);
        tessellator.func_178180_c().func_178985_a(0.0, 0.0, 0.0, (double)f1, (double)f4);
        tessellator.func_178180_c().func_178985_a(1.0, 0.0, 0.0, (double)f3, (double)f4);
        tessellator.func_178180_c().func_178985_a(1.0, 1.0, 0.0, (double)f3, (double)f2);
        tessellator.func_178180_c().func_178985_a(0.0, 1.0, 0.0, (double)f1, (double)f2);
        tessellator.func_78381_a();
        tessellator.func_178180_c().func_178970_b();
        tessellator.func_178180_c().func_178980_d(0.0f, 0.0f, -1.0f);
        tessellator.func_178180_c().func_178985_a(0.0, 1.0, (double)(0.0f - thickness), (double)f1, (double)f2);
        tessellator.func_178180_c().func_178985_a(1.0, 1.0, (double)(0.0f - thickness), (double)f3, (double)f2);
        tessellator.func_178180_c().func_178985_a(1.0, 0.0, (double)(0.0f - thickness), (double)f3, (double)f4);
        tessellator.func_178180_c().func_178985_a(0.0, 0.0, (double)(0.0f - thickness), (double)f1, (double)f4);
        tessellator.func_78381_a();
        float f5 = 0.5f * (f1 - f3) / (float)icon.func_94211_a();
        float f6 = 0.5f * (f4 - f2) / (float)icon.func_94216_b();
        tessellator.func_178180_c().func_178970_b();
        tessellator.func_178180_c().func_178980_d(-1.0f, 0.0f, 0.0f);
        for (k = 0; k < icon.func_94211_a(); ++k) {
            f7 = (float)k / (float)icon.func_94211_a();
            f8 = f1 + (f3 - f1) * f7 - f5;
            tessellator.func_178180_c().func_178985_a((double)f7, 0.0, (double)(0.0f - thickness), (double)f8, (double)f4);
            tessellator.func_178180_c().func_178985_a((double)f7, 0.0, 0.0, (double)f8, (double)f4);
            tessellator.func_178180_c().func_178985_a((double)f7, 1.0, 0.0, (double)f8, (double)f2);
            tessellator.func_178180_c().func_178985_a((double)f7, 1.0, (double)(0.0f - thickness), (double)f8, (double)f2);
        }
        tessellator.func_78381_a();
        tessellator.func_178180_c().func_178970_b();
        tessellator.func_178180_c().func_178980_d(1.0f, 0.0f, 0.0f);
        for (k = 0; k < icon.func_94211_a(); ++k) {
            f7 = (float)k / (float)icon.func_94211_a();
            f8 = f1 + (f3 - f1) * f7 - f5;
            f9 = f7 + 1.0f / (float)icon.func_94211_a();
            tessellator.func_178180_c().func_178985_a((double)f9, 1.0, (double)(0.0f - thickness), (double)f8, (double)f2);
            tessellator.func_178180_c().func_178985_a((double)f9, 1.0, 0.0, (double)f8, (double)f2);
            tessellator.func_178180_c().func_178985_a((double)f9, 0.0, 0.0, (double)f8, (double)f4);
            tessellator.func_178180_c().func_178985_a((double)f9, 0.0, (double)(0.0f - thickness), (double)f8, (double)f4);
        }
        tessellator.func_78381_a();
        tessellator.func_178180_c().func_178970_b();
        tessellator.func_178180_c().func_178980_d(0.0f, 1.0f, 0.0f);
        for (k = 0; k < icon.func_94216_b(); ++k) {
            f7 = (float)k / (float)icon.func_94216_b();
            f8 = f4 + (f2 - f4) * f7 - f6;
            f9 = f7 + 1.0f / (float)icon.func_94216_b();
            tessellator.func_178180_c().func_178985_a(0.0, (double)f9, 0.0, (double)f1, (double)f8);
            tessellator.func_178180_c().func_178985_a(1.0, (double)f9, 0.0, (double)f3, (double)f8);
            tessellator.func_178180_c().func_178985_a(1.0, (double)f9, (double)(0.0f - thickness), (double)f3, (double)f8);
            tessellator.func_178180_c().func_178985_a(0.0, (double)f9, (double)(0.0f - thickness), (double)f1, (double)f8);
        }
        tessellator.func_78381_a();
        tessellator.func_178180_c().func_178970_b();
        tessellator.func_178180_c().func_178980_d(0.0f, -1.0f, 0.0f);
        for (k = 0; k < icon.func_94216_b(); ++k) {
            f7 = (float)k / (float)icon.func_94216_b();
            f8 = f4 + (f2 - f4) * f7 - f6;
            tessellator.func_178180_c().func_178985_a(1.0, (double)f7, 0.0, (double)f3, (double)f8);
            tessellator.func_178180_c().func_178985_a(0.0, (double)f7, 0.0, (double)f1, (double)f8);
            tessellator.func_178180_c().func_178985_a(0.0, (double)f7, (double)(0.0f - thickness), (double)f1, (double)f8);
            tessellator.func_178180_c().func_178985_a(1.0, (double)f7, (double)(0.0f - thickness), (double)f3, (double)f8);
        }
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    public static class Vector {
        public final float x;
        public final float y;
        public final float z;

        public Vector(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float getZ() {
            return this.z;
        }

        public float norm() {
            return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        }

        public Vector normalize() {
            float n = this.norm();
            return new Vector(this.x / n, this.y / n, this.z / n);
        }
    }
}

