/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.world.eldritch;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.client.fx.particles.FXSpark;
import thaumcraft.common.blocks.BlockTCDevice;
import thaumcraft.common.tiles.devices.TileAuraTotem;
import thaumcraft.common.tiles.misc.TileEldritchAltar;
import thaumcraft.common.tiles.misc.TileEldritchCap;
import thaumcraft.common.tiles.misc.TileEldritchCrabSpawner;
import thaumcraft.common.tiles.misc.TileEldritchLock;
import thaumcraft.common.tiles.misc.TileEldritchObelisk;
import thaumcraft.common.tiles.misc.TileEldritchPortal;

public class BlockEldritch
extends BlockTCDevice {
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", EldritchType.class);

    public BlockEldritch() {
        super(Material.field_151576_e, TileEldritchAltar.class);
        this.func_149752_b(20000.0f);
        this.func_149711_c(50.0f);
        this.func_149672_a(Block.field_149769_e);
        this.func_149675_a(true);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.func_149713_g(0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)((Object)EldritchType.ALTAR)));
        this.func_149647_a(null);
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        switch (meta) {
            case 0: {
                return new TileEldritchAltar();
            }
            case 1: {
                return new TileEldritchCap();
            }
            case 2: {
                return new TileEldritchObelisk();
            }
            case 4: {
                return new TileEldritchLock();
            }
            case 6: {
                return new TileEldritchPortal();
            }
            case 7: {
                return new TileEldritchCrabSpawner();
            }
        }
        return null;
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        return meta != 3 && meta != 5;
    }

    public boolean canCreatureSpawn(IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        return 8;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (!world.field_72995_K && meta > 1 && meta < 4) {
            for (int xx = pos.func_177958_n() - 3; xx <= pos.func_177958_n() + 3; ++xx) {
                for (int yy = pos.func_177956_o() - 2; yy <= pos.func_177956_o() + 2; ++yy) {
                    for (int zz = pos.func_177952_p() - 3; zz <= pos.func_177952_p() + 3; ++zz) {
                        if (world.func_180495_p(new BlockPos(xx, yy, zz)).func_177230_c() != this) continue;
                        IBlockState bs = world.func_180495_p(new BlockPos(xx, yy, zz));
                        int m = bs.func_177230_c().func_176201_c(bs);
                        if (meta <= 1 || meta >= 4) continue;
                        world.func_175698_g(new BlockPos(xx, yy, zz));
                    }
                }
            }
            world.func_72876_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 1.0f, false);
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)EldritchType.values()[meta]));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EldritchType)((Object)state.func_177229_b((IProperty)TYPE))).ordinal();
    }

    @Override
    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{TYPE});
    }

    @Override
    public String getStateName(IBlockState state, boolean fullName) {
        EldritchType type = (EldritchType)((Object)state.func_177229_b((IProperty)TYPE));
        return (fullName ? "eldritch_" : "") + type.func_176610_l();
    }

    @Override
    public IProperty[] getProperties() {
        return new IProperty[]{TYPE};
    }

    @Override
    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile instanceof TileAuraTotem) {
            ((TileAuraTotem)tile).checkPoles();
            worldIn.func_175641_c(pos, (Block)this, 1, 1);
        } else {
            worldIn.func_180496_d(pos.func_177984_a(), (Block)this);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEldritchAltar tile;
        TileEntity te;
        int metadata = state.func_177230_c().func_176201_c(state);
        if (metadata == 0 && !world.field_72995_K && !player.func_70093_af() && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ItemsTC.eldritchEye && (te = world.func_175625_s(pos)) != null && te instanceof TileEldritchAltar && (tile = (TileEldritchAltar)te).getEyes() < 4) {
            if (tile.getEyes() >= 2) {
                tile.setSpawner(true);
                tile.setSpawnType((byte)1);
            }
            tile.setEyes((byte)(tile.getEyes() + 1));
            tile.checkForMaze();
            --player.func_70694_bm().field_77994_a;
            tile.func_70296_d();
            world.func_175689_h(pos);
            world.func_72908_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), "thaumcraft:crystal", 0.2f, 1.0f);
        }
        if (metadata == 4 && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ItemsTC.runedTablet && (te = world.func_175625_s(pos)) != null && te instanceof TileEldritchLock && ((TileEldritchLock)te).count < 0) {
            ((TileEldritchLock)te).count = 0;
            te.func_70296_d();
            world.func_175689_h(pos);
            --player.func_70694_bm().field_77994_a;
            world.func_72908_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), "thaumcraft:runicShieldCharge", 1.0f, 1.0f);
        }
        return super.func_180639_a(world, pos, state, player, side, hitX, hitY, hitZ);
    }

    public float func_176195_g(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return super.func_176195_g(worldIn, pos);
        }
        return (EldritchType)((Object)state.func_177229_b((IProperty)TYPE)) == EldritchType.LOCK || (EldritchType)((Object)state.func_177229_b((IProperty)TYPE)) == EldritchType.DOOR || (EldritchType)((Object)state.func_177229_b((IProperty)TYPE)) == EldritchType.TELEPORTER ? -1.0f : ((EldritchType)((Object)state.func_177229_b((IProperty)TYPE)) == EldritchType.CRABSPAWNER ? 50.0f : super.func_176195_g(worldIn, pos));
    }

    public AxisAlignedBB func_180646_a(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        return (EldritchType)((Object)state.func_177229_b((IProperty)TYPE)) == EldritchType.TELEPORTER ? AxisAlignedBB.func_178781_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0) : super.func_180646_a(worldIn, pos);
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        return (EldritchType)((Object)state.func_177229_b((IProperty)TYPE)) == EldritchType.TELEPORTER ? null : super.func_180640_a(worldIn, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if ((EldritchType)((Object)state.func_177229_b((IProperty)TYPE)) == EldritchType.LOCK) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (te == null || !(te instanceof TileEldritchLock) || ((TileEldritchLock)te).count < 0) {
                return;
            }
            FXSpark ef = new FXSpark(worldIn, (float)pos.func_177958_n() + rand.nextFloat(), (float)pos.func_177956_o() + rand.nextFloat(), (float)pos.func_177952_p() + rand.nextFloat(), 0.5f);
            ef.func_70538_b(0.65f + rand.nextFloat() * 0.1f, 1.0f, 1.0f);
            ef.func_82338_g(0.8f);
        }
    }

    public static enum EldritchType implements IStringSerializable
    {
        ALTAR,
        CAP,
        OBELISK_BASE,
        OBELISK_BODY,
        LOCK,
        DOOR,
        TELEPORTER,
        CRABSPAWNER;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

