/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.config;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.BlockTC;
import thaumcraft.common.blocks.ItemBlockTC;
import thaumcraft.common.blocks.basic.BlockBannerTC;
import thaumcraft.common.blocks.basic.BlockBannerTCItem;
import thaumcraft.common.blocks.basic.BlockCandle;
import thaumcraft.common.blocks.basic.BlockCandleItem;
import thaumcraft.common.blocks.basic.BlockEtherealBloom;
import thaumcraft.common.blocks.basic.BlockFluidDeath;
import thaumcraft.common.blocks.basic.BlockFluidPure;
import thaumcraft.common.blocks.basic.BlockMetalTC;
import thaumcraft.common.blocks.basic.BlockNitor;
import thaumcraft.common.blocks.basic.BlockNitorItem;
import thaumcraft.common.blocks.basic.BlockPavingStone;
import thaumcraft.common.blocks.basic.BlockPillar;
import thaumcraft.common.blocks.basic.BlockPlanksTC;
import thaumcraft.common.blocks.basic.BlockStairsTC;
import thaumcraft.common.blocks.basic.BlockStoneSlabTC;
import thaumcraft.common.blocks.basic.BlockStoneSlabTCItem;
import thaumcraft.common.blocks.basic.BlockStoneTC;
import thaumcraft.common.blocks.basic.BlockTable;
import thaumcraft.common.blocks.basic.BlockTranslucent;
import thaumcraft.common.blocks.basic.BlockWoodSlabTC;
import thaumcraft.common.blocks.basic.BlockWoodSlabTCItem;
import thaumcraft.common.blocks.devices.BlockAlembic;
import thaumcraft.common.blocks.devices.BlockArcaneBore;
import thaumcraft.common.blocks.devices.BlockArcaneBoreBase;
import thaumcraft.common.blocks.devices.BlockArcaneEar;
import thaumcraft.common.blocks.devices.BlockArcaneWorkbench;
import thaumcraft.common.blocks.devices.BlockArcaneWorkbenchCharger;
import thaumcraft.common.blocks.devices.BlockAuraTotem;
import thaumcraft.common.blocks.devices.BlockBellows;
import thaumcraft.common.blocks.devices.BlockBrainBox;
import thaumcraft.common.blocks.devices.BlockCentrifuge;
import thaumcraft.common.blocks.devices.BlockCrucible;
import thaumcraft.common.blocks.devices.BlockCrystallizer;
import thaumcraft.common.blocks.devices.BlockDioptra;
import thaumcraft.common.blocks.devices.BlockHungryChest;
import thaumcraft.common.blocks.devices.BlockInfernalFurnace;
import thaumcraft.common.blocks.devices.BlockInfusionMatrix;
import thaumcraft.common.blocks.devices.BlockJar;
import thaumcraft.common.blocks.devices.BlockJarItem;
import thaumcraft.common.blocks.devices.BlockLamp;
import thaumcraft.common.blocks.devices.BlockLevitator;
import thaumcraft.common.blocks.devices.BlockMirror;
import thaumcraft.common.blocks.devices.BlockMirrorItem;
import thaumcraft.common.blocks.devices.BlockPedestal;
import thaumcraft.common.blocks.devices.BlockRechargePedestal;
import thaumcraft.common.blocks.devices.BlockRedstoneRelay;
import thaumcraft.common.blocks.devices.BlockResearchTable;
import thaumcraft.common.blocks.devices.BlockSmelter;
import thaumcraft.common.blocks.devices.BlockSmelterAux;
import thaumcraft.common.blocks.devices.BlockSpa;
import thaumcraft.common.blocks.devices.BlockThaumatorium;
import thaumcraft.common.blocks.devices.BlockTube;
import thaumcraft.common.blocks.devices.BlockWandWorkbench;
import thaumcraft.common.blocks.devices.BlockWaterJug;
import thaumcraft.common.blocks.misc.BlockBarrier;
import thaumcraft.common.blocks.misc.BlockEffect;
import thaumcraft.common.blocks.misc.BlockHole;
import thaumcraft.common.blocks.misc.BlockPlaceholder;
import thaumcraft.common.blocks.world.BlockLoot;
import thaumcraft.common.blocks.world.eldritch.BlockEldritch;
import thaumcraft.common.blocks.world.eldritch.BlockVacuum;
import thaumcraft.common.blocks.world.ore.BlockCrystal;
import thaumcraft.common.blocks.world.ore.BlockCrystalItem;
import thaumcraft.common.blocks.world.ore.BlockOreTC;
import thaumcraft.common.blocks.world.plants.BlockLeavesTC;
import thaumcraft.common.blocks.world.plants.BlockLeavesTCItem;
import thaumcraft.common.blocks.world.plants.BlockLogsTC;
import thaumcraft.common.blocks.world.plants.BlockPlantCinderpearl;
import thaumcraft.common.blocks.world.plants.BlockPlantShimmerleaf;
import thaumcraft.common.blocks.world.plants.BlockPlantVishroom;
import thaumcraft.common.blocks.world.plants.BlockSaplingTC;
import thaumcraft.common.blocks.world.plants.BlockSaplingTCItem;
import thaumcraft.common.blocks.world.taint.BlockFluxGoo;
import thaumcraft.common.blocks.world.taint.BlockTaint;
import thaumcraft.common.blocks.world.taint.BlockTaintDust;
import thaumcraft.common.blocks.world.taint.BlockTaintFeature;
import thaumcraft.common.blocks.world.taint.BlockTaintFibre;
import thaumcraft.common.blocks.world.taint.BlockTaintLog;
import thaumcraft.common.lib.CustomSoundType;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.tiles.TileOwned;
import thaumcraft.common.tiles.TilePlaceholder;
import thaumcraft.common.tiles.crafting.TileAlembic;
import thaumcraft.common.tiles.crafting.TileArcaneWorkbench;
import thaumcraft.common.tiles.crafting.TileArcaneWorkbenchCharger;
import thaumcraft.common.tiles.crafting.TileCrucible;
import thaumcraft.common.tiles.crafting.TileFocalManipulator;
import thaumcraft.common.tiles.crafting.TileInfusionMatrix;
import thaumcraft.common.tiles.crafting.TilePedestal;
import thaumcraft.common.tiles.crafting.TileResearchTable;
import thaumcraft.common.tiles.crafting.TileSmelter;
import thaumcraft.common.tiles.devices.TileArcaneBore;
import thaumcraft.common.tiles.devices.TileArcaneBoreBase;
import thaumcraft.common.tiles.devices.TileArcaneEar;
import thaumcraft.common.tiles.devices.TileAuraTotemPole;
import thaumcraft.common.tiles.devices.TileAuraTotemPull;
import thaumcraft.common.tiles.devices.TileAuraTotemPush;
import thaumcraft.common.tiles.devices.TileBellows;
import thaumcraft.common.tiles.devices.TileDioptra;
import thaumcraft.common.tiles.devices.TileHungryChest;
import thaumcraft.common.tiles.devices.TileInfernalFurnace;
import thaumcraft.common.tiles.devices.TileJarBrain;
import thaumcraft.common.tiles.devices.TileLampArcane;
import thaumcraft.common.tiles.devices.TileLampFertility;
import thaumcraft.common.tiles.devices.TileLampGrowth;
import thaumcraft.common.tiles.devices.TileLevitator;
import thaumcraft.common.tiles.devices.TileMirror;
import thaumcraft.common.tiles.devices.TileMirrorEssentia;
import thaumcraft.common.tiles.devices.TileRechargePedestal;
import thaumcraft.common.tiles.devices.TileRedstoneRelay;
import thaumcraft.common.tiles.devices.TileSpa;
import thaumcraft.common.tiles.devices.TileThaumatorium;
import thaumcraft.common.tiles.devices.TileThaumatoriumTop;
import thaumcraft.common.tiles.devices.TileWaterJug;
import thaumcraft.common.tiles.essentia.TileCentrifuge;
import thaumcraft.common.tiles.essentia.TileCrystallizer;
import thaumcraft.common.tiles.essentia.TileJarFillable;
import thaumcraft.common.tiles.essentia.TileJarFillableVoid;
import thaumcraft.common.tiles.essentia.TileTube;
import thaumcraft.common.tiles.essentia.TileTubeBuffer;
import thaumcraft.common.tiles.essentia.TileTubeFilter;
import thaumcraft.common.tiles.essentia.TileTubeOneway;
import thaumcraft.common.tiles.essentia.TileTubeRestrict;
import thaumcraft.common.tiles.essentia.TileTubeValve;
import thaumcraft.common.tiles.misc.TileBanner;
import thaumcraft.common.tiles.misc.TileBarrierStone;
import thaumcraft.common.tiles.misc.TileEldritchAltar;
import thaumcraft.common.tiles.misc.TileEldritchCap;
import thaumcraft.common.tiles.misc.TileEldritchCrabSpawner;
import thaumcraft.common.tiles.misc.TileEldritchLock;
import thaumcraft.common.tiles.misc.TileEldritchObelisk;
import thaumcraft.common.tiles.misc.TileEldritchPortal;
import thaumcraft.common.tiles.misc.TileEtherealBloom;
import thaumcraft.common.tiles.misc.TileHole;
import thaumcraft.common.tiles.misc.TileNitor;

public class ConfigBlocks {
    public static void init() {
        ConfigBlocks.initializeBlocks();
        ConfigBlocks.registerTileEntities();
        BlocksTC.oreAmber.setHarvestLevel("pickaxe", 1);
        BlocksTC.oreCinnabar.setHarvestLevel("pickaxe", 2);
        BlockUtils.portableHoleBlackList.add("minecraft:bed");
        BlockUtils.portableHoleBlackList.add("minecraft:piston");
        BlockUtils.portableHoleBlackList.add("minecraft:piston_head");
        BlockUtils.portableHoleBlackList.add("minecraft:sticky_piston");
        BlockUtils.portableHoleBlackList.add("minecraft:piston_extension");
        BlockUtils.portableHoleBlackList.add("minecraft:wooden_door");
        BlockUtils.portableHoleBlackList.add("minecraft:spruce_door");
        BlockUtils.portableHoleBlackList.add("minecraft:birch_door");
        BlockUtils.portableHoleBlackList.add("minecraft:jungle_door");
        BlockUtils.portableHoleBlackList.add("minecraft:acacia_door");
        BlockUtils.portableHoleBlackList.add("minecraft:dark_oak_door");
        BlockUtils.portableHoleBlackList.add("minecraft:iron_door");
        BlockUtils.portableHoleBlackList.add("thaumcraft:infernal_furnace");
    }

    private static void initializeBlocks() {
        BlocksTC.oreAmber = ConfigBlocks.registerBlock(new BlockOreTC(), "ore_amber").func_149711_c(1.25f);
        BlocksTC.oreCinnabar = ConfigBlocks.registerBlock(new BlockOreTC(), "ore_cinnabar").func_149711_c(2.0f);
        BlocksTC.crystalAir = ConfigBlocks.registerBlockBase(new BlockCrystal(Aspect.AIR), "crystal_aer", BlockCrystalItem.class);
        BlocksTC.crystalFire = ConfigBlocks.registerBlockBase(new BlockCrystal(Aspect.FIRE), "crystal_ignis", BlockCrystalItem.class);
        BlocksTC.crystalWater = ConfigBlocks.registerBlockBase(new BlockCrystal(Aspect.WATER), "crystal_aqua", BlockCrystalItem.class);
        BlocksTC.crystalEarth = ConfigBlocks.registerBlockBase(new BlockCrystal(Aspect.EARTH), "crystal_terra", BlockCrystalItem.class);
        BlocksTC.crystalOrder = ConfigBlocks.registerBlockBase(new BlockCrystal(Aspect.ORDER), "crystal_ordo", BlockCrystalItem.class);
        BlocksTC.crystalEntropy = ConfigBlocks.registerBlockBase(new BlockCrystal(Aspect.ENTROPY), "crystal_perditio", BlockCrystalItem.class);
        BlocksTC.crystalTaint = ConfigBlocks.registerBlockBase(new BlockCrystal(Aspect.FLUX), "crystal_vitium", BlockCrystalItem.class);
        BlocksTC.log = ConfigBlocks.registerBlock(new BlockLogsTC(), "log");
        BlocksTC.leaf = ConfigBlocks.registerBlockBase((Block)new BlockLeavesTC(), "leaf", BlockLeavesTCItem.class);
        BlocksTC.plank = ConfigBlocks.registerBlock(new BlockPlanksTC(), "plank");
        BlocksTC.stairsGreatwood = ConfigBlocks.registerBlockBase((Block)new BlockStairsTC(BlocksTC.plank.func_176223_P().func_177226_a((IProperty)BlockPlanksTC.VARIANT, (Comparable)((Object)BlockPlanksTC.PlankType.GREATWOOD))), "greatwood_stairs");
        BlocksTC.stairsSilverwood = ConfigBlocks.registerBlockBase((Block)new BlockStairsTC(BlocksTC.plank.func_176223_P().func_177226_a((IProperty)BlockPlanksTC.VARIANT, (Comparable)((Object)BlockPlanksTC.PlankType.SILVERWOOD))), "silverwood_stairs");
        BlocksTC.slabWood = new BlockWoodSlabTC().func_149711_c(2.0f).func_149752_b(5.0f).func_149672_a(Block.field_149766_f).func_149663_c("slab_wood");
        BlocksTC.doubleSlabWood = new BlockWoodSlabTC().func_149711_c(2.0f).func_149752_b(5.0f).func_149672_a(Block.field_149766_f).func_149663_c("slab_wood_double");
        GameRegistry.registerBlock((Block)BlocksTC.slabWood, BlockWoodSlabTCItem.class, (String)"slab_wood");
        GameRegistry.registerBlock((Block)BlocksTC.doubleSlabWood, (String)"slab_wood_double");
        BlocksTC.stone = ConfigBlocks.registerBlock(new BlockStoneTC(), "stone");
        BlocksTC.stairsArcane = ConfigBlocks.registerBlockBase((Block)new BlockStairsTC(BlocksTC.stone.func_176223_P().func_177226_a((IProperty)BlockStoneTC.VARIANT, (Comparable)((Object)BlockStoneTC.StoneType.ARCANE))), "arcane_stairs");
        BlocksTC.stairsArcaneBrick = ConfigBlocks.registerBlockBase((Block)new BlockStairsTC(BlocksTC.stone.func_176223_P().func_177226_a((IProperty)BlockStoneTC.VARIANT, (Comparable)((Object)BlockStoneTC.StoneType.ARCANE_BRICK))), "arcane_brick_stairs");
        BlocksTC.stairsAncient = ConfigBlocks.registerBlockBase((Block)new BlockStairsTC(BlocksTC.stone.func_176223_P().func_177226_a((IProperty)BlockStoneTC.VARIANT, (Comparable)((Object)BlockStoneTC.StoneType.ANCIENT))), "ancient_stairs");
        BlocksTC.slabStone = new BlockStoneSlabTC().func_149711_c(2.0f).func_149752_b(10.0f).func_149672_a(Block.field_149780_i).func_149663_c("slab_stone");
        BlocksTC.doubleSlabStone = new BlockStoneSlabTC().func_149711_c(2.0f).func_149752_b(10.0f).func_149672_a(Block.field_149780_i).func_149663_c("slab_stone_double");
        GameRegistry.registerBlock((Block)BlocksTC.slabStone, BlockStoneSlabTCItem.class, (String)"slab_stone");
        GameRegistry.registerBlock((Block)BlocksTC.doubleSlabStone, (String)"slab_stone_double");
        BlocksTC.sapling = new BlockSaplingTC().func_149663_c("sapling");
        GameRegistry.registerBlock((Block)BlocksTC.sapling, BlockSaplingTCItem.class, (String)"sapling");
        BlocksTC.shimmerleaf = ConfigBlocks.registerBlockBase((Block)new BlockPlantShimmerleaf(), "shimmerleaf");
        BlocksTC.cinderpearl = ConfigBlocks.registerBlockBase((Block)new BlockPlantCinderpearl(), "cinderpearl");
        BlocksTC.vishroom = ConfigBlocks.registerBlockBase((Block)new BlockPlantVishroom(), "vishroom");
        BlocksTC.bloom = ConfigBlocks.registerBlockBase((Block)new BlockEtherealBloom(), "bloom");
        BlocksTC.translucent = ConfigBlocks.registerBlock(new BlockTranslucent(), "translucent");
        BlocksTC.fleshBlock = ConfigBlocks.registerBlock(new BlockTC(Material.field_151583_m), "flesh_block").func_149672_a((Block.SoundType)new CustomSoundType("gore", 0.5f, 0.8f)).func_149711_c(0.25f);
        BlocksTC.lootCrate = ConfigBlocks.registerBlock(new BlockLoot(Material.field_151575_d), "loot_crate").func_149672_a(Block.field_149766_f);
        BlocksTC.lootUrn = ConfigBlocks.registerBlock(new BlockLoot(Material.field_151576_e), "loot_urn").func_149672_a((Block.SoundType)new CustomSoundType("urnbreak", 1.0f, 0.7f));
        BlocksTC.taintFibre = ConfigBlocks.registerBlockBase(new BlockTaintFibre(), "taint_fibre");
        BlocksTC.taintBlock = ConfigBlocks.registerBlock(new BlockTaint(), "taint");
        BlocksTC.taintFeature = ConfigBlocks.registerBlock(new BlockTaintFeature(), "taint_feature");
        BlocksTC.taintLog = ConfigBlocks.registerBlock(new BlockTaintLog(), "taint_log");
        BlocksTC.eldritch = ConfigBlocks.registerBlock(new BlockEldritch(), "eldritch");
        BlocksTC.tableWood = ConfigBlocks.registerBlock(new BlockTable(Material.field_151575_d), "table_wood").func_149672_a(Block.field_149766_f).func_149711_c(2.0f);
        BlocksTC.tableStone = ConfigBlocks.registerBlock(new BlockTable(Material.field_151576_e), "table_stone").func_149672_a(Block.field_149769_e).func_149711_c(2.5f);
        BlocksTC.candle = ConfigBlocks.registerBlock(new BlockCandle(), "candle", BlockCandleItem.class);
        BlocksTC.nitor = ConfigBlocks.registerBlock(new BlockNitor(), "nitor", BlockNitorItem.class);
        BlocksTC.pedestal = ConfigBlocks.registerBlock(new BlockPedestal(), "pedestal");
        BlocksTC.banner = ConfigBlocks.registerBlock(new BlockBannerTC(), "banner", BlockBannerTCItem.class);
        BlocksTC.metal = ConfigBlocks.registerBlock(new BlockMetalTC(), "metal");
        BlocksTC.pavingStone = ConfigBlocks.registerBlock(new BlockPavingStone(), "paving_stone");
        BlocksTC.barrier = ConfigBlocks.registerBlockBase(new BlockBarrier(), "barrier");
        BlocksTC.pillar = ConfigBlocks.registerBlock(new BlockPillar(), "pillar");
        BlocksTC.redstoneRelay = ConfigBlocks.registerBlock(new BlockRedstoneRelay(), "redstone_relay");
        BlocksTC.researchTable = ConfigBlocks.registerBlock(new BlockResearchTable(), "research_table");
        BlocksTC.arcaneWorkbench = ConfigBlocks.registerBlock(new BlockArcaneWorkbench(), "arcane_workbench");
        BlocksTC.arcaneWorkbenchCharger = ConfigBlocks.registerBlock(new BlockArcaneWorkbenchCharger(), "arcane_workbench_charger");
        BlocksTC.crucible = ConfigBlocks.registerBlock(new BlockCrucible(), "crucible");
        BlocksTC.arcaneEar = ConfigBlocks.registerBlock(new BlockArcaneEar(), "arcane_ear");
        BlocksTC.lampArcane = ConfigBlocks.registerBlock(new BlockLamp(TileLampArcane.class), "lamp_arcane");
        BlocksTC.lampFertility = ConfigBlocks.registerBlock(new BlockLamp(TileLampFertility.class), "lamp_fertility");
        BlocksTC.lampGrowth = ConfigBlocks.registerBlock(new BlockLamp(TileLampGrowth.class), "lamp_growth");
        BlocksTC.levitator = ConfigBlocks.registerBlock(new BlockLevitator(), "levitator");
        BlocksTC.crystallizer = ConfigBlocks.registerBlock(new BlockCrystallizer(), "crystallizer");
        BlocksTC.centrifuge = ConfigBlocks.registerBlock(new BlockCentrifuge(), "centrifuge");
        BlocksTC.bellows = ConfigBlocks.registerBlock(new BlockBellows(), "bellows");
        BlocksTC.smelterBasic = ConfigBlocks.registerBlock(new BlockSmelter(), "smelter_basic");
        BlocksTC.smelterThaumium = ConfigBlocks.registerBlock(new BlockSmelter(), "smelter_thaumium");
        BlocksTC.smelterVoid = ConfigBlocks.registerBlock(new BlockSmelter(), "smelter_void");
        BlocksTC.smelterAux = ConfigBlocks.registerBlock(new BlockSmelterAux(), "smelter_aux");
        BlocksTC.alembic = ConfigBlocks.registerBlock(new BlockAlembic(), "alembic");
        BlocksTC.dioptra = ConfigBlocks.registerBlock(new BlockDioptra(), "dioptra");
        BlocksTC.rechargePedestal = ConfigBlocks.registerBlock(new BlockRechargePedestal(), "recharge_pedestal");
        BlocksTC.wandWorkbench = ConfigBlocks.registerBlock(new BlockWandWorkbench(), "wand_workbench");
        BlocksTC.hungryChest = ConfigBlocks.registerBlockBase((Block)new BlockHungryChest(), "hungry_chest");
        BlocksTC.tube = ConfigBlocks.registerBlock(new BlockTube(), "tube");
        BlocksTC.jar = ConfigBlocks.registerBlock(new BlockJar(), "jar", BlockJarItem.class);
        BlocksTC.infusionMatrix = ConfigBlocks.registerBlock(new BlockInfusionMatrix(), "infusion_matrix");
        BlocksTC.infernalFurnace = ConfigBlocks.registerBlock(new BlockInfernalFurnace(), "infernal_furnace");
        BlocksTC.waterJug = ConfigBlocks.registerBlock(new BlockWaterJug(), "water_jug");
        BlocksTC.arcaneBore = ConfigBlocks.registerBlock(new BlockArcaneBore(), "arcane_bore");
        BlocksTC.arcaneBoreBase = ConfigBlocks.registerBlock(new BlockArcaneBoreBase(), "arcane_bore_base");
        BlocksTC.thaumatorium = ConfigBlocks.registerBlock(new BlockThaumatorium(), "thaumatorium");
        BlocksTC.brainBox = ConfigBlocks.registerBlock(new BlockBrainBox(), "brain_box");
        BlocksTC.auraTotem = ConfigBlocks.registerBlock(new BlockAuraTotem(), "aura_totem");
        BlocksTC.spa = ConfigBlocks.registerBlock(new BlockSpa(), "spa");
        BlocksTC.mirror = new BlockMirror(TileMirror.class).func_149663_c("mirror");
        GameRegistry.registerBlock((Block)BlocksTC.mirror, BlockMirrorItem.class, (String)"mirror");
        BlocksTC.mirrorEssentia = new BlockMirror(TileMirrorEssentia.class).func_149663_c("mirror_essentia");
        GameRegistry.registerBlock((Block)BlocksTC.mirrorEssentia, BlockMirrorItem.class, (String)"mirror_essentia");
        FluidRegistry.registerFluid((Fluid)FluidFluxGoo.instance);
        BlocksTC.fluxGoo = new BlockFluxGoo();
        GameRegistry.registerBlock((Block)BlocksTC.fluxGoo, (String)"flux_goo");
        FluidRegistry.registerFluid((Fluid)FluidDeath.instance);
        BlocksTC.liquidDeath = new BlockFluidDeath();
        GameRegistry.registerBlock((Block)BlocksTC.liquidDeath, (String)"liquid_death");
        FluidRegistry.registerFluid((Fluid)FluidPure.instance);
        BlocksTC.purifyingFluid = new BlockFluidPure();
        GameRegistry.registerBlock((Block)BlocksTC.purifyingFluid, (String)"purifying_fluid");
        FluidRegistry.registerFluid((Fluid)FluidTaintDust.instance);
        BlocksTC.taintDust = new BlockTaintDust();
        GameRegistry.registerBlock((Block)BlocksTC.taintDust, (String)"taint_dust");
        BlocksTC.vacuum = ConfigBlocks.registerBlockBase(new BlockVacuum(), "vacuum");
        BlocksTC.hole = ConfigBlocks.registerBlockBase((Block)new BlockHole(), "hole");
        BlocksTC.effect = ConfigBlocks.registerBlock(new BlockEffect(), "effect");
        BlocksTC.placeholder = ConfigBlocks.registerBlock(new BlockPlaceholder(), "placeholder");
    }

    private static void registerTileEntities() {
        GameRegistry.registerTileEntity(TileArcaneEar.class, (String)"TileArcaneEar");
        GameRegistry.registerTileEntity(TileLevitator.class, (String)"TileLevitator");
        GameRegistry.registerTileEntity(TileDioptra.class, (String)"TileDioptra");
        GameRegistry.registerTileEntity(TileCrucible.class, (String)"TileCrucible");
        GameRegistry.registerTileEntity(TileArcaneWorkbench.class, (String)"TileArcaneWorkbench");
        GameRegistry.registerTileEntity(TileFocalManipulator.class, (String)"TileFocalManipulator");
        GameRegistry.registerTileEntity(TilePedestal.class, (String)"TilePedestal");
        GameRegistry.registerTileEntity(TileRechargePedestal.class, (String)"TileRechargePedestal");
        GameRegistry.registerTileEntity(TileArcaneWorkbenchCharger.class, (String)"TileArcaneWorkbenchCharger");
        GameRegistry.registerTileEntity(TileResearchTable.class, (String)"TileResearchTable");
        GameRegistry.registerTileEntity(TileTube.class, (String)"TileTube");
        GameRegistry.registerTileEntity(TileTubeValve.class, (String)"TileTubeValve");
        GameRegistry.registerTileEntity(TileTubeFilter.class, (String)"TileTubeFilter");
        GameRegistry.registerTileEntity(TileTubeRestrict.class, (String)"TileTubeRestrict");
        GameRegistry.registerTileEntity(TileTubeOneway.class, (String)"TileTubeOneway");
        GameRegistry.registerTileEntity(TileHungryChest.class, (String)"TileChestHungry");
        GameRegistry.registerTileEntity(TileTubeBuffer.class, (String)"TileTubeBuffer");
        GameRegistry.registerTileEntity(TileCentrifuge.class, (String)"TileCentrifuge");
        GameRegistry.registerTileEntity(TileCrystallizer.class, (String)"TileCrystallizer");
        GameRegistry.registerTileEntity(TileJarFillable.class, (String)"TileJar");
        GameRegistry.registerTileEntity(TileJarFillableVoid.class, (String)"TileJarVoid");
        GameRegistry.registerTileEntity(TileJarBrain.class, (String)"TileJarBrain");
        GameRegistry.registerTileEntity(TileBellows.class, (String)"TileBellows");
        GameRegistry.registerTileEntity(TileSmelter.class, (String)"TileSmelter");
        GameRegistry.registerTileEntity(TileAlembic.class, (String)"TileAlembic");
        GameRegistry.registerTileEntity(TileInfusionMatrix.class, (String)"TileInfusionMatrix");
        GameRegistry.registerTileEntity(TileWaterJug.class, (String)"TileWaterJug");
        GameRegistry.registerTileEntity(TileInfernalFurnace.class, (String)"TileInfernalFurnace");
        GameRegistry.registerTileEntity(TileArcaneBore.class, (String)"TileArcaneBore");
        GameRegistry.registerTileEntity(TileArcaneBoreBase.class, (String)"TileArcaneBoreBase");
        GameRegistry.registerTileEntity(TileThaumatorium.class, (String)"TileThaumatorium");
        GameRegistry.registerTileEntity(TileThaumatoriumTop.class, (String)"TileThaumatoriumTop");
        GameRegistry.registerTileEntity(TileAuraTotemPush.class, (String)"TileAuraTotemPush");
        GameRegistry.registerTileEntity(TileAuraTotemPull.class, (String)"TileAuraTotemPull");
        GameRegistry.registerTileEntity(TileAuraTotemPole.class, (String)"TileAuraTotemPole");
        GameRegistry.registerTileEntity(TileSpa.class, (String)"TileSpa");
        GameRegistry.registerTileEntity(TileLampGrowth.class, (String)"TileLampGrowth");
        GameRegistry.registerTileEntity(TileLampArcane.class, (String)"TileLampArcane");
        GameRegistry.registerTileEntity(TileLampFertility.class, (String)"TileLampFertility");
        GameRegistry.registerTileEntity(TileMirror.class, (String)"TileMirror");
        GameRegistry.registerTileEntity(TileMirrorEssentia.class, (String)"TileMirrorEssentia");
        GameRegistry.registerTileEntity(TileRedstoneRelay.class, (String)"TileRedstoneRelay");
        GameRegistry.registerTileEntity(TilePlaceholder.class, (String)"TilePlaceholder");
        GameRegistry.registerTileEntity(TileHole.class, (String)"TileHole");
        GameRegistry.registerTileEntity(TileNitor.class, (String)"TileNitor");
        GameRegistry.registerTileEntity(TileEtherealBloom.class, (String)"TileEtherealBloom");
        GameRegistry.registerTileEntity(TileBanner.class, (String)"TileBanner");
        GameRegistry.registerTileEntity(TileBarrierStone.class, (String)"TileBarrierStone");
        GameRegistry.registerTileEntity(TileEldritchPortal.class, (String)"TileEldritchPortal");
        GameRegistry.registerTileEntity(TileEldritchLock.class, (String)"TileEldritchLock");
        GameRegistry.registerTileEntity(TileEldritchAltar.class, (String)"TileEldritchAltar");
        GameRegistry.registerTileEntity(TileEldritchObelisk.class, (String)"TileEldritchObelisk");
        GameRegistry.registerTileEntity(TileEldritchCap.class, (String)"TileEldritchCap");
        GameRegistry.registerTileEntity(TileEldritchCrabSpawner.class, (String)"TileEldritchCrabSpawner");
        GameRegistry.registerTileEntity(TileOwned.class, (String)"TileOwned");
    }

    private static Block registerBlock(BlockTC block, String name) {
        return ConfigBlocks.registerBlock(block, name, null);
    }

    private static Block registerBlock(BlockTC block, String name, Class ib) {
        block.func_149663_c(name);
        if (ib != null && !block.defineVariantsForItemBlock()) {
            GameRegistry.registerBlock((Block)block, (Class)ib, (String)name);
            Thaumcraft.proxy.registerVariantName(Item.func_150898_a((Block)block), name);
        } else if (block.hasProperties()) {
            Class clazz = ItemBlockTC.class;
            if (ib != null) {
                clazz = ib;
            }
            GameRegistry.registerBlock((Block)block, (Class)clazz, (String)name);
            for (IBlockState state : block.states) {
                String stateName = block.getStateName(state, true);
                Thaumcraft.proxy.registerVariantName(Item.func_150898_a((Block)block), stateName);
                Thaumcraft.proxy.registerBlockMesh(block, block.func_176201_c(state), stateName);
            }
        } else {
            GameRegistry.registerBlock((Block)block, (String)name);
            Thaumcraft.proxy.registerVariantName(Item.func_150898_a((Block)block), name);
            Thaumcraft.proxy.registerBlockMesh(block, 0, name);
        }
        return block;
    }

    private static Block registerBlockBase(Block block, String name) {
        return ConfigBlocks.registerBlockBase(block, name, null);
    }

    private static Block registerBlockBase(Block block, String name, Class ib) {
        block.func_149663_c(name);
        if (ib == null) {
            GameRegistry.registerBlock((Block)block, (String)name);
        } else {
            GameRegistry.registerBlock((Block)block, (Class)ib, (String)name);
        }
        Thaumcraft.proxy.registerVariantName(Item.func_150898_a((Block)block), name);
        Thaumcraft.proxy.registerBlockMesh(block, 0, name);
        return block;
    }

    public static final class FluidTaintDust
    extends Fluid {
        public static final String name = "taint_dust";
        public static final FluidTaintDust instance = new FluidTaintDust();

        private FluidTaintDust() {
            super(name, new ResourceLocation("thaumcraft:blocks/taint_dust"), new ResourceLocation("thaumcraft:blocks/taint_dust"));
            this.setViscosity(8000);
            this.setDensity(2000);
        }
    }

    public static final class FluidFluxGoo
    extends Fluid {
        public static final String name = "flux_goo";
        public static final FluidFluxGoo instance = new FluidFluxGoo();

        private FluidFluxGoo() {
            super(name, new ResourceLocation("thaumcraft:blocks/flux_goo"), new ResourceLocation("thaumcraft:blocks/flux_goo"));
            this.setViscosity(6000);
            this.setDensity(8);
        }
    }

    public static final class FluidDeath
    extends Fluid {
        public static final String name = "liquid_death";
        public static final FluidDeath instance = new FluidDeath();

        private FluidDeath() {
            super(name, new ResourceLocation("thaumcraft:blocks/animatedglow"), new ResourceLocation("thaumcraft:blocks/animatedglow"));
            this.setViscosity(1500);
            this.setRarity(EnumRarity.RARE);
        }

        public int getColor() {
            return -263978855;
        }
    }

    public static final class FluidPure
    extends Fluid {
        public static final String name = "purifying_fluid";
        public static final FluidPure instance = new FluidPure();

        private FluidPure() {
            super(name, new ResourceLocation("blocks/water_still"), new ResourceLocation("blocks/water_flow"));
            this.setLuminosity(5);
            this.setRarity(EnumRarity.RARE);
        }

        public int getColor() {
            return 2013252778;
        }
    }
}

