/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct;

import java.util.ArrayList;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemNameTag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.research.ResearchHelper;
import thaumcraft.api.wands.IWand;
import thaumcraft.client.fx.other.FXSonic;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.entities.construct.EntityOwnedConstruct;
import thaumcraft.common.entities.monster.EntityWisp;
import thaumcraft.common.lib.aura.AuraHandler;
import thaumcraft.common.lib.aura.EntityAuraNode;
import thaumcraft.common.lib.utils.EntityUtils;

public class EntityNodeMagnet
extends EntityOwnedConstruct {
    EntityAuraNode nodeTarget = null;
    float rs = 0.0f;
    public float rot = 0.0f;

    public EntityNodeMagnet(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 0.9f);
    }

    public EntityNodeMagnet(World worldIn, BlockPos pos) {
        this(worldIn);
        this.func_70080_a((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(19, (Object)0);
    }

    @Override
    public boolean func_142014_c(EntityLivingBase otherEntity) {
        return this.func_142012_a(otherEntity.func_96124_cp());
    }

    @Override
    public Team func_96124_cp() {
        EntityLivingBase entitylivingbase;
        if (this.isOwned() && (entitylivingbase = this.getOwnerEntity()) != null) {
            return entitylivingbase.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public float func_70047_e() {
        return 0.8125f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    @Override
    public void func_70071_h_() {
        ArrayList<Entity> list;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70177_z = this.field_70759_as;
            if (this.field_70173_aa % 50 == 0) {
                this.func_70691_i(1.0f);
                list = EntityUtils.getEntitiesInRange(this.field_70170_p, this.func_180425_c(), (Entity)this, EntityMob.class, 32.0);
                if (list != null) {
                    for (Entity e : list) {
                        EntityMob mob = (EntityMob)e;
                        if (!this.field_70146_Z.nextBoolean() || mob.func_70638_az() != null) continue;
                        mob.func_70624_b((EntityLivingBase)this);
                    }
                }
                if (this.getOwnerEntity() != null && this.getOwnerEntity() instanceof EntityPlayer && !ResearchHelper.isResearchComplete(this.getOwnerEntity().func_70005_c_(), "!NODEMAGNETDANGER")) {
                    ResearchHelper.completeResearch((EntityPlayer)this.getOwnerEntity(), "!NODEMAGNETDANGER");
                }
            }
            if (this.field_70173_aa % 10 == 0 && this.getCharge() < 10) {
                this.rechargeVis();
            }
        }
        if (this.nodeTarget != null && this.nodeTarget.field_70128_L) {
            this.nodeTarget = null;
        }
        if (this.nodeTarget != null && this.getCharge() > 0) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70671_ap().func_75650_a(this.nodeTarget.field_70165_t, this.nodeTarget.field_70163_u + (double)this.nodeTarget.func_70047_e(), this.nodeTarget.field_70161_v, 10.0f, (float)this.func_70646_bf());
            } else if (this.field_70173_aa % 10 == 0) {
                this.showFX();
            }
            double gap = this.func_70032_d(this.nodeTarget);
            if (gap >= 1.0 && gap <= 32.0) {
                double mx = this.field_70165_t - this.nodeTarget.field_70165_t;
                double my = this.field_70163_u - this.nodeTarget.field_70163_u;
                double mz = this.field_70161_v - this.nodeTarget.field_70161_v;
                this.nodeTarget.field_70159_w += (mx /= gap * (double)(200 + this.nodeTarget.getNodeSize() * 3));
                this.nodeTarget.field_70181_x += (my /= gap * (double)(200 + this.nodeTarget.getNodeSize() * 3));
                this.nodeTarget.field_70179_y += (mz /= gap * (double)(200 + this.nodeTarget.getNodeSize() * 3));
                if (!this.field_70170_p.field_72995_K) {
                    this.setCharge((byte)(this.getCharge() - 1));
                    if (this.field_70146_Z.nextFloat() < 0.01f) {
                        if (this.field_70146_Z.nextFloat() < 0.2f) {
                            EntityWisp wisp = new EntityWisp(this.field_70170_p);
                            wisp.func_70012_b(this.nodeTarget.field_70165_t, this.nodeTarget.field_70163_u, this.nodeTarget.field_70161_v, 0.0f, 0.0f);
                            wisp.setType(this.nodeTarget.getAspectTag());
                            this.field_70170_p.func_72838_d((Entity)wisp);
                        } else {
                            AuraHelper.pollute(this.field_70170_p, this.nodeTarget.func_180425_c(), 1, true);
                        }
                    }
                }
                this.rs += 0.36f;
            } else {
                this.nodeTarget = null;
            }
        }
        if (this.nodeTarget == null) {
            this.rs -= 0.5f;
        }
        if (this.nodeTarget == null && this.field_70173_aa % 20 == 0) {
            list = EntityUtils.getEntitiesInRange(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, (Entity)this, EntityAuraNode.class, 32.0);
            Entity closest = null;
            double d = Double.MAX_VALUE;
            for (Entity e : list) {
                double gap = this.func_70068_e(e);
                if (!(gap < d)) continue;
                d = gap;
                closest = e;
            }
            if (closest != null) {
                this.nodeTarget = (EntityAuraNode)closest;
            }
        }
        if (this.rs > 36.0f) {
            this.rs = 36.0f;
        }
        if (this.rs < 0.0f) {
            this.rs = 0.0f;
        }
        this.rot += this.rs;
        if (this.rot > 360.0f) {
            this.rot -= 360.0f;
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, "thaumcraft:pump", 0.7f, 1.0f, false);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void showFX() {
        FXSonic fb = new FXSonic(Thaumcraft.proxy.getClientWorld(), this.nodeTarget.field_70165_t, this.nodeTarget.field_70163_u, this.nodeTarget.field_70161_v, (Entity)this, 10);
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fb);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.field_70177_z = (float)((double)this.field_70177_z + this.func_70681_au().nextGaussian() * 45.0);
        this.field_70125_A = (float)((double)this.field_70125_A + this.func_70681_au().nextGaussian() * 20.0);
        return super.func_70097_a(source, amount);
    }

    protected void rechargeVis() {
        for (Aspect aspect : Aspect.getPrimalAspects()) {
            if (!AuraHandler.drainAura(this.field_70170_p, this.func_180425_c(), aspect, 1)) continue;
            this.setCharge((byte)(this.getCharge() + 3));
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        if (player.func_70093_af() || player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemNameTag) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.isOwner((EntityLivingBase)player)) {
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IWand) {
                this.func_85030_a("thaumcraft:zap", 1.0f, 1.0f);
                this.func_70099_a(new ItemStack(ItemsTC.turretPlacer, 1, 2), 0.5f);
                this.func_70106_y();
                player.func_71038_i();
            }
            return true;
        }
        return super.func_70085_c(player);
    }

    public void func_70653_a(Entity p_70653_1_, float p_70653_2_, double p_70653_3_, double p_70653_5_) {
        super.func_70653_a(p_70653_1_, p_70653_2_, p_70653_3_ / 10.0, p_70653_5_ / 10.0);
        if (this.field_70181_x > 0.1) {
            this.field_70181_x = 0.1;
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_75692_b(19, (Object)nbt.func_74771_c("charge"));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("charge", this.field_70180_af.func_75683_a(19));
    }

    public byte getCharge() {
        return this.field_70180_af.func_75683_a(19);
    }

    public void setCharge(byte c) {
        this.field_70180_af.func_75692_b(19, (Object)c);
    }

    public void func_70091_d(double x, double y, double z) {
        super.func_70091_d(x / 5.0, y, z / 5.0);
        float c = (float)((Math.abs(this.field_70159_w) + Math.abs(this.field_70181_x) + Math.abs(this.field_70179_y)) / 3.0);
        if ((double)c > 0.25) {
            this.func_70076_C();
        } else if (this.field_70146_Z.nextFloat() < c / 20.0f) {
            this.func_70076_C();
        }
    }

    protected void func_70076_C() {
        this.func_70097_a(DamageSource.field_76380_i, 40.0f);
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        float b = (float)p_70628_2_ * 0.15f;
        if (this.field_70146_Z.nextFloat() < 0.2f + b) {
            this.func_70099_a(new ItemStack(ItemsTC.mind, 1, 1), 0.5f);
        }
        if (this.field_70146_Z.nextFloat() < 0.2f + b) {
            this.func_70099_a(new ItemStack(ItemsTC.morphicResonator), 0.5f);
        }
        if (this.field_70146_Z.nextFloat() < 0.2f + b) {
            this.func_70099_a(new ItemStack(BlocksTC.crystalAir), 0.5f);
        }
        if (this.field_70146_Z.nextFloat() < 0.2f + b) {
            this.func_70099_a(new ItemStack(BlocksTC.crystalFire), 0.5f);
        }
        if (this.field_70146_Z.nextFloat() < 0.2f + b) {
            this.func_70099_a(new ItemStack(BlocksTC.crystalWater), 0.5f);
        }
        if (this.field_70146_Z.nextFloat() < 0.2f + b) {
            this.func_70099_a(new ItemStack(BlocksTC.crystalEarth), 0.5f);
        }
        if (this.field_70146_Z.nextFloat() < 0.2f + b) {
            this.func_70099_a(new ItemStack(BlocksTC.crystalOrder), 0.5f);
        }
        if (this.field_70146_Z.nextFloat() < 0.2f + b) {
            this.func_70099_a(new ItemStack(BlocksTC.crystalEntropy), 0.5f);
        }
        if (this.field_70146_Z.nextFloat() < 0.2f + b) {
            this.func_70099_a(new ItemStack(BlocksTC.crystalTaint), 0.5f);
        }
        if (this.field_70146_Z.nextFloat() < 0.5f + b) {
            this.func_70099_a(new ItemStack(ItemsTC.gear), 0.5f);
        }
        if (this.field_70146_Z.nextFloat() < 0.5f + b) {
            this.func_70099_a(new ItemStack(ItemsTC.plate), 0.5f);
        }
        if (this.field_70146_Z.nextFloat() < 0.5f + b) {
            this.func_70099_a(new ItemStack(BlocksTC.plank), 0.5f);
        }
    }

    public int func_70646_bf() {
        return 20;
    }
}

