/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem;

import java.util.HashMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemsTC;

public class GolemBodyMaterial {
    protected final String name;
    protected final float speedBonus;
    protected final int armorBonus;
    protected final int hpBonus;
    protected final ItemStack component;
    private static HashMap<String, GolemBodyMaterial> golemMaterials;

    private GolemBodyMaterial(String name, float speedBonus, int armorBonus, int hpBonus, ItemStack component) {
        this.name = name;
        this.speedBonus = speedBonus;
        this.armorBonus = armorBonus;
        this.hpBonus = hpBonus;
        this.component = component;
    }

    public static GolemBodyMaterial get(String key) {
        return golemMaterials.get(key);
    }

    public static void register(String key, float speed, int armor, int hp, ItemStack component) {
        golemMaterials.put(key, new GolemBodyMaterial(key, speed, armor, hp, component));
    }

    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)("golem.material." + this.name));
    }

    public String getName() {
        return this.name;
    }

    public float getSpeedBonus() {
        return this.speedBonus;
    }

    public int getArmorBonus() {
        return this.armorBonus;
    }

    public int getHpBonus() {
        return this.hpBonus;
    }

    public void performTickEvent(EntityLivingBase entity) {
        if (this.name.equals("void") && entity.field_70173_aa % 20 == 0) {
            entity.func_70691_i(1.0f);
        }
    }

    static {
        GolemBodyMaterial.register("greatwood", 0.2f, 0, 0, new ItemStack(BlocksTC.plank));
        GolemBodyMaterial.register("iron", -0.2f, 3, 10, new ItemStack(ItemsTC.plate, 1, 1));
        GolemBodyMaterial.register("brass", 0.0f, 1, 8, new ItemStack(ItemsTC.plate, 1, 0));
        GolemBodyMaterial.register("thaumium", -0.2f, 5, 15, new ItemStack(ItemsTC.plate, 1, 2));
        GolemBodyMaterial.register("void", 0.1f, 2, 5, new ItemStack(ItemsTC.plate, 1, 3));
        golemMaterials = new HashMap();
    }
}

