/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.construct.golem.EntityThaumcraftGolem;
import thaumcraft.common.entities.construct.golem.TaskHandler;

public abstract class AIGoto
extends EntityAIBase {
    protected EntityThaumcraftGolem golem;
    protected int taskCounter = -1;
    protected int taskWaitOrder = 0;
    protected byte type = 0;
    protected int cooldown;
    protected double minDist = 3.5;
    private BlockPos prevRamble;

    public AIGoto(EntityThaumcraftGolem g, byte type) {
        this.golem = g;
        this.type = type;
        this.func_75248_a(5);
    }

    public boolean func_75250_a() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        this.cooldown = 10;
        if (this.golem.getTask() != null && this.golem.getTask().getType() == this.type && !this.golem.getTask().isSuspended()) {
            return true;
        }
        return this.findDestination();
    }

    public void func_75249_e() {
        this.moveTo();
        this.taskCounter = 0;
    }

    protected abstract void moveTo();

    public boolean func_75253_b() {
        return this.taskCounter >= -this.taskWaitOrder && this.taskCounter <= 1000 && !this.golem.getTask().isSuspended() && this.isValidDestination(this.golem.field_70170_p, this.golem.getTask().getPos());
    }

    public void func_75246_d() {
        double dist;
        double d = dist = this.golem.getTask().getType() == 0 ? this.golem.func_174831_c(this.golem.getTask().getPos()) : this.golem.func_70068_e(this.golem.getTask().getEntity());
        if (dist > this.minDist) {
            this.golem.getTask().setCompletion(false);
            ++this.taskCounter;
            if (this.taskCounter % 40 == 0) {
                if (this.prevRamble != null && this.prevRamble.equals((Object)this.golem.func_180425_c())) {
                    Vec3 vec3 = RandomPositionGenerator.func_75464_a((EntityCreature)this.golem, (int)16, (int)7, (Vec3)new Vec3((double)this.golem.getTask().getPos().func_177958_n(), (double)this.golem.getTask().getPos().func_177956_o(), (double)this.golem.getTask().getPos().func_177952_p()));
                    if (vec3 != null) {
                        this.golem.func_70661_as().func_75492_a(vec3.field_72450_a + 0.5, vec3.field_72448_b + 0.5, vec3.field_72449_c + 0.5, (double)this.golem.getGolemMoveSpeed());
                    }
                } else {
                    this.moveTo();
                }
                this.prevRamble = this.golem.func_180425_c();
            }
        } else {
            if (this.taskCounter >= 0) {
                this.taskCounter = 0;
            }
            --this.taskCounter;
            TaskHandler.completeTask(this.golem.getTask(), this.golem);
            this.taskWaitOrder = 0;
            if (this.golem.getTask().waitOnSuspension() && !this.golem.getTask().isSuspended()) {
                this.taskWaitOrder = 1000;
            }
        }
    }

    public void func_75251_c() {
        if (this.golem.getTask() != null) {
            if (!this.golem.getTask().isCompleted() && this.golem.getTask() != null && this.golem.getTask().isReserved() && Config.showGolemEmotes) {
                this.golem.field_70170_p.func_72960_a((Entity)this.golem, (byte)6);
            }
            if (this.golem.getTask().isCompleted() && this.golem.getTask() != null && !this.golem.getTask().isSuspended()) {
                if (this.golem.getTask().waitOnSuspension() && Config.showGolemEmotes) {
                    this.golem.field_70170_p.func_72960_a((Entity)this.golem, (byte)6);
                }
                this.golem.getTask().setSuspended(true);
            }
            this.golem.getTask().setReserved(false);
        }
    }

    protected abstract boolean findDestination();

    protected boolean isValidDestination(World world, BlockPos pos) {
        return true;
    }
}

