/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem.seals;

import java.lang.ref.WeakReference;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.common.entities.construct.golem.seals.ISeal;
import thaumcraft.common.entities.construct.golem.seals.SealHandler;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.misc.PacketSealToClient;

public class SealEntity {
    WeakReference<World> world;
    SealPos sealPos;
    ISeal seal;

    public SealEntity(World world) {
        this.world = new WeakReference<World>(world);
    }

    public SealEntity(World world, SealPos sealPos, ISeal seal) {
        this.world = new WeakReference<World>(world);
        this.sealPos = sealPos;
        this.seal = seal;
    }

    public void tickSealEntity() {
        if (this.seal != null && this.world.get() != null) {
            this.seal.tickSeal((World)this.world.get(), this.sealPos);
        }
    }

    public ISeal getSeal() {
        return this.seal;
    }

    public SealPos getSealPos() {
        return this.sealPos;
    }

    public void readNBT(NBTTagCompound nbt) {
        BlockPos p = BlockPos.func_177969_a((long)nbt.func_74763_f("pos"));
        EnumFacing face = EnumFacing.field_82609_l[nbt.func_74771_c("face")];
        this.sealPos = new SealPos(p, face);
        this.seal = SealHandler.getSeal(nbt.func_74779_i("type"));
        if (this.seal != null) {
            this.seal.readCustomNBT(nbt);
        }
    }

    public NBTTagCompound writeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74772_a("pos", this.sealPos.pos.func_177986_g());
        nbt.func_74774_a("face", (byte)this.sealPos.face.ordinal());
        nbt.func_74778_a("type", this.seal.getKey());
        if (this.seal != null) {
            this.seal.writeCustomNBT(nbt);
        }
        return nbt;
    }

    public void syncToClient() {
        if (this.world.get() != null && !((World)this.world.get()).field_72995_K) {
            PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketSealToClient(this), ((World)this.world.get()).field_73011_w.func_177502_q());
        }
    }

    public static class SealPos
    implements Comparable {
        public BlockPos pos;
        public EnumFacing face;

        public SealPos(BlockPos pos, EnumFacing face) {
            this.pos = pos;
            this.face = face;
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (!(p_equals_1_ instanceof SealPos)) {
                return false;
            }
            SealPos sp = (SealPos)p_equals_1_;
            return this.pos.func_177958_n() != sp.pos.func_177958_n() ? false : (this.pos.func_177956_o() != sp.pos.func_177956_o() ? false : (this.pos.func_177952_p() != sp.pos.func_177952_p() ? false : this.face == sp.face));
        }

        public int compareTo(SealPos sp) {
            return this.face == sp.face ? (this.pos.func_177956_o() == sp.pos.func_177956_o() ? (this.pos.func_177952_p() == sp.pos.func_177952_p() ? this.pos.func_177958_n() - sp.pos.func_177958_n() : this.pos.func_177952_p() - sp.pos.func_177952_p()) : this.pos.func_177956_o() - sp.pos.func_177956_o()) : this.face.ordinal() - sp.face.ordinal();
        }

        public int compareTo(Object p_compareTo_1_) {
            return this.compareTo((SealPos)p_compareTo_1_);
        }
    }
}

