/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem.seals;

import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.entities.construct.golem.Task;
import thaumcraft.common.entities.construct.golem.TaskHandler;
import thaumcraft.common.entities.construct.golem.seals.ISeal;
import thaumcraft.common.entities.construct.golem.seals.SealEntity;
import thaumcraft.common.lib.aura.AuraHandler;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.misc.PacketSealToClient;
import thaumcraft.common.lib.utils.PosXY;

public class SealHandler {
    public static HashMap<String, ISeal> types = new HashMap();
    private static int lastID = 0;
    public static ConcurrentHashMap<Integer, ConcurrentHashMap<SealEntity.SealPos, SealEntity>> sealEntities = new ConcurrentHashMap();

    public static void registerSeal(ISeal seal) {
        if (types.containsKey(seal.getKey())) {
            Thaumcraft.log.error("Attempting to register Seal [" + seal.getKey() + "] twice.");
        } else {
            types.put(seal.getKey(), seal);
        }
    }

    public static ISeal getSeal(String key) {
        return types.get(key);
    }

    public static CopyOnWriteArrayList<SealEntity> getSealsInChunk(World world, ChunkCoordIntPair chunk) {
        CopyOnWriteArrayList<SealEntity> out = new CopyOnWriteArrayList<SealEntity>();
        ConcurrentHashMap<SealEntity.SealPos, SealEntity> list = sealEntities.get(world.field_73011_w.func_177502_q());
        if (list != null && list.size() > 0) {
            for (SealEntity se : list.values()) {
                ChunkCoordIntPair cc;
                if (se.getSeal() == null || se.getSealPos() == null || !(cc = new ChunkCoordIntPair(se.sealPos.pos.func_177958_n() >> 4, se.sealPos.pos.func_177952_p() >> 4)).equals((Object)chunk)) continue;
                out.add(se);
            }
        }
        return out;
    }

    public static void removeSealEntity(World world, SealEntity.SealPos pos) {
        ConcurrentHashMap<SealEntity.SealPos, SealEntity> se;
        if (!sealEntities.containsKey(world.field_73011_w.func_177502_q())) {
            sealEntities.put(world.field_73011_w.func_177502_q(), new ConcurrentHashMap());
        }
        if ((se = sealEntities.get(world.field_73011_w.func_177502_q())) != null) {
            se.remove(pos);
            Iterator i$ = TaskHandler.sealTaskCrossRef.keySet().iterator();
            while (i$.hasNext()) {
                ConcurrentHashMap<Integer, Task> ts;
                int cr = (Integer)i$.next();
                if (!TaskHandler.sealTaskCrossRef.get(cr).equals(pos) || !(ts = TaskHandler.getTasks(world.field_73011_w.func_177502_q())).containsKey(cr)) continue;
                ts.get(cr).setSuspended(true);
            }
            PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketSealToClient(new SealEntity(world, pos, null)), world.field_73011_w.func_177502_q());
            SealHandler.markChunkAsDirty(world.field_73011_w.func_177502_q(), pos.pos);
        }
    }

    public static SealEntity getSealEntity(int dim, SealEntity.SealPos pos) {
        ConcurrentHashMap<SealEntity.SealPos, SealEntity> se;
        if (!sealEntities.containsKey(dim)) {
            sealEntities.put(dim, new ConcurrentHashMap());
        }
        if ((se = sealEntities.get(dim)) != null) {
            return se.get(pos);
        }
        return null;
    }

    public static boolean addSealEntity(World world, BlockPos pos, EnumFacing face, ISeal seal) {
        SealEntity.SealPos sp;
        ConcurrentHashMap<SealEntity.SealPos, SealEntity> se;
        if (!sealEntities.containsKey(world.field_73011_w.func_177502_q())) {
            sealEntities.put(world.field_73011_w.func_177502_q(), new ConcurrentHashMap());
        }
        if ((se = sealEntities.get(world.field_73011_w.func_177502_q())).containsKey(sp = new SealEntity.SealPos(pos, face))) {
            return false;
        }
        SealEntity sealent = new SealEntity(world, sp, seal);
        se.put(sp, sealent);
        sealent.syncToClient();
        SealHandler.markChunkAsDirty(world.field_73011_w.func_177502_q(), pos);
        return true;
    }

    public static boolean addSealEntity(World world, SealEntity seal) {
        ConcurrentHashMap<SealEntity.SealPos, SealEntity> se;
        if (!sealEntities.containsKey(world.field_73011_w.func_177502_q())) {
            sealEntities.put(world.field_73011_w.func_177502_q(), new ConcurrentHashMap());
        }
        if ((se = sealEntities.get(world.field_73011_w.func_177502_q())).containsKey(seal.getSealPos())) {
            System.out.println("SEAL ALREADY HERE");
            return false;
        }
        se.put(seal.getSealPos(), seal);
        seal.syncToClient();
        SealHandler.markChunkAsDirty(world.field_73011_w.func_177502_q(), seal.getSealPos().pos);
        return true;
    }

    public static void tickSealEntities(World world) {
        if (!sealEntities.containsKey(world.field_73011_w.func_177502_q())) {
            sealEntities.put(world.field_73011_w.func_177502_q(), new ConcurrentHashMap());
        }
        ConcurrentHashMap<SealEntity.SealPos, SealEntity> se = sealEntities.get(world.field_73011_w.func_177502_q());
        for (SealEntity sealEntity : se.values()) {
            sealEntity.tickSealEntity();
        }
    }

    public static void markChunkAsDirty(int dim, BlockPos bp) {
        CopyOnWriteArrayList<PosXY> dc;
        PosXY pos = new PosXY(bp.func_177958_n() >> 4, bp.func_177952_p() >> 4);
        if (!AuraHandler.dirtyChunks.containsKey(dim)) {
            AuraHandler.dirtyChunks.put(dim, new CopyOnWriteArrayList());
        }
        if (!(dc = AuraHandler.dirtyChunks.get(dim)).contains(pos)) {
            dc.add(pos);
        }
    }
}

