/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.wands.foci;

import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftMaterials;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.items.IArchitect;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.IWand;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.items.wands.WandManager;
import thaumcraft.common.lib.events.ServerTickEventsFML;
import thaumcraft.common.lib.utils.BlockUtils;

public class ItemFocusTrade
extends ItemFocusBasic
implements IArchitect {
    private static final AspectList cost = new AspectList().add(Aspect.ENTROPY, 1).add(Aspect.EARTH, 3).add(Aspect.ORDER, 1);
    private static AspectList cost2 = null;
    ArrayList<BlockPos> checked = new ArrayList();

    public ItemFocusTrade() {
        super("equal_trade", 8747923);
    }

    protected MovingObjectPosition getMovingObjectPositionFromPlayer(World par1World, EntityPlayer par2EntityPlayer) {
        float f = 1.0f;
        float f1 = par2EntityPlayer.field_70127_C + (par2EntityPlayer.field_70125_A - par2EntityPlayer.field_70127_C) * f;
        float f2 = par2EntityPlayer.field_70126_B + (par2EntityPlayer.field_70177_z - par2EntityPlayer.field_70126_B) * f;
        double d0 = par2EntityPlayer.field_70169_q + (par2EntityPlayer.field_70165_t - par2EntityPlayer.field_70169_q) * (double)f;
        double d1 = par2EntityPlayer.field_70167_r + (par2EntityPlayer.field_70163_u - par2EntityPlayer.field_70167_r) * (double)f + (double)(par1World.field_72995_K ? par2EntityPlayer.func_70047_e() - par2EntityPlayer.getDefaultEyeHeight() : par2EntityPlayer.func_70047_e());
        double d2 = par2EntityPlayer.field_70166_s + (par2EntityPlayer.field_70161_v - par2EntityPlayer.field_70166_s) * (double)f;
        Vec3 vec3 = new Vec3(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 5.0;
        if (par2EntityPlayer instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)par2EntityPlayer).field_71134_c.getBlockReachDistance();
        }
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return par1World.func_72901_a(vec3, vec31, false);
    }

    @Override
    public boolean onFocusActivation(ItemStack itemstack, World world, EntityLivingBase player, MovingObjectPosition mop, int count) {
        IWand wand = (IWand)itemstack.func_77973_b();
        if (player instanceof EntityPlayer && mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            IBlockState bi = world.func_180495_p(mop.func_178782_a());
            if (player.func_70093_af()) {
                if (!world.field_72995_K && world.func_175625_s(mop.func_178782_a()) == null) {
                    ItemStack isout = new ItemStack(bi.func_177230_c(), 1, bi.func_177230_c().func_176201_c(bi));
                    try {
                        ItemStack is;
                        if (bi != Blocks.field_150350_a && (is = BlockUtils.createStackedBlock(bi)) != null) {
                            isout = is.func_77946_l();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.storePickedBlock(itemstack, isout);
                } else {
                    player.func_71038_i();
                }
            } else {
                ItemStack pb = this.getPickedBlock(itemstack);
                if (pb != null && world.field_72995_K) {
                    player.func_71038_i();
                } else if (pb != null && world.func_175625_s(mop.func_178782_a()) == null && world.func_180495_p(mop.func_178782_a()).func_177230_c().func_149688_o() != ThaumcraftMaterials.MATERIAL_TAINT) {
                    if (this.isUpgradedWith(wand.getFocusStack(itemstack), FocusUpgradeType.architect)) {
                        int sizeX = WandManager.getAreaX(itemstack);
                        int sizeZ = WandManager.getAreaZ(itemstack);
                        ArrayList<BlockPos> blocks = this.getArchitectBlocks(itemstack, world, mop.func_178782_a(), mop.field_178784_b, (EntityPlayer)player);
                        for (BlockPos c : blocks) {
                            ServerTickEventsFML.addSwapper(world, c, world.func_180495_p(c), pb, 0, (EntityPlayer)player, ((EntityPlayer)player).field_71071_by.field_70461_c);
                        }
                    } else {
                        ServerTickEventsFML.addSwapper(world, mop.func_178782_a(), world.func_180495_p(mop.func_178782_a()), pb, 3 + wand.getFocusEnlarge(itemstack), (EntityPlayer)player, ((EntityPlayer)player).field_71071_by.field_70461_c);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean onEntitySwing(EntityLivingBase player, ItemStack stack) {
        if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayer) {
            ItemStack pb = this.getPickedBlock(stack);
            MovingObjectPosition mop = this.getMovingObjectPositionFromPlayer(player.field_70170_p, (EntityPlayer)player);
            if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && pb != null && player.field_70170_p.func_175625_s(mop.func_178782_a()) == null && player.field_70170_p.func_180495_p(mop.func_178782_a()).func_177230_c().func_149688_o() != ThaumcraftMaterials.MATERIAL_TAINT) {
                ServerTickEventsFML.addSwapper(player.field_70170_p, mop.func_178782_a(), player.field_70170_p.func_180495_p(mop.func_178782_a()), pb, 0, (EntityPlayer)player, ((EntityPlayer)player).field_71071_by.field_70461_c);
            }
        }
        return super.onEntitySwing(player, stack);
    }

    public void storePickedBlock(ItemStack stack, ItemStack stackout) {
        NBTTagCompound item = new NBTTagCompound();
        stack.func_77983_a("picked", (NBTBase)stackout.func_77955_b(item));
    }

    public ItemStack getPickedBlock(ItemStack stack) {
        ItemStack out = null;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("picked")) {
            out = new ItemStack(Blocks.field_150350_a);
            out.func_77963_c(stack.func_77978_p().func_74775_l("picked"));
        }
        return out;
    }

    @Override
    public AspectList getVisCost(ItemStack itemstack) {
        if (this.isUpgradedWith(itemstack, FocusUpgradeType.silktouch)) {
            if (cost2 == null) {
                cost2 = new AspectList().add(Aspect.AIR, 1).add(Aspect.FIRE, 1).add(Aspect.EARTH, 1).add(Aspect.WATER, 1).add(Aspect.ORDER, 1);
                cost2.add(cost);
            }
            return cost2;
        }
        return cost;
    }

    @Override
    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack itemstack, int rank) {
        switch (rank) {
            case 1: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge};
            }
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge, FocusUpgradeType.treasure, FocusUpgradeType.architect};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge, FocusUpgradeType.silktouch};
            }
        }
        return null;
    }

    @Override
    public int getMaxAreaSize(ItemStack focusstack) {
        return 3 + this.getUpgradeLevel(focusstack, FocusUpgradeType.enlarge) * 2;
    }

    @Override
    public ArrayList<BlockPos> getArchitectBlocks(ItemStack stack, World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        IWand wand = (IWand)stack.func_77973_b();
        ItemFocusBasic focus = wand.getFocus(stack);
        IBlockState bi = world.func_180495_p(pos);
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        this.checked.clear();
        if (side.func_176740_k() == EnumFacing.Axis.Z) {
            this.checkNeighbours(world, pos, bi, new BlockPos((Vec3i)pos), side, WandManager.getAreaZ(stack), WandManager.getAreaY(stack), WandManager.getAreaX(stack), out, player);
        } else {
            this.checkNeighbours(world, pos, bi, new BlockPos((Vec3i)pos), side, WandManager.getAreaX(stack), WandManager.getAreaY(stack), WandManager.getAreaZ(stack), out, player);
        }
        return out;
    }

    public void checkNeighbours(World world, BlockPos pos1, IBlockState bi, BlockPos pos2, EnumFacing side, int sizeX, int sizeY, int sizeZ, ArrayList<BlockPos> list, EntityPlayer player) {
        if (this.checked.contains(pos2)) {
            return;
        }
        this.checked.add(pos2);
        switch (side.func_176740_k()) {
            case Y: {
                if (Math.abs(pos2.func_177958_n() - pos1.func_177958_n()) > sizeX) {
                    return;
                }
                if (Math.abs(pos2.func_177952_p() - pos1.func_177952_p()) <= sizeZ) break;
                return;
            }
            case Z: {
                if (Math.abs(pos2.func_177958_n() - pos1.func_177958_n()) > sizeX) {
                    return;
                }
                if (Math.abs(pos2.func_177956_o() - pos1.func_177956_o()) <= sizeZ) break;
                return;
            }
            case X: {
                if (Math.abs(pos2.func_177956_o() - pos1.func_177956_o()) > sizeX) {
                    return;
                }
                if (Math.abs(pos2.func_177952_p() - pos1.func_177952_p()) <= sizeZ) break;
                return;
            }
        }
        if (world.func_180495_p(pos2) != bi || !BlockUtils.isBlockExposed(world, pos2) || world.func_175623_d(pos2) || !(world.func_180495_p(pos2).func_177230_c().func_176195_g(world, pos2) >= 0.0f) || !world.canMineBlockBody(player, pos2)) {
            return;
        }
        list.add(pos2);
        for (EnumFacing dir : EnumFacing.values()) {
            if (dir == side || dir.func_176734_d() == side) continue;
            this.checkNeighbours(world, pos1, bi, pos2.func_177972_a(dir), side, sizeX, sizeY, sizeZ, list, player);
        }
    }

    @Override
    public boolean showAxis(ItemStack stack, World world, EntityPlayer player, EnumFacing side, IArchitect.EnumAxis axis) {
        int dim = WandManager.getAreaDim(stack);
        switch (side.func_176740_k()) {
            case Y: {
                if ((axis != IArchitect.EnumAxis.X || dim != 0 && dim != 1) && (axis != IArchitect.EnumAxis.Z || dim != 0 && dim != 2)) break;
                return true;
            }
            case Z: {
                if ((axis != IArchitect.EnumAxis.Y || dim != 0 && dim != 1) && (axis != IArchitect.EnumAxis.X || dim != 0 && dim != 2)) break;
                return true;
            }
            case X: {
                if ((axis != IArchitect.EnumAxis.Y || dim != 0 && dim != 1) && (axis != IArchitect.EnumAxis.Z || dim != 0 && dim != 2)) break;
                return true;
            }
        }
        return false;
    }
}

