/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.crafting;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.IArcaneWorkbench;
import thaumcraft.api.research.ResearchHelper;

public class ShapelessArcaneRecipe
implements IArcaneRecipe {
    private ItemStack output = null;
    private ArrayList input = new ArrayList();
    public AspectList aspects = null;
    public String[] research;

    public ShapelessArcaneRecipe(String research, ItemStack result, AspectList aspects, Object ... recipe) {
        this(new String[]{research}, result, aspects, recipe);
    }

    public ShapelessArcaneRecipe(String[] research, ItemStack result, AspectList aspects, Object ... recipe) {
        this.output = result.func_77946_l();
        this.research = research;
        this.aspects = aspects;
        for (Object in : recipe) {
            if (in instanceof ItemStack) {
                this.input.add(((ItemStack)in).func_77946_l());
                continue;
            }
            if (in instanceof Item) {
                this.input.add(new ItemStack((Item)in));
                continue;
            }
            if (in instanceof Block) {
                this.input.add(new ItemStack((Block)in));
                continue;
            }
            if (in instanceof String) {
                this.input.add(OreDictionary.getOres((String)((String)in)));
                continue;
            }
            String ret = "Invalid shapeless ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
    }

    @Override
    public int func_77570_a() {
        return this.input.size();
    }

    @Override
    public ItemStack func_77571_b() {
        return this.output;
    }

    @Override
    public ItemStack func_77572_b(InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    @Override
    public boolean func_77569_a(InventoryCrafting inv, World world) {
        return inv instanceof IArcaneWorkbench && this.matches(inv, world, null);
    }

    @Override
    public boolean matches(InventoryCrafting var1, World world, EntityPlayer player) {
        if (player != null && this.research != null && this.research[0].length() > 0 && !ResearchHelper.isResearchComplete(player.func_70005_c_(), this.research)) {
            return false;
        }
        ArrayList required = new ArrayList(this.input);
        for (int x = 0; x < 9; ++x) {
            ItemStack slot = var1.func_70301_a(x);
            if (slot == null) continue;
            boolean inRecipe = false;
            Iterator req = required.iterator();
            while (req.hasNext()) {
                boolean match = false;
                Object next = req.next();
                if (next instanceof ItemStack) {
                    match = this.checkItemEquals((ItemStack)next, slot);
                } else if (next instanceof List) {
                    for (ItemStack item : (List)next) {
                        match = match || this.checkItemEquals(item, slot);
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    private boolean checkItemEquals(ItemStack target, ItemStack input) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return !(target.func_77973_b() != input.func_77973_b() || target.func_77942_o() && !ThaumcraftApiHelper.areItemStackTagsEqualForCrafting(input, target) || target.func_77952_i() != Short.MAX_VALUE && target.func_77952_i() != input.func_77952_i());
    }

    public ArrayList getInput() {
        return this.input;
    }

    @Override
    public AspectList getAspects() {
        return this.aspects;
    }

    @Override
    public AspectList getAspects(InventoryCrafting inv) {
        return this.aspects;
    }

    @Override
    public String[] getResearch() {
        return this.research;
    }

    @Override
    public ItemStack[] func_179532_b(InventoryCrafting p_179532_1_) {
        ItemStack[] aitemstack = new ItemStack[p_179532_1_.func_70302_i_()];
        for (int i = 0; i < Math.min(9, aitemstack.length); ++i) {
            ItemStack itemstack = p_179532_1_.func_70301_a(i);
            aitemstack[i] = ForgeHooks.getContainerItem((ItemStack)itemstack);
        }
        return aitemstack;
    }
}

